/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkException;
import dev.jeka.core.tool.JkInjectProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class FieldInjector {
    private static final String UNHANDLED_TYPE = "";

    FieldInjector() {
    }

    static Set<String> inject(Object target, Map<String, String> props) {
        return FieldInjector.inject(target, props, UNHANDLED_TYPE);
    }

    private static Set<String> inject(Object target, Map<String, String> props, String fieldPrefix) {
        HashSet<String> usedProperties = new HashSet<String>();
        for (Field field : FieldInjector.getPropertyFields(target.getClass())) {
            Set<String> matchedKeys = FieldInjector.inject(target, field, props, fieldPrefix);
            usedProperties.addAll(matchedKeys);
        }
        return usedProperties;
    }

    static void injectAnnotatedProperties(Object target) {
        for (Field field : FieldInjector.getPropertyFields(target.getClass())) {
            Object value;
            JkInjectProperty injectProperty = field.getAnnotation(JkInjectProperty.class);
            if (injectProperty == null) continue;
            String propertyName = injectProperty.value();
            if (JkProperties.get(propertyName) == null) {
                JkLog.warn("No property '%s' defined for injecting in field %s.", propertyName, field);
            }
            String propertyValue = JkProperties.get(propertyName);
            Class<?> type = field.getType();
            try {
                value = FieldInjector.parse(type, propertyValue);
            }
            catch (IllegalArgumentException e) {
                throw new JkException("Property " + injectProperty.value() + " has been set with improper value '" + propertyValue + "'", new Object[0]);
            }
            JkUtilsReflect.setFieldValue(target, field, value);
        }
    }

    static List<Field> getPropertyFields(Class<?> clazz) {
        return JkUtilsReflect.getAllDeclaredFields(clazz, true).stream().filter(FieldInjector::isPropertyField).collect(Collectors.toList());
    }

    private static boolean isPropertyField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(field.getModifiers())) {
            return true;
        }
        String setterName = "set" + JkUtilsString.capitalize(field.getName());
        return Arrays.asList(field.getDeclaringClass().getMethods()).stream().map(Method::getName).anyMatch(name -> name.equals(setterName));
    }

    private static Set<String> inject(Object target, Field field, Map<String, String> props, String prefix) {
        String name = field.getName();
        Class<?> type = field.getType();
        boolean present = props.containsKey(name);
        if (present) {
            Object value;
            String stringValue = props.get(name);
            try {
                value = FieldInjector.parse(type, stringValue);
            }
            catch (IllegalArgumentException e) {
                throw new JkException("Option " + name + " has been set with improper value '" + stringValue + "'", new Object[0]);
            }
            if (value == UNHANDLED_TYPE) {
                throw new IllegalArgumentException("Class " + target.getClass().getName() + ", field " + name + ", can't handle type " + type);
            }
            if (Modifier.isFinal(field.getModifiers())) {
                throw new JkException("Can not set value on final " + field.getDeclaringClass().getName() + "#" + field.getName() + " field.", new Object[0]);
            }
            JkUtilsReflect.setFieldValue(target, field, value);
            return Collections.singleton(prefix + name);
        }
        if (FieldInjector.hasKeyStartingWith(name + ".", props)) {
            String fieldPrefix = name + ".";
            Object value = JkUtilsReflect.getFieldValue(target, field);
            if (value == null) {
                value = JkUtilsReflect.newInstance(field.getType());
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new JkException("Can not set value on final " + field.getDeclaringClass().getName() + "#" + field.getName() + " field.", new Object[0]);
                }
                JkUtilsReflect.setFieldValue(target, field, value);
            }
            Map<String, String> subProps = FieldInjector.extractKeyStartingWith(fieldPrefix, props);
            return FieldInjector.inject(value, subProps, prefix + fieldPrefix);
        }
        return Collections.emptySet();
    }

    static Object parse(Class<?> type, String stringValue) throws IllegalArgumentException {
        if (type.equals(String.class)) {
            return stringValue;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(stringValue);
        }
        try {
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return Integer.valueOf(stringValue);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return Long.valueOf(stringValue);
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return Short.valueOf(stringValue);
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return Byte.valueOf(stringValue);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return Double.valueOf(stringValue);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return Float.valueOf(stringValue);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (type.isEnum()) {
            Class<?> enumType = type;
            return Enum.valueOf(enumType, stringValue);
        }
        if (type.equals(File.class)) {
            return new File(stringValue);
        }
        if (type.equals(Path.class)) {
            return Paths.get(stringValue, new String[0]);
        }
        return UNHANDLED_TYPE;
    }

    private static boolean hasKeyStartingWith(String prefix, Map<String, String> values) {
        for (String string : values.keySet()) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> extractKeyStartingWith(String prefix, Map<String, String> values) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : values.keySet()) {
            if (!string.startsWith(prefix)) continue;
            result.put(string.substring(prefix.length()), values.get(string));
        }
        return result;
    }
}

