/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsFile;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.CommandLine;
import dev.jeka.core.tool.FieldInjector;
import dev.jeka.core.tool.JkException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class Environment {
    static CommandLine commandLine = CommandLine.parse(new String[0]);
    static StandardOptions standardOptions = new StandardOptions(Collections.emptyMap());

    private Environment() {
    }

    static void initialize(String[] commandLineArgs) {
        LinkedList<String> effectiveCommandLineArgs = new LinkedList<String>(Arrays.asList(commandLineArgs));
        Map<String, String> presets = Environment.projectCmdProperties();
        List<String> appendedArgs = Arrays.asList(JkUtilsString.translateCommandline(presets.get("_append")));
        effectiveCommandLineArgs.addAll(appendedArgs);
        ListIterator it = effectiveCommandLineArgs.listIterator();
        while (it.hasNext()) {
            String presetValue;
            String word = (String)it.next();
            if (!word.startsWith("$") || (presetValue = presets.get(word.substring(1))) == null) continue;
            String[] replacingItems = JkUtilsString.translateCommandline(presetValue);
            it.remove();
            Arrays.stream(replacingItems).forEach(item -> it.add(item));
        }
        JkLog.trace("Effective command line : " + effectiveCommandLineArgs, new Object[0]);
        CommandLine commandLine = CommandLine.parse(effectiveCommandLineArgs.toArray(new String[0]));
        StandardOptions standardOptions = new StandardOptions(commandLine.getStandardOptions());
        if (standardOptions.logVerbose) {
            JkLog.setVerbosity(JkLog.Verbosity.VERBOSE);
        }
        if (standardOptions.logIvyVerbose) {
            JkLog.setVerbosity(JkLog.Verbosity.QUITE_VERBOSE);
        }
        Environment.commandLine = commandLine;
        Environment.standardOptions = standardOptions;
    }

    static Map<String, String> projectCmdProperties(Path projectDir) {
        Path presetCommandsFile = projectDir.resolve("jeka").resolve("cmd.properties");
        if (Files.exists(presetCommandsFile, new LinkOption[0])) {
            return JkUtilsFile.readPropertyFileAsMap(presetCommandsFile);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> projectCmdProperties() {
        return Environment.projectCmdProperties(Paths.get("", new String[0]));
    }

    static class StandardOptions {
        boolean logIvyVerbose;
        boolean logVerbose;
        boolean logNoAnimation;
        boolean logBanner;
        boolean logDuration;
        boolean logSetup;
        boolean logStackTrace;
        JkLog.Style logStyle;
        boolean logRuntimeInformation;
        boolean ignoreCompileFail;
        private String jkBeanName;
        private boolean workClean;
        private final Set<String> names = new HashSet<String>();

        StandardOptions(Map<String, String> map) {
            this.logVerbose = this.valueOf(Boolean.TYPE, map, false, "Log.verbose", "lv");
            this.logIvyVerbose = this.valueOf(Boolean.TYPE, map, false, "log.ivy.verbose", "liv");
            this.logNoAnimation = this.valueOf(Boolean.TYPE, map, false, "log.no.animation", "lna");
            this.logBanner = this.valueOf(Boolean.TYPE, map, false, "log.banner", "lb");
            this.logDuration = this.valueOf(Boolean.TYPE, map, false, "log.duration", "ld");
            this.logSetup = this.valueOf(Boolean.TYPE, map, false, "log.setup", "lsu");
            this.logStackTrace = this.valueOf(Boolean.TYPE, map, false, "log.stacktrace", "lst");
            this.logRuntimeInformation = this.valueOf(Boolean.TYPE, map, false, "log.runtime.info", "lri");
            this.logStyle = this.valueOf((Class)JkLog.Style.class, map, (Object)((Object)JkLog.Style.INDENT), "log.style", "ls");
            this.jkBeanName = this.valueOf(String.class, map, null, "kbean", "kb");
            this.ignoreCompileFail = this.valueOf(Boolean.TYPE, map, false, "def.compile.ignore-failure", "dci");
            this.workClean = this.valueOf(Boolean.TYPE, map, false, "work.clean", "wc");
        }

        String jkCBeanName() {
            return this.jkBeanName;
        }

        boolean workClean() {
            return this.workClean;
        }

        public String toString() {
            return "JkBean" + JkUtilsObject.toString(this.jkBeanName) + ", LogVerbose=" + this.logVerbose + ", LogHeaders=" + this.logBanner;
        }

        private <T> T valueOf(Class<T> type, Map<String, String> map, T defaultValue, String ... optionNames) {
            for (String name : optionNames) {
                this.names.add(name);
                if (!map.containsKey(name)) continue;
                String stringValue = map.get(name);
                if (type.equals(Boolean.TYPE) && stringValue == null) {
                    return (T)Boolean.TRUE;
                }
                try {
                    return (T)FieldInjector.parse(type, stringValue);
                }
                catch (IllegalArgumentException e) {
                    throw new JkException("Option " + name + " has been set with improper value '" + stringValue + "'", new Object[0]);
                }
            }
            return defaultValue;
        }
    }
}

