/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import dev.jeka.core.tool.CommandLine;
import dev.jeka.core.tool.JkException;
import dev.jeka.core.tool.JkInjectClasspath;
import dev.jeka.core.tool.JkInjectCompileOption;
import dev.jeka.core.tool.JkInjectProject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

final class EngineSourceParser {
    private final JkDependencySet dependencies;
    private final LinkedHashSet<Path> dependencyProjects;
    private final List<String> compileOptions;

    private static EngineSourceParser of(Path baseDir, Path code) {
        return EngineSourceParser.of(baseDir, JkUtilsPath.toUrl(code));
    }

    public static EngineSourceParser of(Path baseDir, Iterable<Path> files) {
        EngineSourceParser result = new EngineSourceParser(JkDependencySet.of(), new LinkedHashSet<Path>(), new LinkedList<String>());
        for (Path code : files) {
            result = result.and(EngineSourceParser.of(baseDir, code));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static EngineSourceParser of(Path baseDir, URL codeUrl) {
        try (InputStream inputStream = JkUtilsIO.inputStream(codeUrl);){
            String unco4mmentedCode = EngineSourceParser.removeComments(inputStream);
            JkDependencySet deps = EngineSourceParser.dependencies(unco4mmentedCode, baseDir, codeUrl);
            LinkedHashSet<Path> projects = EngineSourceParser.projects(unco4mmentedCode, baseDir, codeUrl);
            List<String> compileOptions = EngineSourceParser.compileOptions(unco4mmentedCode, codeUrl);
            EngineSourceParser engineSourceParser = new EngineSourceParser(deps, projects, compileOptions);
            return engineSourceParser;
        }
        catch (IOException e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    private EngineSourceParser(JkDependencySet deps, LinkedHashSet<Path> dependencyProjects, List<String> compileOptions) {
        this.dependencies = deps;
        this.dependencyProjects = dependencyProjects;
        this.compileOptions = compileOptions;
    }

    private EngineSourceParser and(EngineSourceParser other) {
        LinkedHashSet<Path> allDependencyProjects = new LinkedHashSet<Path>(this.dependencyProjects);
        allDependencyProjects.addAll(other.dependencyProjects);
        return new EngineSourceParser(this.dependencies.and(other.dependencies), allDependencyProjects, JkUtilsIterable.concatLists(this.compileOptions, other.compileOptions));
    }

    JkDependencySet dependencies() {
        return this.dependencies;
    }

    LinkedHashSet<Path> projects() {
        return this.dependencyProjects;
    }

    List<String> compileOptions() {
        return this.compileOptions;
    }

    private static JkDependencySet dependencies(String code, Path baseDir, URL url) {
        List<String> deps = EngineSourceParser.stringsInJkImport(code, url);
        return EngineSourceParser.dependenciesFromImports(baseDir, deps);
    }

    private static LinkedHashSet<Path> projects(String code, Path baseDir, URL url) {
        List<String> deps = EngineSourceParser.jkImportRun(code, url);
        return EngineSourceParser.projectDependencies(baseDir, deps);
    }

    private static List<String> compileOptions(String code, URL url) {
        return EngineSourceParser.stringsInAnnotation(code, JkInjectCompileOption.class, url);
    }

    private static JkDependencySet dependenciesFromImports(Path baseDir, List<String> deps) {
        JkDependencySet result = JkDependencySet.of();
        for (String dependencyDescription : deps) {
            JkDependency dep = CommandLine.toDependency(dependencyDescription);
            result = result.and(dep);
        }
        return result;
    }

    private static boolean isModuleDependencyDescription(String candidate) {
        if (candidate.contains("/") || candidate.contains("\\")) {
            return false;
        }
        int colonCount = JkUtilsString.countOccurrence(candidate, ':');
        return colonCount >= 1;
    }

    private static LinkedHashSet<Path> projectDependencies(Path baseDir, List<String> deps) {
        LinkedHashSet<Path> projects = new LinkedHashSet<Path>();
        for (String projectReltivePath : deps) {
            Path file = baseDir.resolve(projectReltivePath).normalize();
            if (!Files.exists(file, new LinkOption[0])) {
                throw new JkException("Folder " + file + " defined as project does not exists.", new Object[0]);
            }
            projects.add(file);
        }
        return projects;
    }

    private static List<String> stringsInJkImport(String code, URL url) {
        return EngineSourceParser.stringsInAnnotation(code, JkInjectClasspath.class, url);
    }

    private static List<String> stringsInAnnotation(String code, Class<?> annotationClass, URL url) {
        LinkedList<String> result = new LinkedList<String>();
        try (Scanner scanner = new Scanner(code);){
            scanner.useDelimiter("");
            while (scanner.hasNext()) {
                String jkImportWord = scanner.findInLine("@" + annotationClass.getSimpleName());
                if (jkImportWord == null) {
                    String nextLine = scanner.nextLine();
                    if (!EngineSourceParser.removeQuotes(nextLine).contains("class ")) continue;
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                String context = " parsing @" + annotationClass.getSimpleName();
                String between = EngineSourceParser.extractStringTo(scanner, "(", url, context);
                if (!EngineSourceParser.containsOnly(between, " ", "\n", "\r", "\t")) continue;
                result.addAll(EngineSourceParser.scanInsideAnnotation(scanner, url, context));
            }
        }
        return result;
    }

    private static boolean containsOnly(String stringToMatch, String ... candidates) {
        String left = stringToMatch;
        for (String candidate : candidates) {
            left = left.replace(candidate, "");
        }
        return left.isEmpty();
    }

    private static List<String> jkImportRun(String code, URL url) {
        return EngineSourceParser.stringsInAnnotation(code, JkInjectProject.class, url);
    }

    private static List<String> scanInsideAnnotation(Scanner scanner, URL url, String context) {
        String betweenParenthesis = EngineSourceParser.extractStringTo(scanner, ")", url, context);
        List<String> items = EngineSourceParser.splitIgnoringQuotes(betweenParenthesis);
        for (String item : items) {
            String trimedItem = item.trim();
            if (trimedItem.startsWith("\"")) {
                return JkUtilsIterable.listOf(EngineSourceParser.withoutQuotes(trimedItem));
            }
            if (trimedItem.startsWith("{")) {
                return EngineSourceParser.curlyBraceToStrings(betweenParenthesis, url, context);
            }
            if (!trimedItem.startsWith("value ") && !trimedItem.startsWith("of=")) continue;
            String after = JkUtilsString.substringAfterFirst(trimedItem, "=").trim();
            if (after.startsWith("\"")) {
                return JkUtilsIterable.listOf(EngineSourceParser.withoutQuotes(after));
            }
            if (!after.startsWith("{")) continue;
            return EngineSourceParser.curlyBraceToStrings(after, url, context);
        }
        return Collections.EMPTY_LIST;
    }

    private static List<String> curlyBraceToStrings(String input, URL url, String context) {
        Scanner innerScanner = new Scanner(input);
        innerScanner.useDelimiter("");
        String braced = EngineSourceParser.extractStringTo(innerScanner, "}", url, context);
        List<String> elements = EngineSourceParser.splitIgnoringQuotes(braced);
        LinkedList<String> result = new LinkedList<String>();
        for (String element : elements) {
            result.add(EngineSourceParser.withoutQuotes(element));
        }
        return result;
    }

    private static String withoutQuotes(String string) {
        return JkUtilsString.substringBeforeLast(JkUtilsString.substringAfterFirst(string, "\""), "\"");
    }

    private static List<String> splitIgnoringQuotes(String input) {
        LinkedList<String> result = new LinkedList<String>();
        int start = 0;
        boolean inQuotes = false;
        for (int current = 0; current < input.length(); ++current) {
            boolean atLastChar;
            if (input.charAt(current) == '\"') {
                inQuotes = !inQuotes;
            }
            boolean bl = atLastChar = current == input.length() - 1;
            if (atLastChar) {
                result.add(input.substring(start));
                continue;
            }
            if (input.charAt(current) != ',' || inQuotes) continue;
            result.add(input.substring(start, current));
            start = current + 1;
        }
        return result;
    }

    private static String extractStringTo(Scanner scanner, String delimiter, URL url, String context) {
        boolean inQuote = false;
        boolean escaping = false;
        StringBuilder builder = new StringBuilder();
        StringBuilder all = new StringBuilder();
        block8: while (scanner.hasNext()) {
            String character = scanner.next();
            all.append(character);
            if (!inQuote) {
                if (character.equals("\"")) {
                    inQuote = true;
                    builder.append(character);
                    continue;
                }
                if (character.equals(delimiter)) {
                    return builder.toString();
                }
                builder.append(character);
                continue;
            }
            if (escaping) {
                escaping = false;
                continue;
            }
            switch (character) {
                case "\\": {
                    escaping = true;
                    continue block8;
                }
                case "\"": {
                    inQuote = false;
                    builder.append(character);
                    continue block8;
                }
            }
            builder.append(character);
        }
        throw new IllegalStateException("No matching " + delimiter + " found" + context + " in " + url + ". " + all.toString());
    }

    private static String removeQuotes(String line) {
        boolean inQuote = false;
        boolean escaping = false;
        StringBuilder builder = new StringBuilder();
        Scanner scanner = new Scanner(line);
        while (scanner.hasNext()) {
            String character = scanner.next();
            if (!inQuote) {
                if (character.equals("\"")) {
                    inQuote = true;
                    continue;
                }
                builder.append(character);
                continue;
            }
            if (escaping) {
                escaping = false;
                continue;
            }
            if (character.equals("\\")) {
                escaping = true;
                continue;
            }
            if (!character.equals("\"")) continue;
            inQuote = false;
        }
        scanner.close();
        return builder.toString();
    }

    private static String removeComments(InputStream inputStream) {
        boolean outsideComment = false;
        boolean insideLineComment = true;
        int insideblockComment = 2;
        boolean insideStringLiteral = false;
        int insideblockComment_noNewLineYet = 3;
        int currentState = 0;
        StringBuilder endResult = new StringBuilder();
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("");
        while (scanner.hasNext()) {
            String character = scanner.next();
            block0 : switch (currentState) {
                case 0: {
                    String c2;
                    if (insideStringLiteral) {
                        if (character.equals("\"")) {
                            insideStringLiteral = false;
                        }
                        endResult.append(character);
                        break;
                    }
                    if (character.equals("/") && scanner.hasNext()) {
                        switch (c2 = scanner.next()) {
                            case "/": {
                                currentState = 1;
                                break block0;
                            }
                            case "*": {
                                currentState = 3;
                                break block0;
                            }
                        }
                        endResult.append(character).append(c2);
                        break;
                    }
                    if (character.equals("\"")) {
                        insideStringLiteral = true;
                        endResult.append(character);
                        break;
                    }
                    endResult.append(character);
                    break;
                }
                case 1: {
                    if (!character.equals("\n")) break;
                    currentState = 0;
                    endResult.append("\n");
                    break;
                }
                case 3: {
                    if (!character.equals("\n")) break;
                    endResult.append("\n");
                    currentState = 2;
                    break;
                }
                case 2: {
                    String c2;
                    while (character.equals("*") && scanner.hasNext()) {
                        c2 = scanner.next();
                        if (!c2.equals("/")) continue;
                        currentState = 0;
                        break block0;
                    }
                    break;
                }
            }
        }
        scanner.close();
        return endResult.toString();
    }
}

