/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;

class EngineCompilationUpdateTracker {
    private static final String LAST_UPDATE_FILE_NAME = "def-last-update-time.txt";
    private final Path projectBaseDir;
    private static boolean globallyOutdated;

    EngineCompilationUpdateTracker(Path projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    boolean isOutdated() {
        if (globallyOutdated) {
            JkLog.trace("Compilation cache outdated.", new Object[0]);
            return true;
        }
        boolean result = this.isWorkOutdated();
        JkLog.trace("Cached compile outdated : %s", result);
        globallyOutdated = result;
        return result;
    }

    void updateCompileFlag() {
        long defLastUptateTime = this.lastModifiedAccordingFileAttributes();
        int fileCount = this.fileCount();
        JkLog.trace("Cached file count for compilation : %s", fileCount);
        this.writeLastUpdateFile(fileCount, defLastUptateTime, JkJavaVersion.ofCurrent());
    }

    void deleteCompileFlag() {
        this.flagFile().deleteIfExist();
    }

    private boolean isWorkOutdated() {
        CountTimestampAndJavaVersion flag = this.stateFromFlagFile();
        CountTimestampAndJavaVersion current = this.stateFromFlagCurrent();
        JkLog.trace("Comparing flagged %s and  current %s", flag, current);
        return !flag.equals(current);
    }

    private long lastModifiedAccordingFileAttributes() {
        Path def = this.projectBaseDir.resolve("jeka/def");
        Stream stream = JkPathTree.of(def).stream(new FileVisitOption[0]);
        return stream.map(path -> JkUtilsPath.getLastModifiedTime(path, new LinkOption[0])).map(optional -> optional.orElse(System.currentTimeMillis())).reduce(0L, Math::max);
    }

    private void writeLastUpdateFile(int fileCount, long lastModifiedAccordingFileAttributes, JkJavaVersion javaVersion) {
        Path work = this.projectBaseDir.resolve("jeka/.work");
        if (!Files.exists(work, new LinkOption[0])) {
            return;
        }
        String infoString = String.format("%s;%s;%s", fileCount, lastModifiedAccordingFileAttributes, javaVersion);
        this.flagFile().deleteIfExist().createIfNotExist().write(infoString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private JkPathFile flagFile() {
        return JkPathFile.of(this.projectBaseDir.resolve("jeka/.work").resolve(LAST_UPDATE_FILE_NAME));
    }

    private CountTimestampAndJavaVersion stateFromFlagCurrent() {
        long defLastUptateTime = this.lastModifiedAccordingFileAttributes();
        return new CountTimestampAndJavaVersion(this.fileCount(), defLastUptateTime, JkJavaVersion.ofCurrent());
    }

    private CountTimestampAndJavaVersion stateFromFlagFile() {
        Path work = this.projectBaseDir.resolve("jeka/.work");
        if (!Files.exists(work, new LinkOption[0])) {
            return new CountTimestampAndJavaVersion(0, 0L, JkJavaVersion.ofCurrent());
        }
        Path lastUpdateFile = work.resolve(LAST_UPDATE_FILE_NAME);
        if (!Files.exists(lastUpdateFile, new LinkOption[0])) {
            return new CountTimestampAndJavaVersion(0, 0L, JkJavaVersion.ofCurrent());
        }
        try {
            String content = JkUtilsPath.readAllLines(lastUpdateFile).get(0);
            String[] items = content.split(";");
            if (items.length != 3) {
                return new CountTimestampAndJavaVersion(0, 0L, JkJavaVersion.ofCurrent());
            }
            return new CountTimestampAndJavaVersion(Integer.parseInt(items[0]), Long.parseLong(items[1]), JkJavaVersion.of(items[2]));
        }
        catch (RuntimeException e) {
            JkLog.warn("Error caught when reading file content of " + lastUpdateFile + ". " + e.getMessage(), new Object[0]);
            return new CountTimestampAndJavaVersion(0, 0L, JkJavaVersion.ofCurrent());
        }
    }

    private int fileCount() {
        return ((JkPathTree)JkPathTree.of(this.projectBaseDir.toAbsolutePath()).andMatching("jeka/def/**", "jeka/boot/**")).count(5000, true);
    }

    private static class CountTimestampAndJavaVersion {
        final int fileCount;
        final long timestamp;
        final JkJavaVersion javaVersion;

        public CountTimestampAndJavaVersion(int fileCount, long timestamp, JkJavaVersion javaVersion) {
            this.fileCount = fileCount;
            this.timestamp = timestamp;
            this.javaVersion = javaVersion;
        }

        public String toString() {
            return "{fileCount=" + this.fileCount + ", timestamp=" + this.timestamp + ", javaVersion=" + this.javaVersion + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountTimestampAndJavaVersion that = (CountTimestampAndJavaVersion)o;
            if (this.fileCount != that.fileCount) {
                return false;
            }
            if (this.timestamp != that.timestamp) {
                return false;
            }
            return this.javaVersion.equals(that.javaVersion);
        }

        public int hashCode() {
            int result = this.fileCount;
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + this.javaVersion.hashCode();
            return result;
        }
    }
}

