/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class EngineClasspathCache {
    private static final String UNRESOLVED_CLASSPATH_FILE = "unresolved-classpath.txt";
    private static final String RESOLVED_CLASSPATH_FILE = "resolved-classpath.txt";
    private final Path baseDir;
    private final JkDependencyResolver dependencyResolver;

    EngineClasspathCache(Path baseDir, JkDependencyResolver dependencyResolver) {
        this.baseDir = baseDir;
        this.dependencyResolver = dependencyResolver;
    }

    Result resolvedClasspath(JkDependencySet dependencySet) {
        boolean changed = this.compareAndStore(dependencySet);
        if (changed) {
            JkPathSequence pathSequence = this.dependencyResolver.resolve(dependencySet).getFiles();
            this.storeResolvedClasspath(pathSequence);
            return new Result(true, pathSequence);
        }
        if (Files.exists(this.resolvedClasspathCache(), new LinkOption[0])) {
            JkPathSequence cachedPathSequence = this.readCachedResolvedClasspath();
            JkLog.trace("Cached resolved-classpath : " + cachedPathSequence.toPath(), new Object[0]);
            if (cachedPathSequence.hasNonExisting()) {
                JkLog.trace("Cached classpath contains some non-existing element -> need resolve.", new Object[0]);
                this.dependencyResolver.resolve(dependencySet);
            }
            return new Result(false, cachedPathSequence);
        }
        JkPathSequence resolved = this.dependencyResolver.resolve(dependencySet).getFiles();
        this.storeResolvedClasspath(resolved);
        return new Result(false, resolved);
    }

    private boolean compareAndStore(JkDependencySet dependencySet) {
        String cachedContent;
        Path cacheFile = this.unresolvedClasspathCache();
        String content = dependencySet.getEntries().toString();
        if (Files.exists(cacheFile, new LinkOption[0]) && content.equals(cachedContent = new String(JkUtilsPath.readAllBytes(cacheFile)))) {
            JkLog.trace("unresolved-classpath has not changed -> can use 'resolved-classpath' file to determine classpath .", new Object[0]);
            return false;
        }
        JkLog.trace("Update cached 'unresolved-classpath'.", new Object[0]);
        if (Files.exists(cacheFile.getParent().getParent(), new LinkOption[0])) {
            JkPathFile.of(cacheFile).createIfNotExist().write(content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return true;
    }

    private void storeResolvedClasspath(JkPathSequence pathSequence) {
        if (!Files.exists(this.resolvedClasspathCache().getParent().getParent(), new LinkOption[0])) {
            return;
        }
        JkPathFile.of(this.resolvedClasspathCache()).createIfNotExist().write(pathSequence.toPath().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private JkPathSequence readCachedResolvedClasspath() {
        return JkPathSequence.ofPathString(JkPathFile.of(this.resolvedClasspathCache()).readAsString());
    }

    private Path unresolvedClasspathCache() {
        return this.baseDir.resolve("jeka/.work").resolve(UNRESOLVED_CLASSPATH_FILE);
    }

    private Path resolvedClasspathCache() {
        return this.baseDir.resolve("jeka/.work").resolve(RESOLVED_CLASSPATH_FILE);
    }

    static class Result {
        final boolean changed;
        final JkPathSequence resolvedClasspath;

        public Result(boolean changed, JkPathSequence resolvedClasspath) {
            this.changed = changed;
            this.resolvedClasspath = resolvedClasspath;
        }
    }
}

