/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkInternalClasspathScanner;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.tool.CommandLine;
import dev.jeka.core.tool.Engine;
import dev.jeka.core.tool.EngineCommand;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkException;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class EngineBeanClassResolver {
    private static final String JAVA_HOME = JkUtilsPath.toUrl(Paths.get(System.getProperty("java.home"), new String[0])).toString();
    private static final String CACHE_FILENAME = "kbean-classes.txt";
    private final Path baseDir;
    final Path defSourceDir;
    final Path defClassDir;
    private JkPathSequence classpath;
    private List<String> cachedDefBeanClassNames;
    private List<String> cachedGlobalBeanClassName;
    private boolean useStoredCache;

    EngineBeanClassResolver(Path baseDir) {
        this.baseDir = baseDir;
        this.defSourceDir = baseDir.resolve("jeka/def");
        this.defClassDir = baseDir.resolve("jeka/.work/def-classes");
    }

    List<EngineCommand> resolve(CommandLine commandLine, String defaultBeanName) {
        JkLog.startTask("Resolve KBean classes", new Object[0]);
        HashMap<String, Class<? extends JkBean>> beanClasses = new HashMap<String, Class<? extends JkBean>>();
        for (String beanName : commandLine.involvedBeanNames()) {
            List<String> beanClassNames = JkUtilsIterable.concatLists(this.defBeanClassNames(), this.globalBeanClassNames()).stream().distinct().collect(Collectors.toList());
            List<String> matchingClassNames = EngineBeanClassResolver.findClassesMatchingName(beanClassNames, beanName);
            if (matchingClassNames.isEmpty()) {
                JkLog.trace("KBean '%s' does not match any class names on %s. Rescan classpath", beanName, beanClasses);
                this.reloadGlobalBeanClassNames();
                matchingClassNames = EngineBeanClassResolver.findClassesMatchingName(beanClassNames, beanName);
                if (matchingClassNames.isEmpty()) {
                    JkLog.trace("KBean '%s' does not match any class names on %s. Fail.", new Object[0]);
                }
            }
            Class<? extends JkBean> selected = this.loadUniqueClassOrFail(matchingClassNames, beanName);
            beanClasses.put(JkBean.name(selected), selected);
        }
        Class<? extends JkBean> defaultBeanClass = this.defaultBeanClass(defaultBeanName);
        LinkedList<EngineCommand> result = new LinkedList<EngineCommand>();
        if (defaultBeanClass == null && commandLine.containsDefaultBean()) {
            throw new JkException("Cannot find any KBean in jeka/def dir. Use -kb=[beanName] to precise a bean present in classpath or create a class extending JkBean into jeka/def dir.", new Object[0]);
        }
        beanClasses.put(null, defaultBeanClass);
        if (defaultBeanClass != null) {
            result.add(new EngineCommand(EngineCommand.Action.BEAN_INSTANTIATION, defaultBeanClass, null, null));
        }
        commandLine.getBeanActions().stream().map(action -> this.toEngineCommand((CommandLine.JkBeanAction)action, (Map<String, Class<? extends JkBean>>)beanClasses)).forEach(result::add);
        JkLog.endTask();
        return Collections.unmodifiableList(result);
    }

    void setClasspath(JkPathSequence classpath, boolean classpathChanged) {
        this.classpath = classpath;
        this.useStoredCache = !classpathChanged;
    }

    private Class<? extends JkBean> defaultBeanClass(String defaultBeanName) {
        if (defaultBeanName == null) {
            if (this.defBeanClassNames().isEmpty()) {
                return null;
            }
            return this.defBeanClasses().get(0);
        }
        List<String> matchingclassNames = EngineBeanClassResolver.findClassesMatchingName(this.defBeanClassNames(), defaultBeanName);
        if (matchingclassNames.isEmpty()) {
            matchingclassNames = EngineBeanClassResolver.findClassesMatchingName(this.globalBeanClassNames(), defaultBeanName);
        }
        return this.loadUniqueClassOrFail(matchingclassNames, defaultBeanName);
    }

    private Class<? extends JkBean> loadUniqueClassOrFail(List<String> matchingBeanClasses, String beanName) {
        if (matchingBeanClasses.isEmpty()) {
            throw this.beanClassNotFound(beanName);
        }
        if (matchingBeanClasses.size() > 1) {
            throw new JkException("Several classes matches default bean name '" + beanName + "' : " + matchingBeanClasses + ". Please precise the fully qualified class name of the default bean instead of its short name.", new Object[0]);
        }
        Class result = JkClassLoader.ofCurrent().loadIfExist(matchingBeanClasses.get(0));
        if (result == null) {
            this.reloadGlobalBeanClassNames();
            throw new JkException("No class " + matchingBeanClasses.get(0) + " found in classpath", new Object[0]);
        }
        return result;
    }

    private JkException beanClassNotFound(String name) {
        return new JkException("Can not find a KBean named '" + name + "'.\nUse the name can be the fully qualified class name of the KBean, its uncapitalized simple class name or its uncapitalized simple class name without the 'JkBean' suffix.\nExecute jeka -help to display available beans.\nAvailable KBeans :\n  " + String.join((CharSequence)"\n  ", this.globalBeanClassNames()) + "\nCurrent classloader :\n" + JkClassLoader.ofCurrent() + "\n", new Object[0]);
    }

    List<String> globalBeanClassNames() {
        if (this.cachedGlobalBeanClassName == null) {
            List<String> storedClassNames;
            if (this.useStoredCache && !(storedClassNames = this.readKbeanClasses()).isEmpty()) {
                this.cachedGlobalBeanClassName = storedClassNames;
                return this.cachedGlobalBeanClassName;
            }
            this.reloadGlobalBeanClassNames();
        }
        return this.cachedGlobalBeanClassName;
    }

    private void reloadGlobalBeanClassNames() {
        long t0 = System.currentTimeMillis();
        ClassLoader classLoader = JkClassLoader.ofCurrent().get();
        boolean ignoreParent = false;
        if (this.classpath != null) {
            classLoader = new URLClassLoader(this.classpath.toUrls());
            ignoreParent = true;
        }
        this.cachedGlobalBeanClassName = JkInternalClasspathScanner.of().findClassedExtending(classLoader, JkBean.class, path -> true, true, false);
        if (JkLog.isVerbose()) {
            JkLog.trace("All JkBean classes scanned in " + (System.currentTimeMillis() - t0) + " ms.", new Object[0]);
            this.cachedGlobalBeanClassName.forEach(className -> JkLog.trace("  " + className, new Object[0]));
        }
        this.storeGlobalKbeanClasses(this.cachedGlobalBeanClassName);
    }

    List<Class<? extends JkBean>> defBeanClasses() {
        List<Class<? extends JkBean>> result = this.defBeanClassNames().stream().sorted().map(className -> JkClassLoader.ofCurrent().load((String)className)).collect(Collectors.toList());
        return result;
    }

    boolean hasDefSource() {
        if (!Files.exists(this.defSourceDir, new LinkOption[0])) {
            return false;
        }
        return ((JkPathTree)JkPathTree.of(this.defSourceDir).andMatching(true, "**.java", "*.java", "**.kt", "*.kt")).count(0, false) > 0;
    }

    private List<String> defBeanClassNames() {
        if (this.cachedDefBeanClassNames == null) {
            long t0 = System.currentTimeMillis();
            ClassLoader classLoader = JkClassLoader.ofCurrent().get();
            boolean ignoreParent = false;
            if (this.classpath != null) {
                classLoader = new URLClassLoader(JkPathSequence.of().and(this.defClassDir).toUrls());
                ignoreParent = true;
            }
            this.cachedDefBeanClassNames = JkInternalClasspathScanner.of().findClassedExtending(classLoader, JkBean.class, EngineBeanClassResolver::scan, true, ignoreParent);
            if (JkLog.isVerbose()) {
                JkLog.trace("Def JkBean classes scanned in " + (System.currentTimeMillis() - t0) + " ms.", new Object[0]);
                this.cachedDefBeanClassNames.forEach(className -> JkLog.trace("  " + className, new Object[0]));
            }
        }
        return this.cachedDefBeanClassNames;
    }

    private static boolean scan(String pathElement) {
        return !pathElement.startsWith(JAVA_HOME);
    }

    private EngineCommand toEngineCommand(CommandLine.JkBeanAction action, Map<String, Class<? extends JkBean>> beanClasses) {
        Class<? extends JkBean> beanClass = action.beanName == null ? beanClasses.get(null) : this.getJkBeanClass(beanClasses.values(), action.beanName);
        return new EngineCommand(action.action, beanClass, action.member, action.value);
    }

    private Class<? extends JkBean> getJkBeanClass(Collection<Class<? extends JkBean>> beanClasses, String name) {
        return beanClasses.stream().filter(Objects::nonNull).filter(beanClass -> JkBean.nameMatches(beanClass.getName(), name)).findFirst().orElseThrow(() -> this.beanClassNotFound(name));
    }

    private static List<String> findClassesMatchingName(List<String> beanClassNameCandidates, String name) {
        return beanClassNameCandidates.stream().filter(className -> JkBean.nameMatches(className, name)).collect(Collectors.toList());
    }

    private JkPathTree defSources() {
        return JkPathTree.of(this.defSourceDir).withMatcher(Engine.JAVA_OR_KOTLIN_SOURCE_MATCHER);
    }

    private void storeGlobalKbeanClasses(List<String> classNames) {
        Path store = this.baseDir.resolve("jeka/.work").resolve(CACHE_FILENAME);
        if (!Files.exists(store.getParent().getParent(), new LinkOption[0])) {
            return;
        }
        String content = String.join((CharSequence)System.lineSeparator(), classNames);
        JkPathFile.of(store).createIfNotExist().write(content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    List<String> readKbeanClasses() {
        Path store = this.baseDir.resolve("jeka/.work").resolve(CACHE_FILENAME);
        if (!Files.exists(store, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return JkUtilsPath.readAllLines(store);
    }
}

