/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class JkUtilsXml {
    private JkUtilsXml() {
    }

    public static Document createDocument() {
        DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder icBuilder = icFactory.newDocumentBuilder();
            return icBuilder.newDocument();
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public static Document documentFrom(File documentFile) {
        if (!documentFile.exists()) {
            throw new IllegalStateException(documentFile.getAbsolutePath() + " file not found.");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(documentFile);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing file " + documentFile.getPath(), e);
        }
    }

    public static Document documentFrom(Path documentFile) {
        if (!Files.exists(documentFile, new LinkOption[0])) {
            throw new IllegalStateException(documentFile.toAbsolutePath().normalize() + " file not found.");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(documentFile.toFile());
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing file " + documentFile, e);
        }
    }

    public static Document documentFrom(String xml) {
        return JkUtilsXml.documentFrom(new StringReader(xml));
    }

    public static Document documentFrom(Reader reader) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(reader));
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing xml", e);
        }
    }

    public static Element directChild(Node parent, String childName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals(childName)) continue;
            return element;
        }
        return null;
    }

    public static List<Element> directChildren(Element parent, String childName) {
        LinkedList<Element> result = new LinkedList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals(childName)) continue;
            result.add(element);
        }
        return result;
    }

    public static String directChildText(Element parent, String childName) {
        Element child = JkUtilsXml.directChild(parent, childName);
        if (child == null) {
            return null;
        }
        return child.getTextContent();
    }

    public static void output(Document doc, OutputStream outputStream) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult console = new StreamResult(outputStream);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }
}

