/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import java.io.PrintStream;
import java.util.function.Consumer;

public final class JkUtilsThrowable {
    private JkUtilsThrowable() {
    }

    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException unchecked(Throwable e, String message) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(message, e);
    }

    public static boolean nestedContains(Throwable throwable, Class<Exception> exceptionClass, String message) {
        if (throwable.getClass().equals(exceptionClass) && message.equals(throwable.getMessage())) {
            return true;
        }
        if (throwable.getCause() == null) {
            return false;
        }
        return JkUtilsThrowable.nestedContains(throwable.getCause(), exceptionClass, message);
    }

    public static boolean isInCause(Throwable throwable, Class<? extends Throwable> causeClass) {
        if (causeClass.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return false;
        }
        return JkUtilsThrowable.isInCause(cause, causeClass);
    }

    public static void printStackTrace(PrintStream printStream, Throwable e, int maxElement) {
        printStream.println(e.getClass().getName() + ": " + e.getMessage());
        StackTraceElement[] stack = e.getStackTrace();
        int count = 0;
        for (StackTraceElement element : stack) {
            if (++count > maxElement) break;
            printStream.print("    at ");
            printStream.println(element.toString());
        }
        if (count < stack.length) {
            printStream.println("    ...");
        }
        if (e.getCause() != null) {
            printStream.print("Caused by: ");
            JkUtilsThrowable.printStackTrace(printStream, e.getCause(), maxElement);
        }
    }

    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;

        public static <T, E extends Throwable> Consumer<T> unchecked(ThrowingConsumer<T, E> consumer) {
            return t -> {
                try {
                    consumer.accept(t);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

