/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class JkUtilsSystem {
    public static final boolean IS_WINDOWS = JkUtilsSystem.isWindows();
    public static final boolean IS_MACOS = JkUtilsSystem.isMacos();
    private static final Class UNSAFE_CLASS = JkClassLoader.ofCurrent().loadIfExist("sun.misc.Unsafe");

    private JkUtilsSystem() {
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private static boolean isMacos() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.startsWith("Mac OS X");
    }

    public static List<Path> classloaderEntries(URLClassLoader classLoader) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (URL url : classLoader.getURLs()) {
            String pathName;
            try {
                pathName = url.toURI().getPath().replaceAll("%20", " ").trim();
            }
            catch (URISyntaxException e) {
                throw JkUtilsThrowable.unchecked(e);
            }
            String fileName = new File(pathName).getAbsolutePath();
            if (fileName.endsWith("*")) {
                String parent = JkUtilsString.substringBeforeLast(fileName, "/*");
                JkUtilsPath.listDirectChildren(Paths.get(parent, new String[0])).stream().filter(item -> item.toString().toLowerCase().endsWith(".jar")).forEach(item -> result.add((Path)item));
                continue;
            }
            result.add(Paths.get(fileName, new String[0]));
        }
        return result;
    }

    public static void disableUnsafeWarning() {
        if (UNSAFE_CLASS == null) {
            return;
        }
        try {
            Field theUnsafe = UNSAFE_CLASS.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Object unsafe = theUnsafe.get(null);
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            Method staticFieldOffsetMethod = UNSAFE_CLASS.getMethod("staticFieldOffset", Field.class);
            long staticFieldOffset = (Long)staticFieldOffsetMethod.invoke(unsafe, logger);
            Method putObjectVolatileMethod = UNSAFE_CLASS.getMethod("putObjectVolatile", Object.class, Long.class, Object.class);
            putObjectVolatileMethod.invoke(cls, staticFieldOffset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

