/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.utils;

import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;

public final class JkUtilsFile {
    private static Properties readPropertyFile(Path propertyFile) {
        Properties props = new Properties();
        try (InputStream fileInputStream = Files.newInputStream(propertyFile, new OpenOption[0]);){
            props.load(fileInputStream);
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
        return props;
    }

    public static Map<String, String> readPropertyFileAsMap(Path propertyFile) {
        Properties properties = JkUtilsFile.readPropertyFile(propertyFile);
        return JkUtilsIterable.propertiesToMap(properties);
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

