/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling.intellij;

import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.tooling.intellij.JkIml;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkRuntime;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class JkImlGenerator {
    private JkPathSequence defClasspath = JkPathSequence.of();
    private JkPathSequence defImportedProjects = JkPathSequence.of();
    private boolean useVarPath = true;
    private Path explicitJekaHome;
    private JkIdeSupport ideSupport;
    private Path baseDir;
    private boolean excludeJekaLib;
    private Consumer<JkIml> imlConfigurer = jkIml -> {};
    private boolean failOnDepsResolutionError = true;

    private JkImlGenerator() {
    }

    public static JkImlGenerator of() {
        return new JkImlGenerator();
    }

    public static Path getImlFilePath(Path dir) {
        String fileName = dir.getFileName().toString().equals("") ? dir.toAbsolutePath().getFileName().toString() : dir.getFileName().toString();
        return JkImlGenerator.findExistingImlFile(dir).orElse(dir.resolve(".idea").resolve(fileName + ".iml"));
    }

    public boolean isUseVarPath() {
        return this.useVarPath;
    }

    public JkImlGenerator setUseVarPath(boolean useVarPath) {
        this.useVarPath = useVarPath;
        return this;
    }

    public JkImlGenerator setDefClasspath(JkPathSequence defClasspath) {
        this.defClasspath = defClasspath;
        return this;
    }

    public JkImlGenerator setDefImportedProjects(JkPathSequence defImportedProjects) {
        JkUtilsAssert.argument(defImportedProjects != null, "defImportedProjects cannot be null.", new Object[0]);
        this.defImportedProjects = defImportedProjects;
        return this;
    }

    public JkImlGenerator setBaseDir(Path baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public JkImlGenerator configureIml(Consumer<JkIml> imlConfigurer) {
        this.imlConfigurer = this.imlConfigurer.andThen(imlConfigurer);
        return this;
    }

    public Path getExplicitJekaHome() {
        return this.explicitJekaHome;
    }

    public JkImlGenerator setExplicitJekaHome(Path explicitJekaHome) {
        this.explicitJekaHome = explicitJekaHome;
        return this;
    }

    public JkIdeSupport getIdeSupport() {
        return this.ideSupport;
    }

    public JkImlGenerator setIdeSupport(JkIdeSupport ideSupport) {
        this.ideSupport = ideSupport;
        return this;
    }

    public JkImlGenerator setExcludeJekaLib(boolean excludeJekaLib) {
        this.excludeJekaLib = excludeJekaLib;
        return this;
    }

    public JkImlGenerator setFailOnDepsResolutionError(boolean failOnDepsResolutionError) {
        this.failOnDepsResolutionError = failOnDepsResolutionError;
        return this;
    }

    public JkIml computeIml() {
        Path dir = this.ideSupport == null ? this.baseDir : this.ideSupport.getProdLayout().getBaseDir();
        JkIml iml = JkIml.of().setModuleDir(dir);
        JkLog.trace("Compute iml def classpath : " + this.defClasspath, new Object[0]);
        JkLog.trace("Compute iml def imported projects : " + this.defImportedProjects, new Object[0]);
        if (this.useVarPath) {
            iml.pathUrlResolver.setPathSubstitute(JkLocator.getCacheDir());
        }
        iml.getComponent().getContent().addJekaStandards();
        if (this.ideSupport != null) {
            List<Path> sourcePaths = this.ideSupport.getProdLayout().resolveSources().getRootDirsOrZipFiles();
            sourcePaths.forEach(path -> iml.getComponent().getContent().addSourceFolder((Path)path, false, null));
            this.ideSupport.getProdLayout().resolveResources().getRootDirsOrZipFiles().stream().filter(path -> !sourcePaths.contains(path)).forEach(path -> iml.getComponent().getContent().addSourceFolder((Path)path, false, "java-resource"));
            List<Path> testSourcePaths = this.ideSupport.getTestLayout().resolveSources().getRootDirsOrZipFiles();
            testSourcePaths.forEach(path -> iml.getComponent().getContent().addSourceFolder((Path)path, true, null));
            this.ideSupport.getTestLayout().resolveResources().getRootDirsOrZipFiles().stream().filter(path -> !testSourcePaths.contains(path)).forEach(path -> iml.getComponent().getContent().addSourceFolder((Path)path, false, "java-test-resource"));
            JkDependencyResolver depResolver = this.ideSupport.getDependencyResolver();
            JkResolvedDependencyNode tree = depResolver.resolve(this.ideSupport.getDependencies(), depResolver.getDefaultParams().copy().setFailOnDependencyResolutionError(this.failOnDepsResolutionError)).getDependencyTree();
            JkLog.trace("Dependencies resolved", new Object[0]);
            iml.getComponent().getOrderEntries().addAll(this.projectOrderEntries(tree));
            for (Path path2 : this.ideSupport.getGeneratedSourceDirs()) {
                iml.getComponent().getContent().addSourceFolder(path2, false, null);
            }
        }
        iml.getComponent().getOrderEntries().addAll(this.defOrderEntries());
        this.imlConfigurer.accept(iml);
        JkLog.trace("Iml object generated", new Object[0]);
        return iml;
    }

    private Path baseDir() {
        return this.ideSupport == null ? this.baseDir : this.ideSupport.getProdLayout().getBaseDir();
    }

    private List<JkIml.OrderEntry> defOrderEntries() {
        OrderEntries orderEntries = new OrderEntries();
        JkPathSequence importedClasspath = this.defImportedProjects.getEntries().stream().map(JkRuntime::get).map(JkRuntime::getClasspath).reduce(JkPathSequence.of(), (ps1, ps2) -> ps1.and((Iterable<Path>)ps2)).withoutDuplicates();
        this.defClasspath.and(this.defImportedProjects).getEntries().stream().filter(path -> !importedClasspath.getEntries().contains(path)).filter(path -> !this.excludeJekaLib || !JkLocator.getJekaJarPath().equals(path)).filter(path -> !path.endsWith(Paths.get("jeka/.work/def-classes", new String[0]))).forEach(path -> orderEntries.add((Path)path, JkIml.Scope.TEST));
        return new LinkedList<JkIml.OrderEntry>(orderEntries.orderEntries);
    }

    private Path jekaHome() {
        if (this.explicitJekaHome != null) {
            return this.explicitJekaHome;
        }
        return JkLocator.getJekaHomeDir();
    }

    private JkIml.OrderEntry dirAsOrderEntry(Path dir, JkIml.Scope scope) {
        for (Path importedProject : this.defImportedProjects) {
            if (!importedProject.resolve("jeka/.work/def-classes").equals(dir)) continue;
            return JkIml.ModuleOrderEntry.of().setModuleName(JkImlGenerator.moduleName(dir)).setExported(true).setScope(scope);
        }
        if (Files.exists(dir.resolve("jeka"), new LinkOption[0]) && Files.isDirectory(dir.resolve("jeka"), new LinkOption[0])) {
            return JkIml.ModuleOrderEntry.of().setModuleName(JkImlGenerator.moduleName(dir)).setScope(scope).setExported(true);
        }
        return JkIml.ModuleLibraryOrderEntry.of().setClasses(dir).setScope(scope).setExported(true);
    }

    private static String moduleName(Path projectDir) {
        return JkImlGenerator.findExistingImlFile(projectDir).map(path -> JkUtilsString.substringBeforeLast(path.getFileName().toString(), ".iml")).orElse(projectDir.getFileName().toString());
    }

    private static Optional<Path> findExistingImlFile(Path projectDir) {
        return ((JkPathTree)JkPathTree.of(projectDir).andMatching(".idea/*.iml", "*.iml")).stream(new FileVisitOption[0]).findFirst();
    }

    private static JkIml.ModuleLibraryOrderEntry libAsOrderEntry(Path libPath) {
        return JkIml.ModuleLibraryOrderEntry.of().setClasses(libPath).setSources(JkImlGenerator.lookForSources(libPath)).setJavadoc(JkImlGenerator.lookForJavadoc(libPath));
    }

    private static Path lookForSources(Path binary) {
        String name = binary.getFileName().toString();
        String nameWithoutExt = JkUtilsString.substringBeforeLast(name, ".");
        String ext = JkUtilsString.substringAfterLast(name, ".");
        String sourceName = nameWithoutExt + "-sources." + ext;
        List<Path> folders = JkUtilsIterable.listOf(binary.resolve("..").normalize(), binary.resolve("../sources").normalize(), binary.resolve("../../sources").normalize());
        List<String> names = JkUtilsIterable.listOf(sourceName, nameWithoutExt + "-sources.zip");
        return JkImlGenerator.lookFileHere(folders, names);
    }

    private static Path lookForJavadoc(Path binary) {
        String name = binary.getFileName().toString();
        String nameWithoutExt = JkUtilsString.substringBeforeLast(name, ".");
        String ext = JkUtilsString.substringAfterLast(name, ".");
        String sourceName = nameWithoutExt + "-javadoc." + ext;
        List<Path> folders = JkUtilsIterable.listOf(binary.resolve("..").normalize(), binary.resolve("../../../libs-javadoc").normalize(), binary.resolve("../../libs-javadoc").normalize(), binary.resolve("../libs-javadoc").normalize());
        List<String> names = JkUtilsIterable.listOf(sourceName, nameWithoutExt + "-javadoc.zip");
        return JkImlGenerator.lookFileHere(folders, names);
    }

    private static Path lookFileHere(Iterable<Path> folders, Iterable<String> names) {
        for (Path folder : folders) {
            for (String name : names) {
                Path candidate = folder.resolve(name).normalize();
                if (!Files.exists(candidate, new LinkOption[0])) continue;
                return candidate;
            }
        }
        return null;
    }

    private List<JkIml.OrderEntry> projectOrderEntries(JkResolvedDependencyNode tree) {
        long t0 = System.currentTimeMillis();
        OrderEntries orderEntries = new OrderEntries();
        for (JkResolvedDependencyNode node : tree.toFlattenList()) {
            JkIml.Scope scope;
            if (node.isModuleNode()) {
                JkResolvedDependencyNode.JkModuleNodeInfo moduleNodeInfo = node.getModuleInfo();
                if (moduleNodeInfo.isEvicted()) continue;
                scope = JkImlGenerator.ideScope(moduleNodeInfo.getRootConfigurations());
                moduleNodeInfo.getFiles().forEach(path -> orderEntries.add((Path)path, scope));
                continue;
            }
            JkResolvedDependencyNode.JkFileNodeInfo fileNodeInfo = (JkResolvedDependencyNode.JkFileNodeInfo)node.getNodeInfo();
            scope = JkImlGenerator.ideScope(fileNodeInfo.getDeclaredConfigurations());
            if (fileNodeInfo.isComputed()) {
                Path projectDir = fileNodeInfo.computationOrigin().getIdeProjectDir();
                if (projectDir == null) continue;
                orderEntries.add(projectDir, scope);
                continue;
            }
            fileNodeInfo.getFiles().forEach(path -> orderEntries.add((Path)path, scope));
        }
        JkLog.trace("projectOrderEntries() took '%s ms", System.currentTimeMillis() - t0);
        return new LinkedList<JkIml.OrderEntry>(orderEntries.orderEntries);
    }

    private static JkIml.Scope ideScope(Set<String> scopes) {
        if (scopes.contains("compile")) {
            return JkIml.Scope.COMPILE;
        }
        if (scopes.contains("runtime")) {
            return JkIml.Scope.RUNTIME;
        }
        if (scopes.contains("provided")) {
            return JkIml.Scope.PROVIDED;
        }
        if (scopes.contains("test")) {
            return JkIml.Scope.TEST;
        }
        return JkIml.Scope.COMPILE;
    }

    private class OrderEntries {
        private LinkedHashSet<JkIml.OrderEntry> orderEntries = new LinkedHashSet();
        private Map<Path, JkIml.ModuleLibraryOrderEntry> cache = new HashMap<Path, JkIml.ModuleLibraryOrderEntry>();

        private OrderEntries() {
        }

        void add(Path entry, JkIml.Scope scope) {
            JkIml.OrderEntry orderEntry = Files.isDirectory(entry, new LinkOption[0]) ? JkImlGenerator.this.dirAsOrderEntry(entry, scope) : this.cache.computeIfAbsent(entry, x$0 -> JkImlGenerator.libAsOrderEntry(x$0)).copy().setScope(scope).setExported(true);
            this.orderEntries.add(orderEntry);
        }
    }
}

