/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling.intellij;

import dev.jeka.core.api.marshalling.xml.JkDomDocument;
import dev.jeka.core.api.marshalling.xml.JkDomElement;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class JkIml {
    private Path moduleDir = Paths.get("", new String[0]);
    private Component component = new Component();
    final PathUrlResolver pathUrlResolver = new PathUrlResolver();

    private JkIml() {
    }

    public static JkIml of() {
        return new JkIml();
    }

    public JkIml setModuleDir(Path path) {
        this.moduleDir = path;
        return this;
    }

    public Component getComponent() {
        return this.component;
    }

    private static String url(String relPath) {
        return "file://$MODULE_DIR$/" + relPath;
    }

    public JkDomDocument toDoc() {
        JkDomDocument doc = JkDomDocument.of("module");
        doc.root().attr("type", "JAVA_MODULE").attr("version", "4").apply(el -> this.component.append((JkDomElement)el, this.pathUrlResolver));
        return doc;
    }

    public class PathUrlResolver {
        private Map<String, Path> substitutes = new LinkedHashMap<String, Path>();

        void setPathSubstitute(Path jekaCacheDir) {
            this.substitutes.put("MODULE_DIR", JkIml.this.moduleDir);
            this.substitutes.put("JEKA_CACHE_DIR", jekaCacheDir);
        }

        String ideaPath(Path file) {
            boolean jarFile = file.getFileName().toString().toLowerCase().endsWith(".jar");
            String type = jarFile ? "jar" : "file";
            String result = type + "://" + this.substitutedVarPath(file).toString().replace('\\', '/');
            if (jarFile) {
                result = result + "!/";
            }
            return result;
        }

        private Path substitutedVarPath(Path original) {
            if (!original.isAbsolute()) {
                Path moduleDirRelativePath = JkIml.this.moduleDir.toAbsolutePath().normalize().relativize(original.toAbsolutePath().normalize());
                return Paths.get("$MODULE_DIR$", new String[0]).resolve(moduleDirRelativePath);
            }
            Path normalized = original.normalize();
            return this.substitutes.entrySet().stream().filter(pathStringEntry -> pathStringEntry.getValue() != null).filter(pathStringEntry -> normalized.startsWith((Path)pathStringEntry.getValue())).findFirst().map(entry -> Paths.get("$" + (String)entry.getKey() + "$", new String[0]).resolve(((Path)entry.getValue()).relativize(normalized))).orElse(normalized);
        }
    }

    public static class ModuleOrderEntry
    implements OrderEntry {
        private String moduleName;
        private Scope scope;
        private boolean exported;

        private ModuleOrderEntry() {
        }

        public static ModuleOrderEntry of() {
            return new ModuleOrderEntry();
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public ModuleOrderEntry setModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Scope getScope() {
            return this.scope;
        }

        public ModuleOrderEntry setScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public boolean isExported() {
            return this.exported;
        }

        public ModuleOrderEntry setExported(boolean exported) {
            this.exported = exported;
            return this;
        }

        @Override
        public void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            JkDomElement el = parent.add("orderEntry").attr("type", "module").attr("module-name", this.moduleName);
            this.enrichAttribute(el, this.scope, this.exported);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleOrderEntry that = (ModuleOrderEntry)o;
            return this.moduleName.equals(that.moduleName);
        }

        public int hashCode() {
            return this.moduleName.hashCode();
        }
    }

    public static class ModuleLibraryOrderEntry
    implements OrderEntry {
        private Path classes;
        private Path sources;
        private Path javadoc;
        private Scope scope;
        private boolean exported;

        private ModuleLibraryOrderEntry() {
        }

        public static ModuleLibraryOrderEntry of() {
            return new ModuleLibraryOrderEntry();
        }

        ModuleLibraryOrderEntry copy() {
            ModuleLibraryOrderEntry copy = new ModuleLibraryOrderEntry();
            copy.classes = this.classes;
            copy.sources = this.sources;
            copy.javadoc = this.javadoc;
            copy.scope = this.scope;
            copy.exported = this.exported;
            return copy;
        }

        public Path getClasses() {
            return this.classes;
        }

        public ModuleLibraryOrderEntry setClasses(Path classes) {
            this.classes = classes;
            return this;
        }

        public Path getSources() {
            return this.sources;
        }

        public ModuleLibraryOrderEntry setSources(Path sources) {
            this.sources = sources;
            return this;
        }

        public Path getJavadoc() {
            return this.javadoc;
        }

        public ModuleLibraryOrderEntry setJavadoc(Path javadoc) {
            this.javadoc = javadoc;
            return this;
        }

        public Scope getScope() {
            return this.scope;
        }

        public ModuleLibraryOrderEntry setScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public boolean isExported() {
            return this.exported;
        }

        public ModuleLibraryOrderEntry setExported(boolean exported) {
            this.exported = exported;
            return this;
        }

        public void assertValid() {
            JkUtilsAssert.state(this.classes != null, "classesUrl must not be null", new Object[0]);
        }

        @Override
        public void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            this.assertValid();
            JkDomElement el = parent.add("orderEntry");
            this.enrichAttribute(el, this.scope, this.exported);
            el.attr("type", "module-library");
            el.add((String)"library").add((String)"CLASSES").add((String)"root").attr((String)"url", (String)pathUrlResolver.ideaPath((Path)this.classes)).__.__.add((String)"JAVADOC").applyIf((boolean)(this.javadoc != null ? true : false), (Consumer<JkDomElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$append$0(dev.jeka.core.api.tooling.intellij.JkIml$PathUrlResolver dev.jeka.core.api.marshalling.xml.JkDomElement ), (Ldev/jeka/core/api/marshalling/xml/JkDomElement;)V)((ModuleLibraryOrderEntry)this, (PathUrlResolver)pathUrlResolver)).__.add("SOURCES").applyIf(this.sources != null, srcEl -> srcEl.add("root").attr("url", pathUrlResolver.ideaPath(this.sources)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleLibraryOrderEntry that = (ModuleLibraryOrderEntry)o;
            return this.classes.equals(that.classes);
        }

        public int hashCode() {
            return this.classes.hashCode();
        }

        private /* synthetic */ void lambda$append$0(PathUrlResolver pathUrlResolver, JkDomElement docEl) {
            docEl.add("root").attr("url", pathUrlResolver.ideaPath(this.javadoc));
        }
    }

    static interface OrderEntry {
        default public void enrichAttribute(JkDomElement el, Scope scope, boolean exported) {
            if (scope != null) {
                el.attr("scope", scope.name());
            }
            if (exported) {
                el.attr("exported", "");
            }
        }

        public void append(JkDomElement var1, PathUrlResolver var2);
    }

    public static class ExcludeFolder {
        private final Path path;

        public ExcludeFolder(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            JkDomElement el = parent.add("excludeFolder").attr("url", pathUrlResolver.ideaPath(this.path));
        }
    }

    public static class SourceFolder {
        private final Path path;
        private final boolean isTest;
        private final String type;

        private SourceFolder(Path path, boolean isTest, String type) {
            this.path = path;
            this.isTest = isTest;
            this.type = type;
        }

        public static SourceFolder of(Path path, boolean isTest, String type) {
            return new SourceFolder(path, isTest, type);
        }

        public static SourceFolder of(Path path, boolean isTest) {
            return SourceFolder.of(path, isTest, null);
        }

        public Path getUrl() {
            return this.path;
        }

        public boolean isTest() {
            return this.isTest;
        }

        public String getType() {
            return this.type;
        }

        void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            JkDomElement el = parent.add("sourceFolder").attr("url", pathUrlResolver.ideaPath(this.path)).attr("type", this.type);
            if (this.isTest) {
                el.attr("isTestSource", "true");
            }
        }
    }

    public class Content {
        private final List<SourceFolder> sourceFolders = new LinkedList<SourceFolder>();
        private final List<ExcludeFolder> excludeFolders = new LinkedList<ExcludeFolder>();

        public List<SourceFolder> getSourceFolders() {
            return this.sourceFolders;
        }

        public List<ExcludeFolder> getExcludeFolders() {
            return this.excludeFolders;
        }

        public Content addSourceFolder(String path, boolean test, String type) {
            return this.addSourceFolder(JkIml.this.moduleDir.resolve(path), test, type);
        }

        public Content addSourceFolder(Path path, boolean test, String type) {
            this.sourceFolders.add(SourceFolder.of(path, test, type));
            return this;
        }

        public Content addExcludeFolder(String path) {
            this.excludeFolders.add(new ExcludeFolder(JkIml.this.moduleDir.resolve(path)));
            return this;
        }

        public Content addJekaStandards() {
            return this.addSourceFolder("jeka/def", true, null).addExcludeFolder("jeka/output").addExcludeFolder("jeka/.work").addExcludeFolder(".idea/output");
        }

        void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            JkDomElement el = parent.add("content").attr("url", "file://$MODULE_DIR$");
            this.sourceFolders.forEach(sourceFolder -> sourceFolder.append(el, pathUrlResolver));
            this.excludeFolders.forEach(excludeFolder -> excludeFolder.append(el, pathUrlResolver));
        }
    }

    public class Component {
        private String output = ".idea/output/production";
        private String outputTest = ".idea/output/test";
        private boolean excludeOutput = true;
        private Content content = new Content();
        private List<OrderEntry> orderEntries = new LinkedList<OrderEntry>();

        public Content getContent() {
            return this.content;
        }

        public List<OrderEntry> getOrderEntries() {
            return this.orderEntries;
        }

        public Component addModuleLibraryOrderEntry(Path path, Scope scope) {
            ModuleLibraryOrderEntry moduleLibraryOrderEntry = ModuleLibraryOrderEntry.of().setClasses(path).setExported(true).setScope(scope);
            this.orderEntries.add(moduleLibraryOrderEntry);
            return this;
        }

        public Component addModuleOrderEntry(String moduleName, Scope scope) {
            ModuleOrderEntry moduleOrderEntry = ModuleOrderEntry.of().setModuleName(moduleName).setExported(true).setScope(scope);
            this.orderEntries.add(moduleOrderEntry);
            return this;
        }

        public Component replaceLibByModule(String libPathEndsWithFilter, String moduleName) {
            List result = this.orderEntries.stream().map(orderEntry -> {
                ModuleLibraryOrderEntry entry;
                if (orderEntry instanceof ModuleLibraryOrderEntry && (entry = (ModuleLibraryOrderEntry)orderEntry).classes.endsWith(libPathEndsWithFilter)) {
                    return new ModuleOrderEntry().setModuleName(moduleName).setExported(entry.exported).setScope(entry.scope);
                }
                return orderEntry;
            }).collect(Collectors.toList());
            this.orderEntries = result;
            return this;
        }

        void append(JkDomElement parent, PathUrlResolver pathUrlResolver) {
            parent.add((String)"component").attr((String)"name", (String)"NewModuleRootManager").attr((String)"inherit-compileRunner-output", (String)"false").applyIf((boolean)(this.output != null ? true : false), (Consumer<JkDomElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$append$1(dev.jeka.core.api.tooling.intellij.JkIml$PathUrlResolver dev.jeka.core.api.marshalling.xml.JkDomElement ), (Ldev/jeka/core/api/marshalling/xml/JkDomElement;)V)((Component)this, (PathUrlResolver)pathUrlResolver)).applyIf((boolean)(this.outputTest != null ? true : false), (Consumer<JkDomElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$append$2(dev.jeka.core.api.tooling.intellij.JkIml$PathUrlResolver dev.jeka.core.api.marshalling.xml.JkDomElement ), (Ldev/jeka/core/api/marshalling/xml/JkDomElement;)V)((Component)this, (PathUrlResolver)pathUrlResolver)).applyIf((boolean)this.excludeOutput, (Consumer<JkDomElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$append$3(dev.jeka.core.api.marshalling.xml.JkDomElement ), (Ldev/jeka/core/api/marshalling/xml/JkDomElement;)V)()).apply((Consumer<JkDomElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$append$4(dev.jeka.core.api.tooling.intellij.JkIml$PathUrlResolver dev.jeka.core.api.marshalling.xml.JkDomElement ), (Ldev/jeka/core/api/marshalling/xml/JkDomElement;)V)((Component)this, (PathUrlResolver)pathUrlResolver)).add((String)"orderEntry").attr((String)"type", (String)"inheritedJdk").__.add((String)"orderEntry").attr((String)"forTests", (String)"false").attr((String)"type", (String)"sourceFolder").__.apply(el -> this.orderEntries.stream().distinct().forEach(orderEntry -> orderEntry.append((JkDomElement)el, pathUrlResolver)));
        }

        private /* synthetic */ void lambda$append$4(PathUrlResolver pathUrlResolver, JkDomElement el) {
            this.content.append(el, pathUrlResolver);
        }

        private static /* synthetic */ void lambda$append$3(JkDomElement el) {
            el.add("exclude-output");
        }

        private /* synthetic */ void lambda$append$2(PathUrlResolver pathUrlResolver, JkDomElement el) {
            el.add("output-test").attr("url", pathUrlResolver.ideaPath(JkIml.this.moduleDir.resolve(this.outputTest)));
        }

        private /* synthetic */ void lambda$append$1(PathUrlResolver pathUrlResolver, JkDomElement el) {
            el.add("output").attr("url", pathUrlResolver.ideaPath(JkIml.this.moduleDir.resolve(this.output)));
        }
    }

    public static enum Scope {
        COMPILE,
        RUNTIME,
        TEST,
        PROVIDED;

    }
}

