/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling.eclipse;

import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JkEclipseProjectGenerator {
    final String name;
    final Set<String> natures;

    private static JkEclipseProjectGenerator of(Path dotProjectFile) {
        Document document = JkEclipseProjectGenerator.getDotProjectAsDom(dotProjectFile);
        return JkEclipseProjectGenerator.from(document);
    }

    public static JkEclipseProjectGenerator ofJavaNature(String name) {
        return new JkEclipseProjectGenerator(name, JkUtilsIterable.setOf("org.eclipse.jdt.core.javanature"));
    }

    public static JkEclipseProjectGenerator ofSimpleNature(String name) {
        return new JkEclipseProjectGenerator(name, new HashSet<String>());
    }

    static Map<String, Path> findProjectPath(Path parent) {
        HashMap<String, Path> map = new HashMap<String, Path>();
        for (Path file : JkUtilsPath.listDirectChildren(parent)) {
            Path dotProject = file.resolve(".project");
            if (!Files.exists(dotProject, new LinkOption[0])) continue;
            JkEclipseProjectGenerator project = JkEclipseProjectGenerator.of(dotProject);
            map.put(project.name, file);
        }
        return map;
    }

    boolean hasJavaNature() {
        return this.natures.contains("org.eclipse.jdt.core.javanature");
    }

    public void writeTo(Path dotProjectFile) {
        try {
            this.writeToFile(dotProjectFile);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToFile(Path dotProjectFile) throws XMLStreamException, FactoryConfigurationError {
        try (OutputStream fos = Files.newOutputStream(dotProjectFile, new OpenOption[0]);){
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fos, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeCharacters("\n");
            writer.writeStartElement("projectDescription");
            writer.writeCharacters("\n\t");
            writer.writeStartElement("name");
            writer.writeCharacters(this.name);
            writer.writeEndElement();
            writer.writeCharacters("\n\t");
            writer.writeEmptyElement("comment");
            writer.writeCharacters("\n\t");
            writer.writeEmptyElement("projects");
            writer.writeCharacters("\n\t");
            writer.writeStartElement("buildSpec");
            writer.writeCharacters("\n\t\t");
            writer.writeStartElement("buildCommand");
            writer.writeCharacters("\n\t\t\t");
            writer.writeStartElement("name");
            writer.writeCharacters("org.eclipse.jdt.core.javabuilder");
            writer.writeEndElement();
            writer.writeCharacters("\n\t\t\t");
            writer.writeEmptyElement("arguments");
            writer.writeCharacters("\n\t\t");
            writer.writeEndElement();
            writer.writeCharacters("\n\t");
            writer.writeEndElement();
            writer.writeCharacters("\n\t");
            writer.writeStartElement("natures");
            for (String nature : this.natures) {
                writer.writeCharacters("\n\t\t");
                writer.writeStartElement("nature");
                writer.writeCharacters(nature);
                writer.writeEndElement();
            }
            writer.writeCharacters("\n\t");
            writer.writeEndElement();
            writer.writeCharacters("\n");
            writer.writeEndElement();
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    private JkEclipseProjectGenerator(String name, Set<String> natures) {
        this.name = name;
        this.natures = Collections.unmodifiableSet(natures);
    }

    private static JkEclipseProjectGenerator from(Document document) {
        NodeList nodeList = document.getElementsByTagName("name");
        Node node = nodeList.item(0);
        String name = node.getTextContent();
        HashSet<String> natures = new HashSet<String>();
        NodeList natureNodes = document.getElementsByTagName("nature");
        for (int i = 0; i < natureNodes.getLength(); ++i) {
            natures.add(natureNodes.item(i).getTextContent());
        }
        return new JkEclipseProjectGenerator(name, natures);
    }

    private static Document getDotProjectAsDom(Path dotProjectFile) {
        if (!Files.exists(dotProjectFile, new LinkOption[0])) {
            throw new IllegalStateException(dotProjectFile + " file not found.");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(dotProjectFile.toFile());
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing .classpath file : ", e);
        }
    }
}

