/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.tooling.eclipse;

import dev.jeka.core.api.depmanagement.JkComputedDependency;
import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.depmanagement.JkFileSystemDependency;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class JkEclipseClasspathGenerator {
    private static final String ENCODING = "UTF-8";
    private static final String CLASSPATH_ENTRY = "classpathentry";
    private static final String JEKA_HOME = "JEKA_HOME";
    private static final String JEKA_USER_HOME = "JEKA_USER_HOME";
    private final JkIdeSupport ideSupport;
    private JkDependencyResolver defDependencyResolver;
    private JkDependencySet defDependencies;
    private List<Path> importedProjects = new LinkedList<Path>();
    private Map<JkDependency, Properties> attributes = new HashMap<JkDependency, Properties>();
    private Map<JkDependency, Properties> accessRules = new HashMap<JkDependency, Properties>();
    private boolean includeJavadoc = true;
    private String jreContainer;
    private boolean usePathVariables;

    private JkEclipseClasspathGenerator(JkIdeSupport ideSupport) {
        this.ideSupport = ideSupport;
    }

    public static JkEclipseClasspathGenerator of(JkIdeSupport ideSupport) {
        return new JkEclipseClasspathGenerator(ideSupport);
    }

    private boolean hasJekaDefDir() {
        return Files.exists(this.ideSupport.getProdLayout().getBaseDir().resolve("jeka/def"), new LinkOption[0]);
    }

    public JkEclipseClasspathGenerator setIncludeJavadoc(boolean includeJavadoc) {
        this.includeJavadoc = includeJavadoc;
        return this;
    }

    public JkEclipseClasspathGenerator setJreContainer(String jreContainer) {
        this.jreContainer = jreContainer;
        return this;
    }

    public JkEclipseClasspathGenerator setUsePathVariables(boolean usePathVariables) {
        this.usePathVariables = usePathVariables;
        return this;
    }

    public JkEclipseClasspathGenerator setImportedProjects(List<Path> importedBuildProjects) {
        this.importedProjects = importedBuildProjects;
        return this;
    }

    public JkEclipseClasspathGenerator setDefDependencies(JkDependencyResolver buildDependencyResolver, JkDependencySet buildDependencies) {
        this.defDependencyResolver = buildDependencyResolver;
        this.defDependencies = buildDependencies;
        return this;
    }

    public JkEclipseClasspathGenerator addAttribute(JkDependency dependency, String name, String value) {
        this.attributes.putIfAbsent(dependency, new Properties());
        this.attributes.get(dependency).put(name, value);
        return this;
    }

    public JkEclipseClasspathGenerator addAttributes(JkDependency dependency, Properties attributes) {
        this.attributes.putIfAbsent(dependency, new Properties());
        this.attributes.get(dependency).putAll((Map<?, ?>)attributes);
        return this;
    }

    public JkEclipseClasspathGenerator addAccessRule(JkDependency dependency, String kind, String pattern) {
        this.accessRules.putIfAbsent(dependency, new Properties());
        this.accessRules.get(dependency).put(kind, pattern);
        return this;
    }

    public JkEclipseClasspathGenerator addAccessRules(JkDependency dependency, Properties rules) {
        this.accessRules.putIfAbsent(dependency, new Properties());
        this.accessRules.get(dependency).putAll((Map<?, ?>)rules);
        return this;
    }

    public String generate() {
        try {
            return this._generate();
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    private String _generate() throws IOException, XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fos, ENCODING);
        writer.writeStartDocument(ENCODING, "1.0");
        writer.writeCharacters("\n");
        writer.writeStartElement("classpath");
        writer.writeCharacters("\n");
        HashSet<String> paths = new HashSet<String>();
        if (this.hasJekaDefDir()) {
            writer.writeCharacters("\t");
            JkEclipseClasspathGenerator.writeClasspathEl(writer, "kind", "src", "including", "**/*", "path", "jeka/def");
        }
        this.generateSrcAndTestSrc(writer);
        for (Path projectFile : this.importedProjects) {
            if (!paths.add(projectFile.toAbsolutePath().toString())) continue;
            writer.writeCharacters("\t");
            JkEclipseClasspathGenerator.writeClasspathEl(writer, "combineaccessrules", "false", "kind", "src", "exported", "true", "path", "/" + projectFile.getFileName().toString());
        }
        if (this.ideSupport.getDependencyResolver() != null) {
            this.writeDependenciesEntries(writer, this.ideSupport.getDependencies(), this.ideSupport.getDependencyResolver(), paths);
        }
        this.writeJre(writer);
        if (this.hasJekaDefDir() && this.defDependencyResolver != null) {
            JkQualifiedDependencySet qualifiedDependencies = JkQualifiedDependencySet.ofDependencies(this.defDependencies.getEntries());
            this.writeDependenciesEntries(writer, qualifiedDependencies, this.defDependencyResolver, paths);
        }
        writer.writeCharacters("\t");
        JkEclipseClasspathGenerator.writeClasspathEl(writer, "kind", "output", "path", "bin");
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        return fos.toString(ENCODING);
    }

    private static void writeClasspathEl(XMLStreamWriter writer, String ... items) throws XMLStreamException {
        Map map = JkUtilsIterable.mapOfAny(items);
        writer.writeEmptyElement(CLASSPATH_ENTRY);
        for (Map.Entry entry : map.entrySet()) {
            writer.writeAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        writer.writeCharacters("\n");
    }

    private static String eclipseJavaVersion(JkJavaVersion compilerVersion) {
        if (JkJavaVersion.V8.equals(compilerVersion)) {
            return "JavaSE-1.8";
        }
        return "JavaSE-" + compilerVersion.get();
    }

    private void writeProjectEntryIfNeeded(Path projectDir, XMLStreamWriter writer, Set<String> paths) throws XMLStreamException {
        if (paths.add(projectDir.toAbsolutePath().toString())) {
            writer.writeCharacters("\t");
            JkEclipseClasspathGenerator.writeClasspathEl(writer, "kind", "src", "exported", "true", "path", "/" + projectDir.getFileName().toString());
        }
    }

    private void writeFileDepsEntries(XMLStreamWriter writer, Iterable<Path> fileDeps, Set<String> paths, Properties attributeProps, Properties accessRuleProps) throws XMLStreamException {
        for (Path file : fileDeps) {
            this.writeFileEntry(file, writer, paths, attributeProps, accessRuleProps);
        }
    }

    private void writeJre(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\t");
        writer.writeEmptyElement(CLASSPATH_ENTRY);
        writer.writeAttribute("kind", "con");
        String container = this.jreContainer != null ? this.jreContainer : (this.ideSupport.getSourceVersion() != null ? "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + JkEclipseClasspathGenerator.eclipseJavaVersion(this.ideSupport.getSourceVersion()) : "org.eclipse.jdt.launching.JRE_CONTAINER");
        writer.writeAttribute("path", container);
        writer.writeCharacters("\n");
    }

    private void writeFileEntry(Path file, XMLStreamWriter writer, Set<String> paths, Properties attributeProps, Properties accessRuleProps) throws XMLStreamException {
        Path javadoc;
        String name = JkUtilsString.substringBeforeLast(file.getFileName().toString(), ".jar");
        Path source = file.resolveSibling(name + "-sources.jar");
        if (!Files.exists(source, new LinkOption[0])) {
            source = file.resolveSibling("../sources/" + name + "-sources.jar");
        }
        if (!Files.exists(javadoc = file.resolveSibling(name + "-javadoc.jar"), new LinkOption[0])) {
            javadoc = file.resolveSibling("../../libs-javadoc/" + name + "-javadoc.jar");
        }
        if (!Files.exists(javadoc, new LinkOption[0])) {
            javadoc = file.resolveSibling("libs-javadoc/" + name + "-javadoc.jar");
        }
        if (Files.exists(javadoc, new LinkOption[0]) && this.includeJavadoc) {
            attributeProps.put("javadoc_location", JkEclipseClasspathGenerator.javadocAttributeValue(javadoc));
        }
        this.writeClasspathEl(writer, file, source, attributeProps, accessRuleProps, paths);
    }

    private void generateSrcAndTestSrc(XMLStreamWriter writer) throws XMLStreamException {
        HashSet<String> sourcePaths = new HashSet<String>();
        JkCompileLayout<JkIdeSupport> testLayout = this.ideSupport.getTestLayout();
        for (JkPathTree fileTree : testLayout.resolveSources().and(testLayout.resolveResources()).toList()) {
            String path;
            if (!fileTree.exists() || sourcePaths.contains(path = testLayout.getBaseDir().relativize(fileTree.getRoot()).toString().replace(File.separator, "/"))) continue;
            sourcePaths.add(path);
            writer.writeCharacters("\t");
            writer.writeEmptyElement(CLASSPATH_ENTRY);
            writer.writeAttribute("kind", "src");
            this.writeIncludingExcluding(writer, fileTree);
            writer.writeAttribute("path", path);
            writer.writeCharacters("\n");
        }
        JkCompileLayout<JkIdeSupport> prodLayout = this.ideSupport.getProdLayout();
        for (JkPathTree fileTree : prodLayout.resolveSources().and(prodLayout.resolveResources()).toList()) {
            String path;
            if (!fileTree.exists() || sourcePaths.contains(path = JkEclipseClasspathGenerator.relativePathIfPossible(prodLayout.getBaseDir(), fileTree.getRoot()).toString().replace(File.separator, "/"))) continue;
            sourcePaths.add(path);
            writer.writeCharacters("\t");
            writer.writeEmptyElement(CLASSPATH_ENTRY);
            writer.writeAttribute("kind", "src");
            this.writeIncludingExcluding(writer, fileTree);
            writer.writeAttribute("path", path);
            writer.writeCharacters("\n");
        }
    }

    private static Path relativePathIfPossible(Path base, Path candidate) {
        if (!candidate.startsWith(base)) {
            return candidate.toAbsolutePath().normalize();
        }
        return base.relativize(candidate);
    }

    private void writeIncludingExcluding(XMLStreamWriter writer, JkPathTree fileTree) throws XMLStreamException {
        String including = "";
        if (!JkUtilsString.isBlank("")) {
            writer.writeAttribute("including", "");
        }
        String excluding = "";
        if (!JkUtilsString.isBlank("")) {
            writer.writeAttribute("excluding", "");
        }
    }

    private void writeDependenciesEntries(XMLStreamWriter writer, JkQualifiedDependencySet dependencies, JkDependencyResolver resolver, Set<String> allPaths) throws XMLStreamException {
        List deps = dependencies.getEntries().stream().map(qDep -> qDep.getDependency()).filter(dep -> dep.getIdeProjectDir() == null).collect(Collectors.toList());
        JkResolveResult resolveResult = resolver.resolve(JkDependencySet.of(deps));
        JkRepoSet repos = resolver.getRepos();
        for (JkResolvedDependencyNode node : resolveResult.getDependencyTree().toFlattenList()) {
            Properties attributeProps;
            if (node.isModuleNode()) {
                JkResolvedDependencyNode.JkModuleNodeInfo moduleNodeInfo = node.getModuleInfo();
                JkModuleDependency dependency = JkModuleDependency.of(moduleNodeInfo.getModuleId().getGroupAndName());
                attributeProps = JkEclipseClasspathGenerator.copyOfPropsOf(dependency, this.attributes);
                Properties accessruleProps = JkEclipseClasspathGenerator.copyOfPropsOf(dependency, this.accessRules);
                this.writeModuleEntry(writer, moduleNodeInfo.getResolvedVersionedModule(), moduleNodeInfo.getFiles(), repos, allPaths, attributeProps, accessruleProps);
                continue;
            }
            JkResolvedDependencyNode.JkFileNodeInfo fileNodeInfo = (JkResolvedDependencyNode.JkFileNodeInfo)node.getNodeInfo();
            if (fileNodeInfo.isComputed()) {
                JkComputedDependency computedDependency = fileNodeInfo.computationOrigin();
                Path ideProjectBaseDir = computedDependency.getIdeProjectDir();
                if (ideProjectBaseDir != null) {
                    if (allPaths.contains(ideProjectBaseDir.toAbsolutePath().toString())) continue;
                    this.writeProjectEntryIfNeeded(ideProjectBaseDir, writer, allPaths);
                    continue;
                }
                this.writeFileDepsEntries(writer, node.getResolvedFiles(), allPaths, new Properties(), new Properties());
                continue;
            }
            JkFileSystemDependency fileDep = JkFileSystemDependency.of(fileNodeInfo.getFiles());
            attributeProps = JkEclipseClasspathGenerator.copyOfPropsOf(fileDep, this.attributes);
            Properties accessRuleProps = JkEclipseClasspathGenerator.copyOfPropsOf(fileDep, this.accessRules);
            this.writeFileDepsEntries(writer, node.getResolvedFiles(), allPaths, attributeProps, accessRuleProps);
        }
    }

    private void writeModuleEntry(XMLStreamWriter writer, JkVersionedModule versionedModule, Iterable<Path> files, JkRepoSet repos, Set<String> paths, Properties attributeProps, Properties accessRuleProps) throws XMLStreamException {
        Path source = repos.get(JkModuleDependency.of(versionedModule).withClassifiers("sources"));
        Path javadoc = null;
        if (source == null || !Files.exists(source, new LinkOption[0]) || this.includeJavadoc) {
            javadoc = repos.get(JkModuleDependency.of(versionedModule).withClassifiers("javadoc"));
        }
        if (javadoc != null) {
            attributeProps.put("javadoc_location", JkEclipseClasspathGenerator.javadocAttributeValue(javadoc));
        }
        for (Path file : files) {
            this.writeClasspathEl(writer, file, source, attributeProps, accessRuleProps, paths);
        }
    }

    private void writeClasspathEl(XMLStreamWriter writer, Path bin, Path source, Properties attributeProps, Properties accesRuleProps, Set<String> paths) throws XMLStreamException {
        boolean emptyTag;
        String binPath = bin.toAbsolutePath().toString();
        if (!paths.add(binPath)) {
            return;
        }
        boolean usePathVariable = this.usePathVariables && bin.startsWith(JkLocator.getJekaUserHomeDir());
        boolean isVar = true;
        if (usePathVariable) {
            binPath = "JEKA_USER_HOME/" + JkLocator.getJekaUserHomeDir().relativize(bin).toString();
        } else if (this.usePathVariables && bin.startsWith(JkLocator.getJekaHomeDir())) {
            binPath = "JEKA_HOME/" + JkLocator.getJekaHomeDir().relativize(bin).toString();
        } else {
            isVar = false;
            binPath = JkEclipseClasspathGenerator.relativePathIfPossible(this.ideSupport.getProdLayout().getBaseDir(), bin).toString();
        }
        binPath = binPath.replace(File.separator, "/");
        writer.writeCharacters("\t");
        boolean bl = emptyTag = attributeProps.isEmpty() && accesRuleProps.isEmpty();
        if (emptyTag) {
            writer.writeEmptyElement(CLASSPATH_ENTRY);
        } else {
            writer.writeStartElement(CLASSPATH_ENTRY);
        }
        writer.writeAttribute("kind", isVar ? "var" : "lib");
        writer.writeAttribute("path", binPath);
        writer.writeAttribute("exported", "true");
        if (source != null && Files.exists(source, new LinkOption[0])) {
            String srcPath = this.usePathVariables && source.startsWith(JkLocator.getJekaUserHomeDir()) ? "JEKA_USER_HOME/" + JkLocator.getJekaUserHomeDir().relativize(source).toString() : (this.usePathVariables && source.startsWith(JkLocator.getJekaHomeDir()) ? "JEKA_HOME/" + JkLocator.getJekaHomeDir().relativize(source).toString() : JkEclipseClasspathGenerator.relativePathIfPossible(this.ideSupport.getProdLayout().getBaseDir(), source).toString());
            srcPath = srcPath.replace(File.separator, "/");
            writer.writeAttribute("sourcepath", srcPath);
        }
        this.writeClasspathentryChildAttributes(writer, attributeProps);
        this.writeClasspathentryChildAccessRules(writer, accesRuleProps);
        if (!emptyTag) {
            writer.writeCharacters("\n\t");
            writer.writeEndElement();
        }
        writer.writeCharacters("\n");
    }

    private static String javadocAttributeValue(Path javadocPath) {
        return "jar:file:/" + javadocPath.toAbsolutePath().normalize().toString().replace(File.separator, "/") + "!/";
    }

    private void writeClasspathentryChildAttributes(XMLStreamWriter writer, Properties props) throws XMLStreamException {
        if (props == null || props.isEmpty()) {
            return;
        }
        writer.writeCharacters("\n\t\t");
        writer.writeStartElement("attributes");
        for (String key : props.stringPropertyNames()) {
            writer.writeCharacters("\n\t\t\t");
            String value = props.getProperty(key);
            writer.writeEmptyElement("attribute");
            writer.writeAttribute("name", key);
            writer.writeAttribute("value", value);
        }
        writer.writeCharacters("\n\t\t");
        writer.writeEndElement();
    }

    private void writeClasspathentryChildAccessRules(XMLStreamWriter writer, Properties props) throws XMLStreamException {
        if (props == null || props.isEmpty()) {
            return;
        }
        writer.writeCharacters("\n\t\t");
        writer.writeStartElement("accessrules");
        for (String key : props.stringPropertyNames()) {
            writer.writeCharacters("\n\t\t\t");
            String value = props.getProperty(key);
            writer.writeEmptyElement("accessrule");
            writer.writeAttribute("kind", key);
            writer.writeAttribute("pattern", value);
        }
        writer.writeCharacters("\n\t\t");
        writer.writeEndElement();
    }

    private static Properties copyOfPropsOf(JkDependency dependency, Map<JkDependency, Properties> propMap) {
        JkDependency key = JkEclipseClasspathGenerator.findMatchingKey(dependency, propMap.keySet());
        if (key == null) {
            return new Properties();
        }
        Properties props = propMap.get(key);
        Properties result = new Properties();
        result.putAll((Map<?, ?>)props);
        return result;
    }

    private static JkDependency findMatchingKey(JkDependency dep1, Collection<JkDependency> deps) {
        return deps.stream().filter(dep -> JkEclipseClasspathGenerator.depsMatchForExtraAttributes(dep1, dep)).findFirst().orElse(null);
    }

    private static boolean depsMatchForExtraAttributes(JkDependency dep1, JkDependency dep2) {
        if (dep1 instanceof JkModuleDependency) {
            if (dep2 instanceof JkModuleDependency) {
                JkModuleDependency modDep1 = (JkModuleDependency)dep1;
                JkModuleDependency modDep2 = (JkModuleDependency)dep2;
                return modDep1.getModuleId().equals(modDep2.getModuleId());
            }
            return false;
        }
        if (dep1 instanceof JkFileDependency && dep2 instanceof JkFileSystemDependency) {
            return dep1.equals(dep2);
        }
        return false;
    }
}

