/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.testing;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.function.JkUnaryOperator;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public final class JkTestSelection<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String STANDARD_INCLUDE_PATTERN = "^(Test.*|.+[.$]Test.*|.*Tests?)$";
    public static final String IT_INCLUDE_PATTERN = ".*IT";
    private JkPathSequence testClassRoots = JkPathSequence.of();
    private Set<String> includePatterns = new LinkedHashSet<String>();
    private Set<String> excludePatterns = new LinkedHashSet<String>();
    private Set<String> includeTags = new LinkedHashSet<String>();
    private Set<String> excludeTags = new LinkedHashSet<String>();
    private JkUnaryOperator<LauncherDiscoveryRequestBuilder> discoveryConfigurer;
    public final transient T __;

    private JkTestSelection(T __) {
        this.__ = __;
    }

    private JkTestSelection(JkTestSelection other) {
        this.__ = other.__;
        this.discoveryConfigurer = other.discoveryConfigurer;
        this.excludePatterns = new HashSet<String>(other.excludePatterns);
        this.excludeTags = new HashSet<String>(other.excludeTags);
        this.testClassRoots = other.testClassRoots;
        this.includePatterns = new HashSet<String>(other.includePatterns);
        this.includeTags = new HashSet<String>(other.includeTags);
    }

    public static JkTestSelection<Void> of() {
        return JkTestSelection.ofParent(null);
    }

    public static <T> JkTestSelection<T> ofParent(T parent) {
        return new JkTestSelection<T>(parent);
    }

    public JkPathSequence getTestClassRoots() {
        return this.testClassRoots;
    }

    public JkTestSelection<T> addTestClassRoots(Iterable<Path> paths) {
        List<Path> pathList = JkUtilsPath.disambiguate(paths);
        this.testClassRoots = this.testClassRoots.and(pathList);
        return this;
    }

    public Set<String> getIncludePatterns() {
        return Collections.unmodifiableSet(this.includePatterns);
    }

    public JkTestSelection<T> addIncludePatterns(Iterable<String> patterns) {
        JkUtilsIterable.addAllWithoutDuplicate(this.includePatterns, patterns);
        return this;
    }

    public JkTestSelection<T> addIncludeStandardPatterns() {
        return this.addIncludePatterns(STANDARD_INCLUDE_PATTERN);
    }

    public JkTestSelection<T> addIncludePatterns(String ... patterns) {
        return this.addIncludePatterns(Arrays.asList(patterns));
    }

    public JkTestSelection<T> addIncludePatternsIf(boolean condition, String ... patterns) {
        if (!condition) {
            return this;
        }
        return this.addIncludePatterns(Arrays.asList(patterns));
    }

    public Set<String> getExcludePatterns() {
        return Collections.unmodifiableSet(this.excludePatterns);
    }

    public JkTestSelection<T> addExcludePatterns(Iterable<String> patterns) {
        JkUtilsIterable.addAllWithoutDuplicate(this.excludePatterns, patterns);
        return this;
    }

    public JkTestSelection<T> addExcludePatterns(String ... patterns) {
        return this.addExcludePatterns(Arrays.asList(patterns));
    }

    public Set<String> getIncludeTags() {
        return Collections.unmodifiableSet(this.includeTags);
    }

    public JkTestSelection<T> addIncludeTags(Iterable<String> patterns) {
        JkUtilsIterable.addAllWithoutDuplicate(this.includeTags, patterns);
        return this;
    }

    public JkTestSelection<T> addIncludeTags(String ... patterns) {
        return this.addIncludeTags(Arrays.asList(patterns));
    }

    public Set<String> getExcludeTags() {
        return this.excludeTags;
    }

    public JkTestSelection<T> addExcludeTags(Iterable<String> patterns) {
        JkUtilsIterable.addAllWithoutDuplicate(this.excludeTags, patterns);
        return this;
    }

    public JkTestSelection<T> addExcludeTags(String ... patterns) {
        return this.addExcludeTags(Arrays.asList(patterns));
    }

    public JkUnaryOperator<LauncherDiscoveryRequestBuilder> getDiscoveryConfigurer() {
        return this.discoveryConfigurer;
    }

    public JkTestSelection<T> setTestClassRoots(UnaryOperator<JkPathSequence> pathSequencer) {
        this.testClassRoots = (JkPathSequence)pathSequencer.apply(this.testClassRoots);
        return this;
    }

    public JkTestSelection<T> setDiscoveryConfigurer(JkUnaryOperator<LauncherDiscoveryRequestBuilder> discoveryConfigurer) {
        this.discoveryConfigurer = discoveryConfigurer;
        return this;
    }

    public JkTestSelection copy() {
        return new JkTestSelection<T>(this);
    }

    public String toString() {
        return "testClassRoots=" + this.testClassRoots.relativizeFromWorkingDir() + ", includePatterns=" + this.includePatterns + ", excludePatterns=" + this.excludePatterns + ", includeTags=" + this.includeTags + ", excludeTags=" + this.excludeTags + ", discoveryConfigurer=" + this.discoveryConfigurer;
    }

    boolean hasTestClasses() {
        return JkPathTreeSet.ofRoots(this.testClassRoots.getEntries()).containFiles();
    }
}

