/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class JkProperties {
    private static final Map<String, String> OVERRIDE_PROPS = new HashMap<String, String>();

    private JkProperties() {
    }

    public static String get(String key) {
        String result = OVERRIDE_PROPS.get(key);
        if (result != null) {
            return result;
        }
        result = System.getProperty(key);
        if (result != null) {
            return JkProperties.interpolate(result);
        }
        result = System.getenv(key);
        if (result != null) {
            return JkProperties.interpolate(result);
        }
        String upperCaseKey = JkProperties.upperCase(key);
        result = System.getenv(upperCaseKey);
        return result == null ? null : JkProperties.interpolate(result);
    }

    public static void override(Map<String, String> overrideProps) {
        OVERRIDE_PROPS.putAll(overrideProps);
    }

    public static void removeOverride() {
        OVERRIDE_PROPS.clear();
    }

    private static String interpolate(String string) {
        return JkUtilsString.interpolate(string, JkProperties::get);
    }

    private static String upperCase(String value) {
        return value.toUpperCase().replace('.', '_').replace('-', '_');
    }

    private static String lowerCase(String value) {
        return value.toLowerCase().replace('_', '.');
    }

    public static Map<String, String> getAllStartingWith(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : JkProperties.find(prefix)) {
            result.put(key, JkProperties.get(key));
        }
        return result;
    }

    public static Set<String> find(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (String extraKey : OVERRIDE_PROPS.keySet()) {
            if (!extraKey.startsWith(prefix)) continue;
            result.add(extraKey);
        }
        Enumeration<?> propNameEnum = System.getProperties().propertyNames();
        while (propNameEnum.hasMoreElements()) {
            String name = (String)propNameEnum.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        String upperCaseKey = JkProperties.upperCase(prefix);
        for (String propName : System.getenv().keySet()) {
            if (!propName.startsWith(prefix) && !propName.startsWith(upperCaseKey)) continue;
            result.add(JkProperties.lowerCase(propName));
        }
        return result;
    }
}

