/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkBraceLogDecorator;
import dev.jeka.core.api.system.JkDebugLogDecorator;
import dev.jeka.core.api.system.JkIndentLogDecorator;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsTime;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

public final class JkLog
implements Serializable {
    private static final NoOpDecorator NO_OP_DECORATOR = new NoOpDecorator();
    private static final PrintStream NO_OP_STREAM = JkUtilsIO.nopPrintStream();
    static final PrintStream INITIAL_OUT = System.out;
    static final PrintStream INITIAL_ERR = System.err;
    private static JkLogDecorator decorator = NO_OP_DECORATOR;
    private static Verbosity verbosity = Verbosity.NORMAL;
    private static AtomicInteger currentNestedTaskLevel = new AtomicInteger(0);
    private static final ThreadLocal<LinkedList<Long>> START_TIMES = new ThreadLocal();
    private static Style decoratorStyle;
    private static boolean acceptAnimation;

    private static LinkedList<Long> getStartTimes() {
        LinkedList<Long> result = START_TIMES.get();
        if (result == null) {
            result = new LinkedList();
            START_TIMES.set(result);
        }
        return result;
    }

    public static void setDecorator(JkLogDecorator newDecorator) {
        newDecorator.doInit(INITIAL_OUT, INITIAL_ERR);
        decorator = newDecorator;
        System.setOut(decorator.getOut());
        System.setErr(decorator.getErr());
    }

    public static void setDecorator(Style style) {
        JkLog.setDecorator(style.decorator);
        decoratorStyle = style;
    }

    public static void restoreToInitialState() {
        System.setOut(INITIAL_OUT);
        System.setErr(INITIAL_ERR);
        decorator = NO_OP_DECORATOR;
    }

    public static void redirect(PrintStream out, PrintStream err) {
        if (decorator != null) {
            decorator.doInit(out, err);
        }
    }

    public static void setVerbosity(Verbosity verbosityArg) {
        JkUtilsAssert.argument(verbosityArg != null, "Verbosity can noot be set to null.", new Object[0]);
        verbosity = verbosityArg;
    }

    public static boolean isAcceptAnimation() {
        return acceptAnimation;
    }

    public static void setAcceptAnimation(boolean acceptAnimation) {
        JkLog.acceptAnimation = acceptAnimation;
    }

    static Style getDecoratorStyle() {
        return decoratorStyle;
    }

    public static int getCurrentNestedLevel() {
        return currentNestedTaskLevel.get();
    }

    public static PrintStream getOutPrintStream() {
        if (Verbosity.MUTE == JkLog.verbosity()) {
            return NO_OP_STREAM;
        }
        return decorator.getOut();
    }

    public static PrintStream getErrPrintStream() {
        if (Verbosity.MUTE == JkLog.verbosity()) {
            return NO_OP_STREAM;
        }
        return decorator.getOut();
    }

    public static void info(String message, Object ... params) {
        JkLog.consume(JkLogEvent.ofRegular(Type.INFO, String.format(message, params)));
    }

    public static void warn(String message, Object ... params) {
        JkLog.consume(JkLogEvent.ofRegular(Type.WARN, String.format(message, params)));
    }

    public static void trace(String message, Object ... params) {
        if (JkLog.verbosity().isVerbose()) {
            JkLog.consume(JkLogEvent.ofRegular(Type.TRACE, String.format(message, params)));
        }
    }

    public static void error(String message, String ... params) {
        JkLog.consume(JkLogEvent.ofRegular(Type.ERROR, String.format(message, params)));
    }

    private static boolean shouldPrint(Type type) {
        if (Verbosity.MUTE == JkLog.verbosity()) {
            return false;
        }
        return Verbosity.WARN_AND_ERRORS != JkLog.verbosity() || type == Type.ERROR || type == Type.WARN;
    }

    public static void startTask(String message, Object ... params) {
        JkLog.consume(JkLogEvent.ofRegular(Type.START_TASK, String.format(message, params)));
        if (JkLog.shouldPrint(Type.START_TASK)) {
            currentNestedTaskLevel.incrementAndGet();
            JkLog.getStartTimes().addLast(System.nanoTime());
        }
    }

    public static void endTask(String message) {
        if (JkLog.shouldPrint(Type.END_TASK)) {
            currentNestedTaskLevel.decrementAndGet();
            Long startTime = JkLog.getStartTimes().pollLast();
            if (startTime == null) {
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    System.err.println(ste);
                }
                throw new IllegalStateException("No start task found matching with this endTask. Check that you don't have used an 'endTask' one too many in your code.");
            }
            Long durationMillis = JkUtilsTime.durationInMillis(startTime);
            JkLog.consume(JkLogEvent.ofEndTask(Type.END_TASK, message, durationMillis));
        }
    }

    public static void endTask() {
        JkLog.endTask("");
    }

    public static boolean isVerbose() {
        return verbosity == Verbosity.VERBOSE;
    }

    private static void consume(JkLogEvent event) {
        if (decorator == null) {
            return;
        }
        if (!JkLog.shouldPrint(event.getType())) {
            return;
        }
        if (event.getClass().getClassLoader() != decorator.getClass().getClassLoader()) {
            Object evt = JkUtilsIO.cloneBySerialization(event, decorator.getClass().getClassLoader());
            try {
                Method accept = decorator.getClass().getMethod("accept", evt.getClass());
                accept.setAccessible(true);
                accept.invoke((Object)decorator, evt);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            decorator.handle(event);
        }
    }

    public static JkLogDecorator getDecorator() {
        return decorator;
    }

    public static Verbosity verbosity() {
        return verbosity;
    }

    static {
        acceptAnimation = true;
    }

    public static class JkState {
        private static JkLogDecorator decorator;
        private static PrintStream stream;
        private static PrintStream errorStream;
        private static Verbosity verbosity;
        private static AtomicInteger currentNestedTaskLevel;

        public static void save() {
            decorator = decorator;
            verbosity = verbosity;
            currentNestedTaskLevel = currentNestedTaskLevel;
        }

        public static void restore() {
            if (currentNestedTaskLevel == null) {
                return;
            }
            decorator = JkState.decorator;
            verbosity = JkState.verbosity;
            currentNestedTaskLevel = JkState.currentNestedTaskLevel;
        }
    }

    private static class NoOpDecorator
    extends JkLogDecorator {
        private NoOpDecorator() {
        }

        @Override
        protected void init(PrintStream out, PrintStream err) {
        }

        @Override
        public PrintStream getOut() {
            return NO_OP_STREAM;
        }

        @Override
        public PrintStream getErr() {
            return NO_OP_STREAM;
        }

        @Override
        public void handle(JkLogEvent event) {
        }
    }

    public static abstract class JkLogDecorator
    implements Serializable {
        private boolean acceptAnimation = true;
        private PrintStream targetOut;
        private PrintStream targetErr;

        final void doInit(PrintStream targetOut, PrintStream targetErr) {
            this.targetOut = targetOut;
            this.targetErr = targetErr;
            this.init(targetOut, targetErr);
        }

        protected abstract void init(PrintStream var1, PrintStream var2);

        protected final PrintStream getTargetOut() {
            return this.targetOut;
        }

        protected final PrintStream getTargetErr() {
            return this.targetErr;
        }

        abstract PrintStream getOut();

        abstract PrintStream getErr();

        abstract void handle(JkLogEvent var1);
    }

    public static class JkLogEvent
    implements Serializable {
        private final Type type;
        private final String message;
        private final long duration;

        private JkLogEvent(Type type, String message, long duration) {
            this.type = type;
            this.message = message;
            this.duration = duration;
        }

        static JkLogEvent ofRegular(Type type, String message) {
            return new JkLogEvent(type, message, -1L);
        }

        static JkLogEvent ofEndTask(Type type, String message, long duration) {
            return new JkLogEvent(type, message, duration);
        }

        public Type getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public long getDurationMs() {
            return this.duration;
        }
    }

    public static enum Style {
        BRACE(new JkBraceLogDecorator()),
        INDENT(new JkIndentLogDecorator()),
        DEBUG(new JkDebugLogDecorator());

        private final JkLogDecorator decorator;

        private Style(JkLogDecorator decorator) {
            this.decorator = decorator;
        }
    }

    public static enum Verbosity {
        MUTE,
        WARN_AND_ERRORS,
        NORMAL,
        VERBOSE,
        QUITE_VERBOSE;


        public boolean isVerbose() {
            return this == VERBOSE || this == QUITE_VERBOSE;
        }
    }

    public static enum Type {
        INFO,
        WARN,
        ERROR,
        TRACE,
        PROGRESS,
        TASK,
        START_TASK,
        END_TASK;


        public boolean isTraceWarnOrError() {
            return this == TRACE || this == WARN || this == ERROR;
        }
    }
}

