/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class JkLocator {
    private static final String JK_USER_HOME_ENV_NAME = "JEKA_USER_HOME";
    private static final String JK_CACHE_ENV_NAME = "JEKA_CACHE_DIR";
    private static Path JEKA_JAR_FILE;

    public static Path getJekaJarPath() {
        Path result;
        if (JEKA_JAR_FILE != null) {
            return JEKA_JAR_FILE;
        }
        try {
            URI uri = JkLocator.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            result = Paths.get(uri);
        }
        catch (Exception e) {
            try {
                URI uri = JkLocator.class.getResource('/' + JkLocator.class.getName().replace('.', '/') + ".class").toURI();
                String uriString = JkUtilsString.substringAfterFirst(uri.toString(), "jar:");
                uriString = JkUtilsString.substringBeforeFirst(uriString, "!");
                result = Paths.get(URI.create(uriString));
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("Cannot find location of jeka jar", ex);
            }
        }
        JEKA_JAR_FILE = result;
        return result;
    }

    public static Path getJekaHomeDir() {
        return JkLocator.getJekaJarPath().getParent();
    }

    public static Path getJekaUserHomeDir() {
        String env = System.getenv(JK_USER_HOME_ENV_NAME);
        Path result = !JkUtilsString.isBlank(env) ? Paths.get(env, new String[0]) : Paths.get(System.getProperty("user.home"), new String[0]).resolve(".jeka");
        return JkLocator.ensureCreated(result);
    }

    public static Path getJekaRepositoryCache() {
        return JkLocator.ensureCreated(JkLocator.getCacheDir().resolve("repo"));
    }

    public static Path getCacheDir() {
        String env = System.getenv(JK_CACHE_ENV_NAME);
        Path result = !JkUtilsString.isBlank(env) ? Paths.get(env, new String[0]) : JkLocator.getJekaUserHomeDir().resolve("cache");
        return JkLocator.ensureCreated(result);
    }

    public static Path getCachedUrlContentDir() {
        return JkLocator.ensureCreated(JkLocator.getCacheDir().resolve("url-content"));
    }

    private static Path ensureCreated(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            JkUtilsPath.createDirectories(path, new FileAttribute[0]);
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            JkUtilsPath.deleteFile(path);
            JkUtilsPath.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }
}

