/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkLog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public final class JkIndentLogDecorator
extends JkLog.JkLogDecorator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    static final byte LINE_SEPARATOR = 10;
    static final byte[] MARGIN_UNIT = "   ".getBytes(UTF8);
    private transient MarginStream marginOut;
    private transient MarginStream marginErr;
    private transient PrintStream out;
    private transient PrintStream err;

    @Override
    protected void init(PrintStream targetOut, PrintStream targetErr) {
        this.marginOut = new MarginStream(targetOut);
        this.marginErr = new MarginStream(targetErr);
        this.out = new PrintStream(this.marginOut);
        this.err = new PrintStream(this.marginErr);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.marginOut = new MarginStream(System.out);
        this.marginErr = new MarginStream(System.err);
    }

    @Override
    public void handle(JkLog.JkLogEvent event) {
        JkLog.Type logType = event.getType();
        PrintStream stream = this.out;
        if (logType == JkLog.Type.ERROR || logType == JkLog.Type.WARN) {
            this.out.flush();
            stream = this.err;
        } else {
            this.err.flush();
        }
        String message = event.getMessage();
        if (event.getType().isTraceWarnOrError()) {
            message = "[" + (Object)((Object)event.getType()) + "] " + message;
        }
        if (logType != JkLog.Type.END_TASK) {
            if (logType == JkLog.Type.START_TASK) {
                this.marginErr.flush();
                this.out.println(message);
                this.marginOut.notifyStart();
                this.marginErr.notifyStart();
                this.marginErr.mustPrintMargin = true;
            } else {
                stream.println(message);
            }
        }
    }

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public PrintStream getErr() {
        return this.err;
    }

    private static class MarginStream
    extends OutputStream {
        private final PrintStream delegate;
        private volatile boolean mustPrintMargin;

        private void notifyStart() {
            this.flush();
        }

        public MarginStream(PrintStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int aByte) throws IOException {
            if (this.mustPrintMargin) {
                this.printMargin();
            }
            this.delegate.write(aByte);
            this.mustPrintMargin = aByte == 10;
        }

        void printMargin() throws IOException {
            Integer level = JkLog.getCurrentNestedLevel();
            for (int j = 0; j < level; ++j) {
                this.delegate.write(MARGIN_UNIT);
            }
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }
}

