/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.system;

import dev.jeka.core.api.system.JkIndentLogDecorator;
import dev.jeka.core.api.system.JkLog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

public final class JkBraceLogDecorator
extends JkLog.JkLogDecorator {
    private static final int MARGIN_UNIT_LENGTH = new String(JkIndentLogDecorator.MARGIN_UNIT, StandardCharsets.UTF_8).length();
    private static int maxLength = -1;
    private transient MarginStream marginOut;
    private transient MarginStream marginErr;
    private transient PrintStream out;
    private transient PrintStream err;

    @Override
    public void init(PrintStream targetOut, PrintStream targetErr) {
        this.marginErr = this.marginOut = new MarginStream(targetOut);
        this.err = this.out = new PrintStream(this.marginOut);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.marginErr = this.marginOut = new MarginStream(System.out);
    }

    public static void setMaxLength(int maxLength) {
        JkBraceLogDecorator.maxLength = maxLength;
    }

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public PrintStream getErr() {
        return this.err;
    }

    @Override
    public void handle(JkLog.JkLogEvent event) {
        String message = event.getMessage();
        if (event.getType() == JkLog.Type.START_TASK) {
            this.out.print(message);
            this.out.print(" {");
            this.marginOut.notifyStart();
            this.marginErr.notifyStart();
        } else if (event.getType() == JkLog.Type.END_TASK) {
            this.marginOut.closingBrace = true;
            this.out.print("}");
            this.out.print(String.format(" Done in %d milliseconds. ", event.getDurationMs()));
            this.out.println(message);
            this.marginOut.closingBrace = false;
            this.marginOut.pendingStart = false;
            this.marginErr.pendingStart = false;
        } else {
            if (event.getType().isTraceWarnOrError()) {
                message = "[" + (Object)((Object)event.getType()) + "] " + message;
            }
            if (event.getType() == JkLog.Type.ERROR || event.getType() == JkLog.Type.WARN) {
                this.out.flush();
                this.err.println(message);
                this.marginOut.pendingStart = false;
            } else {
                this.err.flush();
                this.out.println(message);
                this.marginErr.pendingStart = false;
            }
        }
    }

    private static class MarginStream
    extends OutputStream {
        private final PrintStream delegate;
        private int lastByte = 10;
        private volatile boolean pendingStart;
        private boolean closingBrace;

        private void notifyStart() {
            this.flush();
            this.pendingStart = true;
        }

        public MarginStream(PrintStream delegate) {
            this.delegate = delegate;
            this.pendingStart = this.pendingStart;
        }

        @Override
        public void write(int aByte) throws IOException {
            if (this.pendingStart && !this.closingBrace) {
                this.delegate.write(10);
                this.lastByte = 10;
                this.pendingStart = false;
            }
            if (this.lastByte == 10) {
                Integer level = JkLog.getCurrentNestedLevel();
                for (int j = 0; j < level; ++j) {
                    this.delegate.write(JkIndentLogDecorator.MARGIN_UNIT);
                }
            }
            this.delegate.write(aByte);
            this.lastByte = aByte;
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }
}

