/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.project.JkCompileLayout;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.tooling.JkGitProcess;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class JkProjectSimpleFacade {
    private final JkProject project;

    JkProjectSimpleFacade(JkProject project) {
        this.project = project;
    }

    public JkProjectSimpleFacade setJvmTargetVersion(JkJavaVersion version) {
        this.project.getConstruction().setJvmTargetVersion(version);
        return this;
    }

    public JkProjectSimpleFacade applyOnProject(Consumer<JkProject> projectConsumer) {
        this.project.apply(projectConsumer);
        return this;
    }

    public JkProjectSimpleFacade apply(Consumer<JkProjectSimpleFacade> facadeConsumer) {
        facadeConsumer.accept(this);
        return this;
    }

    public JkProjectSimpleFacade setBaseDir(String path) {
        this.project.setBaseDir(Paths.get(path, new String[0]));
        return this;
    }

    public JkProjectSimpleFacade setBaseDir(Path path) {
        this.project.setBaseDir(path);
        return this;
    }

    public JkProjectSimpleFacade setJavaSourceEncoding(String sourceEncoding) {
        this.project.getConstruction().setSourceEncoding(sourceEncoding);
        return this;
    }

    public JkProjectSimpleFacade useSimpleLayout() {
        this.project.getConstruction().getCompilation().getLayout().setSourceSimpleStyle(JkCompileLayout.Concern.PROD);
        this.project.getConstruction().getTesting().getCompilation().getLayout().setSourceSimpleStyle(JkCompileLayout.Concern.TEST);
        return this;
    }

    public JkProjectSimpleFacade mixResourcesAndSources() {
        this.project.getConstruction().getCompilation().getLayout().mixResourcesAndSources();
        this.project.getConstruction().getTesting().getCompilation().getLayout().mixResourcesAndSources();
        return this;
    }

    public JkProjectSimpleFacade configureCompileDeps(Function<JkDependencySet, JkDependencySet> modifier) {
        this.project.getConstruction().getCompilation().configureDependencies(modifier);
        return this;
    }

    public JkProjectSimpleFacade includeJavadocAndSources(boolean includeJavaDoc, boolean includeSources) {
        this.project.includeJavadocAndSources(includeJavaDoc, includeSources);
        return this;
    }

    public JkProjectSimpleFacade configureTestDeps(Function<JkDependencySet, JkDependencySet> modifier) {
        this.project.getConstruction().getTesting().getCompilation().configureDependencies(modifier);
        return this;
    }

    public JkProjectSimpleFacade skipTests(boolean skipped) {
        this.project.getConstruction().getTesting().setSkipped(skipped);
        return this;
    }

    public JkProjectSimpleFacade addTestDependencies(Function<JkDependencySet, JkDependencySet> modifier) {
        return this.configureTestDeps(deps -> deps.and(JkDependencySet.Hint.first(), (JkDependencySet)modifier.apply(JkDependencySet.of())));
    }

    public JkProjectSimpleFacade configureRuntimeDeps(UnaryOperator<JkDependencySet> modifier) {
        this.project.getConstruction().configureRuntimeDependencies(modifier);
        return this;
    }

    public JkProjectSimpleFacade setPublishedVersion(Supplier<String> versionSupplier) {
        this.project.getPublication().setVersion(versionSupplier);
        return this;
    }

    public JkProjectSimpleFacade setPublishedVersion(String version) {
        return this.setPublishedVersion(() -> version);
    }

    public JkProjectSimpleFacade setPublishedVersionFromGitTag() {
        return this.setPublishedVersion(() -> JkGitProcess.of(this.getProject().getBaseDir()).getVersionFromTag());
    }

    public JkProjectSimpleFacade setPublishedVersionFromGitTagCommitMessage(String suffixKeyword) {
        return this.setPublishedVersion(() -> JkGitProcess.of(this.getProject().getBaseDir()).getVersionFromCommitMessage(suffixKeyword));
    }

    public JkProjectSimpleFacade setPublishedModuleId(String moduleId) {
        this.project.getPublication().setModuleId(moduleId);
        return this;
    }

    public JkProjectSimpleFacade configurePublishedDeps(Function<JkDependencySet, JkDependencySet> dependencyModifier) {
        this.project.getPublication().getMaven().configureDependencies(dependencyModifier);
        return this;
    }

    public JkProjectSimpleFacade addTestExcludeFilterSuffixedBy(String suffix, boolean condition) {
        if (condition) {
            this.project.getConstruction().getTesting().getTestSelection().addExcludePatterns(".*" + suffix);
        }
        return this;
    }

    public JkProjectSimpleFacade addTestIncludeFilterSuffixedBy(String suffix, boolean condition) {
        this.project.getConstruction().getTesting().getTestSelection().addIncludePatternsIf(condition, ".*" + suffix);
        return this;
    }

    public JkProjectSimpleFacade addTestIncludeFilterOnStandardNaming(boolean condition) {
        this.project.getConstruction().getTesting().getTestSelection().addIncludePatternsIf(condition, "^(Test.*|.+[.$]Test.*|.*Tests?)$");
        return this;
    }

    public JkProject getProject() {
        return this.project;
    }
}

