/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkLocalProjectDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkStandardFileArtifactProducer;
import dev.jeka.core.api.depmanagement.publication.JkIvyPublication;
import dev.jeka.core.api.depmanagement.publication.JkMavenPublication;
import dev.jeka.core.api.project.JkIdeSupport;
import dev.jeka.core.api.project.JkProjectConstruction;
import dev.jeka.core.api.project.JkProjectDocumentation;
import dev.jeka.core.api.project.JkProjectPublication;
import dev.jeka.core.api.project.JkProjectSimpleFacade;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;

public class JkProject
implements JkIdeSupport.JkSupplier {
    public static final JkArtifactId SOURCES_ARTIFACT_ID = JkArtifactId.of("sources", "jar");
    public static final JkArtifactId JAVADOC_ARTIFACT_ID = JkArtifactId.of("javadoc", "jar");
    private Path baseDir = Paths.get("", new String[0]);
    private String outputDir = "jeka/output";
    private final JkStandardFileArtifactProducer<JkProject> artifactProducer = JkStandardFileArtifactProducer.ofParent(this).setArtifactFilenameComputation(this::getArtifactPath);
    private JkVersionedModule.ConflictStrategy duplicateConflictStrategy = JkVersionedModule.ConflictStrategy.FAIL;
    private final JkProjectDocumentation documentation;
    private final JkProjectConstruction construction;
    private final JkProjectPublication publication;
    public Function<JkIdeSupport, JkIdeSupport> ideSupportModifier = x -> x;

    private JkProject() {
        this.documentation = new JkProjectDocumentation(this);
        this.construction = new JkProjectConstruction(this);
        this.registerArtifacts();
        this.publication = new JkProjectPublication(this);
    }

    public static JkProject of() {
        return new JkProject();
    }

    public JkProject apply(Consumer<JkProject> projectConsumer) {
        projectConsumer.accept(this);
        return this;
    }

    public JkProjectSimpleFacade simpleFacade() {
        return new JkProjectSimpleFacade(this);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public JkProject setBaseDir(Path baseDir) {
        this.baseDir = JkUtilsPath.relativizeFromWorkingDir(baseDir);
        return this;
    }

    public Path getOutputDir() {
        return this.baseDir.resolve(this.outputDir);
    }

    public JkProject setOutputDir(String relativePath) {
        this.outputDir = relativePath;
        return this;
    }

    public JkVersionedModule.ConflictStrategy getDuplicateConflictStrategy() {
        return this.duplicateConflictStrategy;
    }

    public JkProject setDuplicateConflictStrategy(JkVersionedModule.ConflictStrategy duplicateConflictStrategy) {
        this.duplicateConflictStrategy = duplicateConflictStrategy;
        return this;
    }

    public JkProjectConstruction getConstruction() {
        return this.construction;
    }

    public JkProjectPublication getPublication() {
        return this.publication;
    }

    public JkProjectDocumentation getDocumentation() {
        return this.documentation;
    }

    public JkStandardFileArtifactProducer<JkProject> getArtifactProducer() {
        return this.artifactProducer;
    }

    public String toString() {
        return "project " + this.getBaseDir().getFileName();
    }

    public String getInfo() {
        JkIvyPublication<JkProjectPublication> ivyPublication;
        JkDependencySet compileDependencies = this.construction.getCompilation().getDependencies();
        JkDependencySet runtimeDependencies = this.construction.getRuntimeDependencies();
        JkDependencySet testDependencies = this.construction.getTesting().getCompilation().getDependencies();
        StringBuilder builder = new StringBuilder("Project Location : " + this.getBaseDir() + "\n").append("Production sources : " + this.construction.getCompilation().getLayout().getInfo()).append("\n").append("Test sources : " + this.construction.getTesting().getCompilation().getLayout().getInfo()).append("\n").append("Java Source Version : " + this.construction.getJvmTargetVersion() + "\n").append("Source Encoding : " + this.construction.getSourceEncoding() + "\n").append("Source file count : " + this.construction.getCompilation().getLayout().resolveSources().count(Integer.MAX_VALUE, false) + "\n").append("Download Repositories : " + this.construction.getDependencyResolver().getRepos() + "\n").append("Declared Compile Dependencies : " + compileDependencies.getEntries().size() + " elements.\n");
        compileDependencies.getVersionedDependencies().forEach(dep -> builder.append("  " + dep + "\n"));
        builder.append("Declared Runtime Dependencies : " + runtimeDependencies.getEntries().size() + " elements.\n");
        runtimeDependencies.getVersionedDependencies().forEach(dep -> builder.append("  " + dep + "\n"));
        builder.append("Declared Test Dependencies : " + testDependencies.getEntries().size() + " elements.\n");
        testDependencies.getVersionedDependencies().forEach(dep -> builder.append("  " + dep + "\n"));
        builder.append("Defined Artifacts : " + this.artifactProducer.getArtifactIds());
        JkMavenPublication<JkProjectPublication> mavenPublication = this.publication.getMaven();
        if (mavenPublication.getModuleId() != null) {
            builder.append("Publish Maven repositories : " + mavenPublication.getPublishRepos() + "\n").append("Published Maven Module & version : " + mavenPublication.getModuleId().withVersion(mavenPublication.getVersion()) + "\n").append("Published Maven Dependencies :");
            mavenPublication.getDependencies().getEntries().forEach(dep -> builder.append("\n  " + dep));
        }
        if ((ivyPublication = this.publication.getIvy()).getModuleId() != null) {
            builder.append("Publish Ivy repositories : " + ivyPublication.getRepos() + "\n").append("Published Ivy Module & version : " + ivyPublication.getModuleId().withVersion(mavenPublication.getVersion()) + "\n").append("Published Ivy Dependencies :");
            ivyPublication.getDependencies().getEntries().forEach(dep -> builder.append("\n  " + dep));
        }
        return builder.toString();
    }

    @Override
    public JkIdeSupport getJavaIdeSupport() {
        JkQualifiedDependencySet qualifiedDependencies = JkQualifiedDependencySet.computeIdeDependencies(this.construction.getProjectDependencies(), JkVersionedModule.ConflictStrategy.TAKE_FIRST);
        JkIdeSupport ideSupport = JkIdeSupport.of(this.baseDir).setSourceVersion(this.construction.getJvmTargetVersion()).setProdLayout(this.construction.getCompilation().getLayout()).setTestLayout(this.construction.getTesting().getCompilation().getLayout()).setGeneratedSourceDirs(this.construction.getCompilation().getGeneratedSourceDirs()).setDependencies(qualifiedDependencies).setDependencyResolver(this.construction.getDependencyResolver());
        return this.ideSupportModifier.apply(ideSupport);
    }

    public void setJavaIdeSupport(Function<JkIdeSupport, JkIdeSupport> ideSupport) {
        this.ideSupportModifier = this.ideSupportModifier.andThen(ideSupport);
    }

    public JkLocalProjectDependency toDependency() {
        return this.toDependency(this.artifactProducer.getMainArtifactId(), null);
    }

    public JkLocalProjectDependency toDependency(JkTransitivity transitivity) {
        return this.toDependency(this.artifactProducer.getMainArtifactId(), transitivity);
    }

    public JkLocalProjectDependency toDependency(JkArtifactId artifactId, JkTransitivity transitivity) {
        Runnable maker = () -> this.artifactProducer.makeArtifact(artifactId);
        Path artifactPath = this.artifactProducer.getArtifactPath(artifactId);
        JkDependencySet exportedDependencies = this.construction.getCompilation().getDependencies().merge(this.construction.getRuntimeDependencies()).getResult();
        return JkLocalProjectDependency.of(maker, artifactPath, this.baseDir, exportedDependencies).withTransitivity(transitivity);
    }

    private Path getArtifactPath(JkArtifactId artifactId) {
        JkModuleId moduleId = this.publication.getModuleId();
        String fileBaseName = moduleId != null ? moduleId.getDotedName() : this.baseDir.toAbsolutePath().getFileName().toString();
        return this.baseDir.resolve(this.outputDir).resolve(artifactId.toFileName(fileBaseName));
    }

    public void pack() {
        this.artifactProducer.makeAllMissingArtifacts();
    }

    private void registerArtifacts() {
        this.artifactProducer.putMainArtifact(this.construction::createBinJar);
        this.artifactProducer.putArtifact(SOURCES_ARTIFACT_ID, this.documentation::createSourceJar);
        this.artifactProducer.putArtifact(JAVADOC_ARTIFACT_ID, this.documentation::createJavadocJar);
    }

    public JkProject includeJavadocAndSources(boolean includeJavaDoc, boolean includeSources) {
        if (includeJavaDoc) {
            this.artifactProducer.putArtifact(JAVADOC_ARTIFACT_ID, this.documentation::createJavadocJar);
        } else {
            this.artifactProducer.removeArtifact(JAVADOC_ARTIFACT_ID);
        }
        if (includeSources) {
            this.artifactProducer.putArtifact(SOURCES_ARTIFACT_ID, this.documentation::createSourceJar);
        } else {
            this.artifactProducer.removeArtifact(SOURCES_ARTIFACT_ID);
        }
        return this;
    }
}

