/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.depmanagement.JkProjectDependencies;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkDependencyResolver;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.project.JkCompileLayout;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class JkIdeSupport {
    private JkCompileLayout<JkIdeSupport> prodLayout;
    private JkCompileLayout<JkIdeSupport> testLayout;
    private JkQualifiedDependencySet dependencies;
    private JkJavaVersion sourceVersion;
    private JkDependencyResolver dependencyResolver;
    private List<Path> generatedSourceDirs = new LinkedList<Path>();

    private JkIdeSupport(Path baseDir) {
        this.prodLayout = JkCompileLayout.ofParent(this).setBaseDir(baseDir);
        this.testLayout = JkCompileLayout.ofParent(this).setSourceMavenStyle(JkCompileLayout.Concern.TEST).setStandardOutputDirs(JkCompileLayout.Concern.TEST).setBaseDir(baseDir);
        this.dependencies = JkQualifiedDependencySet.of();
        this.sourceVersion = JkJavaVersion.V8;
        this.dependencyResolver = JkDependencyResolver.of().addRepos(JkRepo.ofLocal(), JkRepo.ofMavenCentral());
    }

    public static JkIdeSupport of(Path baseDir) {
        return new JkIdeSupport(baseDir);
    }

    public JkCompileLayout<JkIdeSupport> getProdLayout() {
        return this.prodLayout;
    }

    public JkCompileLayout<JkIdeSupport> getTestLayout() {
        return this.testLayout;
    }

    public JkQualifiedDependencySet getDependencies() {
        return this.dependencies;
    }

    public JkJavaVersion getSourceVersion() {
        return this.sourceVersion;
    }

    public JkDependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public List<Path> getGeneratedSourceDirs() {
        return this.generatedSourceDirs;
    }

    public JkIdeSupport setProdLayout(JkCompileLayout prodLayout) {
        this.prodLayout = prodLayout;
        return this;
    }

    public JkIdeSupport setTestLayout(JkCompileLayout testLayout) {
        this.testLayout = testLayout;
        return this;
    }

    public JkIdeSupport setDependencies(JkQualifiedDependencySet dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public JkIdeSupport setDependencies(JkProjectDependencies projectDependencies, JkVersionedModule.ConflictStrategy conflictStrategy) {
        return this.setDependencies(JkQualifiedDependencySet.computeIdeDependencies(projectDependencies, conflictStrategy));
    }

    public JkIdeSupport setDependencies(JkProjectDependencies projectDependencies) {
        return this.setDependencies(projectDependencies, JkVersionedModule.ConflictStrategy.FAIL);
    }

    public JkIdeSupport setSourceVersion(JkJavaVersion sourceVersion) {
        this.sourceVersion = sourceVersion;
        return this;
    }

    public JkIdeSupport setDependencyResolver(JkDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        return this;
    }

    public JkIdeSupport setGeneratedSourceDirs(List<Path> generatedSourceDirs) {
        this.generatedSourceDirs = generatedSourceDirs;
        return this;
    }

    public static interface JkSupplier {
        public JkIdeSupport getJavaIdeSupport();
    }
}

