/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.project;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.function.Supplier;

public class JkCompileLayout<T> {
    private static final String GENERATED_SOURCE_PATH = "generated_sources/java";
    private static final String GENERATED_RESOURCE_PATH = "generated_resources";
    private static final String GENERATED_TEST_SOURCE_PATH = "generated_test_sources/java";
    private static final String GENERATED_TEST_RESOURCE_PATH = "generated_test_resources";
    public static final PathMatcher JAVA_RESOURCE_MATCHER = JkPathMatcher.of(false, "**/*.java", "*.java", "**/package.html", "package.html", "**/doc-files", "doc-files");
    public final T __;
    private Supplier<Path> baseDirSupplier;
    private Supplier<Path> outputDirSupplier;
    private JkPathTreeSet sources;
    private JkPathTreeSet resources;
    private String generatedSourceDir;
    private String generatedResourceDir;
    private String classDir;

    private JkCompileLayout(T parent) {
        this.__ = parent;
        this.baseDirSupplier = () -> Paths.get("", new String[0]);
        this.outputDirSupplier = () -> this.baseDirSupplier.get().resolve("jeka/output");
        this.setSourceMavenStyle(Concern.PROD);
        this.setStandardOutputDirs(Concern.PROD);
    }

    public static <T> JkCompileLayout<T> ofParent(T parent) {
        return new JkCompileLayout<T>(parent);
    }

    public static <T> JkCompileLayout<T> of() {
        return JkCompileLayout.ofParent(null);
    }

    public JkCompileLayout<T> setSourceMavenStyle(Concern concern) {
        if (concern == Concern.PROD) {
            this.sources = JkPathTreeSet.ofRoots(Paths.get("src/main/java", new String[0]));
            this.resources = JkPathTreeSet.ofRoots(Paths.get("src/main/resources", new String[0]));
        } else {
            this.sources = JkPathTreeSet.ofRoots(Paths.get("src/test/java", new String[0]));
            this.resources = JkPathTreeSet.ofRoots(Paths.get("src/test/resources", new String[0]));
        }
        return this;
    }

    public JkCompileLayout<T> setSourceSimpleStyle(Concern concern) {
        if (concern == Concern.PROD) {
            this.sources = JkPathTreeSet.ofRoots(Paths.get("src", new String[0]));
            this.resources = JkPathTreeSet.ofRoots(Paths.get("src", new String[0])).andMatcher(JAVA_RESOURCE_MATCHER);
        } else {
            this.sources = JkPathTreeSet.ofRoots(Paths.get("test", new String[0]));
            this.resources = JkPathTreeSet.ofRoots(Paths.get("test", new String[0])).andMatcher(JAVA_RESOURCE_MATCHER);
        }
        return this;
    }

    public JkCompileLayout<T> setStandardOutputDirs(Concern concern) {
        if (concern == Concern.PROD) {
            this.classDir = "classes";
            this.generatedSourceDir = GENERATED_SOURCE_PATH;
            this.generatedResourceDir = GENERATED_RESOURCE_PATH;
        } else {
            this.classDir = "test-classes";
            this.generatedSourceDir = GENERATED_TEST_SOURCE_PATH;
            this.generatedResourceDir = GENERATED_TEST_RESOURCE_PATH;
        }
        return this;
    }

    public JkCompileLayout<T> setSources(JkPathTreeSet sources) {
        this.sources = sources;
        return this;
    }

    public JkCompileLayout<T> setSources(JkPathTree sources) {
        return this.setSources(sources.toSet());
    }

    public JkCompileLayout<T> setSources(Function<JkPathTreeSet, JkPathTreeSet> sourceTransformer) {
        this.sources = sourceTransformer.apply(this.sources);
        return this;
    }

    public JkCompileLayout<T> addSource(JkPathTree source) {
        return this.setSources(this.sources.and(source));
    }

    public JkCompileLayout<T> addSource(JkPathTreeSet source) {
        return this.setSources(this.sources.and(source));
    }

    public JkCompileLayout<T> setSources(String dir) {
        return this.setSources(JkPathTreeSet.ofRoots(Paths.get(dir, new String[0])));
    }

    public JkCompileLayout<T> addSource(Path dir) {
        return this.addSource(JkPathTree.of(dir));
    }

    public JkCompileLayout<T> addSource(String path) {
        return this.addSource(Paths.get(path, new String[0]));
    }

    public JkCompileLayout<T> emptySources() {
        return this.setSources(JkPathTreeSet.ofEmpty());
    }

    public JkCompileLayout<T> setResources(JkPathTreeSet resources) {
        this.resources = resources;
        return this;
    }

    public JkCompileLayout<T> addResource(JkPathTree resource) {
        return this.setResources(this.resources.and(resource));
    }

    public JkCompileLayout<T> addResource(Path path) {
        return this.addResource((JkPathTree)JkPathTree.of(path).andMatcher(JAVA_RESOURCE_MATCHER));
    }

    public JkCompileLayout<T> addResource(String relativeDir) {
        return this.addResource(Paths.get(relativeDir, new String[0]));
    }

    public JkCompileLayout<T> emptyResources() {
        return this.setResources(JkPathTreeSet.ofEmpty());
    }

    public JkCompileLayout<T> mixResourcesAndSources() {
        return this.setResources(this.sources.withMatcher(JAVA_RESOURCE_MATCHER));
    }

    public JkCompileLayout<T> setBaseDirSupplier(Supplier<Path> supplier) {
        this.baseDirSupplier = supplier;
        return this;
    }

    public JkCompileLayout<T> setBaseDir(Path path) {
        return this.setBaseDirSupplier(() -> path);
    }

    public JkCompileLayout<T> setOutputDirSupplier(Supplier<Path> supplier) {
        this.outputDirSupplier = supplier;
        return this;
    }

    public JkCompileLayout<T> setOutputDir(Path path) {
        return this.setOutputDirSupplier(() -> path);
    }

    public JkCompileLayout<T> setGeneratedSourceDir(String path) {
        this.generatedSourceDir = path;
        return this;
    }

    public JkCompileLayout<T> setGeneratedResourceDir(String path) {
        this.generatedResourceDir = path;
        return this;
    }

    public JkCompileLayout<T> setClassDir(String path) {
        this.classDir = path;
        return this;
    }

    public void deleteOutputDirs() {
        JkPathTree.of(this.resolveClassDir()).deleteContent();
        JkPathTree.of(this.resolveGeneratedSourceDir()).deleteContent();
        JkPathTree.of(this.resolveGeneratedResourceDir()).deleteContent();
    }

    public Path getBaseDir() {
        return this.baseDirSupplier.get();
    }

    public Path getOutputDir() {
        return this.outputDirSupplier.get();
    }

    public JkPathTreeSet getSources() {
        return this.sources;
    }

    public JkPathTreeSet getResources() {
        return this.resources;
    }

    public String getGeneratedSourceDir() {
        return this.generatedSourceDir;
    }

    public String getGeneratedResourceDir() {
        return this.generatedResourceDir;
    }

    public String getClassDir() {
        return this.classDir;
    }

    public Path getClassDirPath() {
        return this.getOutputDir().resolve(this.classDir);
    }

    public Path resolveClassDir() {
        return this.outputDirSupplier.get().resolve(this.classDir);
    }

    public Path resolveGeneratedSourceDir() {
        return this.outputDirSupplier.get().resolve(this.generatedSourceDir);
    }

    public Path resolveGeneratedResourceDir() {
        return this.outputDirSupplier.get().resolve(this.generatedResourceDir);
    }

    public JkPathTreeSet resolveSources() {
        return this.sources.resolvedTo(this.baseDirSupplier.get());
    }

    public JkPathTreeSet resolveResources() {
        return this.resources.resolvedTo(this.baseDirSupplier.get());
    }

    public String getInfo() {
        return "Sources =" + this.sources + ", Resources = " + this.resources;
    }

    public static enum Concern {
        PROD,
        TEST;

    }
}

