/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.marshalling.xml;

import dev.jeka.core.api.marshalling.xml.JkDomXPath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JkDomElement {
    public final JkDomElement __;
    private Element w3cElement;
    private ElementProxy proxyElement;

    private JkDomElement(JkDomElement parent, Element element) {
        this.__ = parent;
        this.w3cElement = element;
    }

    private JkDomElement(JkDomElement __, JkDomElement parent, String name) {
        this.__ = __;
        this.proxyElement = ElementProxy.of(parent, name);
    }

    public static JkDomElement of(Element element) {
        return new JkDomElement(null, element);
    }

    public static <P> JkDomElement of(JkDomElement parent, Element element) {
        return new JkDomElement(parent, element);
    }

    public Element getW3cElement() {
        return this.w3cElement;
    }

    public JkDomElement attr(String name, String value) {
        if (value == null) {
            return this;
        }
        this.assertExist();
        this.w3cElement.setAttribute(name, value);
        return this;
    }

    public String attr(String name) {
        return this.w3cElement.getAttribute(name);
    }

    public JkDomElement removeAttr(String name) {
        this.assertExist();
        this.w3cElement.removeAttribute(name);
        return this;
    }

    public JkDomElement text(String text) {
        this.assertExist();
        this.w3cElement.setTextContent(text);
        return this;
    }

    public String text() {
        if (!this.exist()) {
            return null;
        }
        return this.w3cElement.getTextContent();
    }

    public JkDomElement add(String name) {
        this.assertExist();
        Element newElement = this.w3cElement.getOwnerDocument().createElement(name);
        this.w3cElement.appendChild(newElement);
        return new JkDomElement(this, newElement);
    }

    public JkDomElement get(String name) {
        if (!this.exist()) {
            return ElementProxy.of(this, name).create();
        }
        NodeList nodeList = this.w3cElement.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            return new JkDomElement(this, (Element)nodeList.item(0));
        }
        return new JkDomElement(this, this, name);
    }

    public List<JkDomElement> children(String name, Predicate<JkDomElement> predicate) {
        if (!this.exist()) {
            return Collections.emptyList();
        }
        LinkedList<JkDomElement> result = new LinkedList<JkDomElement>();
        NodeList nodeList = this.w3cElement.getElementsByTagName(name);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            JkDomElement el = new JkDomElement(this, (Element)nodeList.item(i));
            if (!predicate.test(el)) continue;
            result.add(el);
        }
        return Collections.unmodifiableList(result);
    }

    public List<JkDomElement> children(String name) {
        return this.children(name, el -> true);
    }

    public JkDomElement child(String name, Predicate<JkDomElement> predicate) {
        if (!this.exist()) {
            return null;
        }
        NodeList nodeList = this.w3cElement.getElementsByTagName(name);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            JkDomElement el = new JkDomElement(this, (Element)nodeList.item(i));
            if (!predicate.test(el)) continue;
            return el;
        }
        return null;
    }

    public JkDomElement child(String name) {
        return this.child(name, jkDomElement -> true);
    }

    public List<JkDomElement> xPath(XPathExpression xPathExpression) {
        NodeList nodeList;
        LinkedList<JkDomElement> result = new LinkedList<JkDomElement>();
        try {
            nodeList = (NodeList)xPathExpression.evaluate(this.w3cElement, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Error when evaluating xPath expression " + xPathExpression, e);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            JkDomElement el = new JkDomElement(this, (Element)nodeList.item(i));
            result.add(el);
        }
        return Collections.unmodifiableList(result);
    }

    public List<JkDomElement> xPath(String xPathExpression) {
        XPathExpression compiledExpression = JkDomXPath.compile(xPathExpression);
        return this.xPath(compiledExpression);
    }

    public JkDomElement addSibling(String name) {
        this.assertExist();
        Element newElement = this.w3cElement.getOwnerDocument().createElement(name);
        this.w3cElement.getParentNode().insertBefore(newElement, this.w3cElement);
        return JkDomElement.of(this.__, newElement);
    }

    public JkDomElement remove() {
        this.assertExist();
        this.w3cElement.getParentNode().removeChild(this.w3cElement);
        return this;
    }

    public JkDomElement apply(Consumer<JkDomElement> consumer) {
        this.assertExist();
        consumer.accept(this);
        return this;
    }

    public JkDomElement applyIf(boolean condition, Consumer<JkDomElement> consumer) {
        if (!condition) {
            return this;
        }
        this.assertExist();
        consumer.accept(this);
        return this;
    }

    public boolean exist() {
        return this.w3cElement != null;
    }

    public JkDomElement make() {
        if (!this.exist()) {
            this.w3cElement = this.proxyElement.create().w3cElement;
            this.proxyElement = null;
        }
        return this;
    }

    private void assertExist() {
        if (this.w3cElement == null) {
            throw new IllegalStateException("Element " + this + " does not exist. Please, invoke #make() prior trying to modify it.");
        }
    }

    private String getName() {
        if (this.exist()) {
            return this.w3cElement.getNodeName();
        }
        return this.proxyElement.name;
    }

    public String toString() {
        if (this.__ == null || !(this.__ instanceof JkDomElement)) {
            return this.getName();
        }
        return this.__ + "/" + this.getName();
    }

    private static class ElementProxy {
        private final JkDomElement parent;
        private final String name;

        private ElementProxy(JkDomElement parent, String name) {
            this.name = name;
            this.parent = parent;
        }

        static ElementProxy of(JkDomElement parent, String name) {
            return new ElementProxy(parent, name);
        }

        JkDomElement create() {
            this.parent.make();
            return this.parent.add(this.name);
        }
    }
}

