/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.kotlin;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaVersion;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class JkKotlinJvmCompileSpec {
    public static final String SOURCE_OPTS = "-source";
    public static final String TARGET_OPTS = "-jvm-target";
    public static final String PROCESSOR_OPTS = "-processor";
    public static final String ENCODING_OPTS = "-encoding";
    private static final String CLASSPATH_OPTS = "-cp";
    private static final String OUTPUT_DIR_OPTS = "-d";
    private final List<String> options = new LinkedList<String>();
    private JkPathTreeSet sources = JkPathTreeSet.ofEmpty();

    private JkKotlinJvmCompileSpec() {
    }

    public static JkKotlinJvmCompileSpec of() {
        return new JkKotlinJvmCompileSpec();
    }

    public List<String> getOptions() {
        return this.options;
    }

    public Path getOutputDir() {
        String path = this.findValueAfter(OUTPUT_DIR_OPTS);
        return path == null ? null : Paths.get(path, new String[0]);
    }

    public JkKotlinJvmCompileSpec setOutputDir(Path outputDir) {
        return this.addOptions(OUTPUT_DIR_OPTS, outputDir.toString());
    }

    public JkJavaVersion getTargetVersion() {
        String rawResult = this.getNextValue(TARGET_OPTS);
        if (rawResult == null) {
            return null;
        }
        return JkJavaVersion.of(rawResult);
    }

    public JkKotlinJvmCompileSpec setTargetVersion(JkJavaVersion version) {
        if (version == null) {
            return this;
        }
        String versionString = version.get();
        if (versionString.equals("8")) {
            versionString = "1.8";
        }
        return this.setOption(TARGET_OPTS, versionString);
    }

    public String getEncoding() {
        return this.getNextValue(ENCODING_OPTS);
    }

    public JkKotlinJvmCompileSpec setEncoding(String encoding) {
        if (encoding == null) {
            return this;
        }
        return this.setOption(ENCODING_OPTS, encoding);
    }

    public JkKotlinJvmCompileSpec setSources(Function<JkPathTreeSet, JkPathTreeSet> modifier) {
        return this.setSources(modifier.apply(this.sources));
    }

    public JkKotlinJvmCompileSpec setSources(JkPathTreeSet sources) {
        this.sources = sources.mergeDuplicateRoots();
        return this;
    }

    public JkPathTreeSet getSources() {
        return this.sources;
    }

    public JkKotlinJvmCompileSpec setClasspath(Iterable<Path> files) {
        String classpath = JkPathSequence.of(files).normalized().toPath();
        if (JkUtilsSystem.IS_WINDOWS) {
            classpath = '\"' + classpath + '\"';
        }
        return this.setOption(CLASSPATH_OPTS, classpath);
    }

    public JkPathSequence getClasspath() {
        Iterator<String> it = this.options.iterator();
        String value = null;
        while (it.hasNext() && value == null) {
            String option = it.next();
            if (!option.equals(CLASSPATH_OPTS) || !it.hasNext()) continue;
            value = it.next();
        }
        if (value == null) {
            return JkPathSequence.of();
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return JkPathSequence.of(Arrays.asList(value.split(File.pathSeparator)).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
    }

    public JkKotlinJvmCompileSpec addOptions(String ... options) {
        return this.addOptions(Arrays.asList(options));
    }

    public JkKotlinJvmCompileSpec addOptions(Iterable<String> options) {
        options.forEach(option -> this.options.add((String)option));
        return this;
    }

    public JkKotlinJvmCompileSpec setOption(String optionName, String optionValue) {
        this.addOrReplace(optionName, optionValue);
        return this;
    }

    public JkKotlinJvmCompileSpec setAnnotationProcessors(String ... annotationProcessorClassNames) {
        return this.setOption(PROCESSOR_OPTS, String.join((CharSequence)",", annotationProcessorClassNames));
    }

    public JkKotlinJvmCompileSpec disableAnnotationProcessing() {
        return this.addOptions("-proc:none");
    }

    public JkKotlinJvmCompileSpec setAnnotationProcessingOnly() {
        return this.addOptions("-proc:only");
    }

    public String getNextValue(String optionName) {
        return this.findValueAfter(optionName);
    }

    private String findValueAfter(String optionName) {
        Iterator<String> it = this.options.iterator();
        while (it.hasNext()) {
            String optionItem = it.next();
            if (!optionItem.equals(optionName) || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    private void addOrReplace(String optionName, String value) {
        int index = this.options.indexOf(optionName);
        while (index >= 0) {
            this.options.remove(index);
            if (index < this.options.size()) {
                this.options.remove(index);
            }
            index = this.options.indexOf(optionName);
        }
        this.options.add(optionName);
        this.options.add(value);
    }

    public JkKotlinJvmCompileSpec copy() {
        JkKotlinJvmCompileSpec result = new JkKotlinJvmCompileSpec();
        result.options.addAll(this.options);
        result.sources = this.sources;
        return result;
    }
}

