/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkClassLoader;
import dev.jeka.core.api.java.JkClasspath;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsSystem;
import dev.jeka.core.api.utils.JkUtilsZip;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JkUrlClassLoader {
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    public static final PathMatcher CLASS_FILE_FILTER = file -> Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(CLASS_SUFFIX);
    private final URLClassLoader delegate;

    private JkUrlClassLoader(URLClassLoader delegate) {
        this.delegate = delegate;
    }

    public static JkUrlClassLoader of(URLClassLoader urlClassLoader) {
        return new JkUrlClassLoader(urlClassLoader);
    }

    public static JkUrlClassLoader of(Iterable<Path> paths) {
        return JkUrlClassLoader.of(new URLClassLoader(JkUrlClassLoader.toUrl(paths)));
    }

    public static JkUrlClassLoader of(Iterable<Path> paths, ClassLoader parent) {
        List<Path> cleanedPath = JkUtilsPath.disambiguate(paths);
        return JkUrlClassLoader.of(new URLClassLoader(JkUrlClassLoader.toUrl(cleanedPath), parent));
    }

    public static JkUrlClassLoader ofCurrent() {
        return JkUrlClassLoader.wrapUrlClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static JkUrlClassLoader ofSystem() {
        return JkUrlClassLoader.wrapUrlClassLoader(ClassLoader.getSystemClassLoader());
    }

    private static JkUrlClassLoader wrapUrlClassLoader(ClassLoader classLoader) {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("The current or system classloader is not instance of URLClassLoader but " + classLoader.getClass() + ". It is probably due that you are currently running on JDK9.");
        }
        return JkUrlClassLoader.of((URLClassLoader)classLoader);
    }

    public static JkUrlClassLoader ofLoaderOf(Class<?> clazz) {
        return new JkUrlClassLoader((URLClassLoader)clazz.getClassLoader());
    }

    public URLClassLoader get() {
        return this.delegate;
    }

    public JkClassLoader getParent() {
        return JkClassLoader.of(this.delegate.getParent());
    }

    public JkUrlClassLoader createChild(Iterable<Path> extraEntries) {
        List<Path> paths = JkUtilsPath.disambiguate(extraEntries);
        return new JkUrlClassLoader(new URLClassLoader(JkUrlClassLoader.toUrl(paths), (ClassLoader)this.delegate));
    }

    public JkClasspath getDirectClasspath() {
        return JkClasspath.of(JkUtilsSystem.classloaderEntries(this.delegate));
    }

    public JkClasspath getFullClasspath() {
        JkClasspath classpath = this.delegate.getParent() != null && this.getParent().get() instanceof URLClassLoader ? JkUrlClassLoader.of((URLClassLoader)this.getParent().get()).getFullClasspath() : JkClasspath.of();
        return classpath.and(this.getDirectClasspath());
    }

    public JkClassLoader toJkClassLoader() {
        return JkClassLoader.of(this.delegate);
    }

    private Set<Class<?>> loadClasses(Iterable<String> patterns) {
        HashSet result = new HashSet();
        JkClassLoader jkClassLoader = JkClassLoader.of(this.delegate);
        Set<Path> classFiles = this.getFullClasspath().getAllPathMatching(patterns);
        for (Path classFile : classFiles) {
            String className = JkUrlClassLoader.getAsClassName(classFile.toString());
            result.add(jkClassLoader.load(className));
        }
        return result;
    }

    public Set<Class<?>> loadClasses(String ... globPatterns) {
        LinkedList<String> patterns = new LinkedList<String>();
        for (String pattern : globPatterns) {
            patterns.add(pattern + CLASS_SUFFIX);
        }
        return this.loadClasses(patterns);
    }

    public Set<Class<?>> loadClassesIn(JkPathTreeSet jkPathTreeSet) {
        HashSet result = new HashSet();
        JkClassLoader jkClassLoader = this.toJkClassLoader();
        for (Path path : jkPathTreeSet.getRelativeFiles()) {
            if (!path.toString().endsWith(CLASS_SUFFIX)) continue;
            String className = JkUrlClassLoader.getAsClassName(path.toString());
            result.add(jkClassLoader.load(className));
        }
        return result;
    }

    private Iterator<Class<?>> iterateClassesIn(Path dirOrJar) {
        List<Object> paths;
        if (Files.isDirectory(dirOrJar, new LinkOption[0])) {
            paths = ((JkPathTree)JkPathTree.of(dirOrJar).andMatching(true, "**.class")).getRelativeFiles();
        } else {
            List<ZipEntry> entries = JkUtilsZip.getZipEntries(JkUtilsZip.getZipFile(dirOrJar.toFile()));
            paths = new LinkedList();
            for (ZipEntry entry : entries) {
                if (!entry.getName().endsWith(CLASS_SUFFIX)) continue;
                paths.add(Paths.get(entry.getName(), new String[0]));
            }
        }
        return this.classIterator(paths.stream().map(path -> path.toString()).collect(Collectors.toList()));
    }

    private Iterator<Class<?>> classIterator(Iterable<String> fileNameIt) {
        final Iterator<String> it = fileNameIt.iterator();
        final JkClassLoader jkClassLoader = JkClassLoader.of(this.delegate);
        return new Iterator<Class<?>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Class<?> next() {
                String className = JkUrlClassLoader.getAsClassName((String)it.next());
                return jkClassLoader.load(className);
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Not supported");
            }
        };
    }

    private static URL[] toUrl(Iterable<Path> paths) {
        List<Path> pathList = JkUtilsPath.disambiguate(paths);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path file : pathList) {
            try {
                urls.add(file.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(file + " is not convertible to URL");
            }
        }
        return urls.toArray(new URL[0]);
    }

    private static String getAsClassName(String resourceName) {
        return resourceName.replace(File.separatorChar, '.').replace("/", ".").substring(0, resourceName.length() - CLASS_SUFFIX_LENGTH);
    }

    public String toString() {
        return this.toJkClassLoader().toString();
    }

    public void addEntries(Iterable<Path> paths) {
        try {
            Method method = JkUtilsReflect.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            for (Path path : JkUtilsPath.disambiguate(paths)) {
                JkUtilsReflect.invoke(this.delegate, method, JkUtilsPath.toUrl(path));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error while adding urls on classloader " + this, e);
        }
    }

    public void loadAllServices() {
        HashSet serviceClasses = new HashSet();
        for (Path path : this.getFullClasspath()) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                JkLog.trace("Scanning " + path + " for META-INF/services.", new Object[0]);
                ZipFile zipFile = JkUtilsZip.getZipFile(path.toFile());
                ZipEntry serviceEntry = zipFile.getEntry("META-INF/services");
                if (serviceEntry == null) {
                    JkUtilsIO.closeOrFail(zipFile);
                    continue;
                }
                for (ZipEntry entry : JkUtilsZip.getZipEntries(zipFile)) {
                    if (!entry.getName().startsWith("META-INF/services/")) continue;
                    String serviceName = JkUtilsString.substringAfterLast(entry.getName(), "/");
                    Class serviceClass = this.toJkClassLoader().loadIfExist(serviceName);
                    if (serviceClass == null) continue;
                    JkLog.trace("Found service providers for : " + serviceName, new Object[0]);
                    serviceClasses.add(serviceClass);
                }
                JkUtilsIO.closeOrFail(zipFile);
                continue;
            }
            Path serviceDir = path.resolve("META-INF/services");
            if (!Files.exists(serviceDir, new LinkOption[0]) || !Files.isDirectory(serviceDir, new LinkOption[0])) continue;
            JkUtilsPath.walk(serviceDir, 1, new FileVisitOption[0]).forEach(candidate -> {
                Class serviceClass = this.toJkClassLoader().loadIfExist(candidate.getFileName().toString());
                if (serviceClass != null) {
                    serviceClasses.add(serviceClass);
                }
            });
        }
        for (Class clazz : serviceClasses) {
            JkLog.trace("Reload service providers for : " + clazz.getName(), new Object[0]);
            ServiceLoader.loadInstalled(clazz).reload();
        }
    }
}

