/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathSequence;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.java.JkJavaCompiler;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsJdk;
import dev.jeka.core.api.utils.JkUtilsObject;
import dev.jeka.core.api.utils.JkUtilsSystem;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.tools.DocumentationTool;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class JkJavadocProcessor<T> {
    private final List<String> options = new LinkedList<String>();
    private Boolean displayOutput;
    public final T __;

    private JkJavadocProcessor(T parent) {
        this.__ = parent;
    }

    public static JkJavadocProcessor<Void> of() {
        return JkJavadocProcessor.ofParent(null);
    }

    public static <T> JkJavadocProcessor<T> ofParent(T parent) {
        return new JkJavadocProcessor<T>(parent);
    }

    public List<String> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public JkJavadocProcessor<T> addOptions(String ... options) {
        return this.addOptions(Arrays.asList(options));
    }

    public JkJavadocProcessor<T> addOptions(Iterable<String> options) {
        JkUtilsIterable.addAllWithoutDuplicate(this.options, options);
        return this;
    }

    public Boolean getDisplayOutput() {
        return this.displayOutput;
    }

    public JkJavadocProcessor<T> setDisplayOutput(Boolean displayOutput) {
        this.displayOutput = displayOutput;
        return this;
    }

    public void make(Iterable<Path> classpath, JkPathTreeSet srcDirs, Path outputDir) {
        JkLog.startTask("Generate javadoc", new Object[0]);
        if (srcDirs.hasNoExistingRoot()) {
            JkLog.warn("No sources found in " + srcDirs, new Object[0]);
            return;
        }
        if (srcDirs.count(1, false) > 0) {
            this.executeCommandLine(classpath, srcDirs, outputDir);
        } else {
            JkLog.warn("No source file detected. Skip Javadoc.", new Object[0]);
        }
        JkLog.endTask();
    }

    private void executeTool(Iterable<Path> classpath, JkPathTreeSet srcDirs, Path outputDir) {
        DocumentationTool tool = ToolProvider.getSystemDocumentationTool();
        try (StandardJavaFileManager fm = tool.getStandardFileManager(null, null, null);){
            Files.createDirectories(outputDir, new FileAttribute[0]);
            fm.setLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT, JkUtilsIterable.listOf(outputDir.toFile()));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)JkLog.getOutPrintStream(), StandardCharsets.UTF_8));
            List<String> options = this.computeOptions(classpath, srcDirs, outputDir);
            DocumentationTool.DocumentationTask task = tool.getTask(writer, fm, null, null, options, null);
            task.call();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void executeCommandLine(Iterable<Path> classpath, JkPathTreeSet srcDirs, Path outputDir) {
        String exeName = JkUtilsSystem.IS_WINDOWS ? "javadoc.exe" : "javadoc";
        Path javadocExe = JkUtilsJdk.javaHome().resolve("bin/" + exeName);
        if (!Files.exists(javadocExe, new LinkOption[0])) {
            javadocExe = JkUtilsJdk.javaHome().resolve("../bin/" + exeName).normalize();
        }
        boolean verbose = JkUtilsObject.firstNonNull(this.displayOutput, JkLog.isVerbose());
        JkLog.trace(javadocExe.toString(), new Object[0]);
        LinkedHashSet<String> packages = this.computePackages(srcDirs);
        if (packages.isEmpty()) {
            JkLog.warn("No package detected. Skip Javadoc.", new Object[0]);
            return;
        }
        Object process = ((JkProcess)((JkProcess)((JkProcess)JkProcess.of(javadocExe.toString(), new String[0]).addParams(this.computeOptions(classpath, srcDirs, outputDir)).addParams(this.computePackages(srcDirs))).setLogOutput(verbose)).setLogCommand(verbose)).setFailOnError(false);
        int code = ((JkProcess)process).exec(new String[0]);
        if (code != 0) {
            JkLog.warn("An error occurred when generating Javadoc (staus error = " + code + "). Maybe there is no public class to document. Relaunch the process with -lv option to see details", new Object[0]);
        }
    }

    private LinkedHashSet<String> computePackages(JkPathTreeSet srcDirs) {
        srcDirs = srcDirs.withMatcher(JkJavaCompiler.JAVA_SOURCE_MATCHER);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Path relFile : srcDirs.getRelativeFiles()) {
            Path packageDir = relFile.getParent();
            if (packageDir == null) continue;
            String packageName = packageDir.toString().replace(File.separator, ".");
            result.add(packageName);
        }
        return result;
    }

    private List<String> computeOptions(Iterable<Path> classpath, JkPathTreeSet srcDirs, Path outputDir) {
        LinkedList<String> options = new LinkedList<String>();
        if (!this.containsLike("-Xdoclint")) {
            options.add("-Xdoclint:none");
        }
        if (!this.contains("-sourcepath")) {
            options.add("-sourcepath");
            options.add(JkPathSequence.of(srcDirs.getRootDirsOrZipFiles()).toPath());
        }
        if (!this.contains("-d")) {
            options.add("-d");
            options.add(outputDir.toString());
        }
        if (!this.contains("-classpath") && classpath != null && classpath.iterator().hasNext()) {
            options.add("-classpath");
            options.add(JkPathSequence.of(classpath).toPath());
        }
        if (JkLog.isVerbose()) {
            options.add("-verbose");
        } else {
            options.add("-quiet");
        }
        options.addAll(this.options);
        JkLog.trace(((Object)options).toString(), new Object[0]);
        return options;
    }

    private boolean containsLike(String hint) {
        for (String option : this.options) {
            if (!option.contains(hint)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String hint) {
        for (String option : this.options) {
            if (!option.equals(hint)) continue;
            return true;
        }
        return false;
    }
}

