/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.java;

import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkZipTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsIO;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.api.utils.JkUtilsZip;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;

public final class JkClasspath
implements Iterable<Path> {
    private static final long serialVersionUID = 1L;
    private static final String WILD_CARD = "*";
    private final List<Path> entries;

    private JkClasspath(Iterable<Path> entries) {
        this.entries = Collections.unmodifiableList(JkClasspath.resolveWildCard(entries));
    }

    public static JkClasspath of(Iterable<Path> paths) {
        return new JkClasspath(JkUtilsPath.disambiguate(paths));
    }

    public static JkClasspath of() {
        return JkClasspath.of(Collections.emptyList());
    }

    public static JkClasspath of(Path path1, Path path2, Path ... others) {
        return JkClasspath.of(JkUtilsIterable.listOf2orMore(path1, path2, others));
    }

    public static JkClasspath ofCurrentRuntime() {
        String[] classpathEntries;
        LinkedList<Path> files = new LinkedList<Path>();
        String classpath = System.getProperty("java.class.path");
        for (String classpathEntry : classpathEntries = classpath.split(File.pathSeparator)) {
            files.addAll(JkClasspath.resolveWildCard(classpathEntry));
        }
        return JkClasspath.of(files);
    }

    public List<Path> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<Path> iterator() {
        return this.entries.iterator();
    }

    public Path getEntryContainingClass(String className) {
        String path = JkClasspath.toFilePath(className);
        for (Path file : this.entries) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                if (!Files.exists(file.resolve(path), new LinkOption[0])) continue;
                return file;
            }
            ZipFile zipFile = JkUtilsZip.getZipFile(file.toFile());
            if (zipFile.getEntry(path) != null) {
                JkUtilsIO.closeQuietly(zipFile);
                return file;
            }
            JkUtilsIO.closeQuietly(zipFile);
        }
        return null;
    }

    Set<Path> getAllPathMatching(Iterable<String> globPatterns) {
        LinkedHashSet<Path> result = new LinkedHashSet<Path>();
        for (Path classpathEntry : this.entries) {
            JkPathTree tree = Files.isDirectory(classpathEntry, new LinkOption[0]) ? JkPathTree.of(classpathEntry) : JkZipTree.of(classpathEntry);
            result.addAll(((JkPathTree)tree.andMatching(true, globPatterns)).getRelativeFiles());
        }
        return result;
    }

    public JkClasspath andPrepending(Iterable<Path> paths) {
        List<Path> result = JkUtilsPath.disambiguate(paths);
        result.addAll(0, this.entries);
        return new JkClasspath(result);
    }

    public JkClasspath and(Iterable<Path> paths) {
        List<Path> result = JkUtilsPath.disambiguate(paths);
        LinkedList<Path> list = new LinkedList<Path>(this.entries);
        list.addAll(result);
        return new JkClasspath(list);
    }

    public JkClasspath and(Path path1, Path path2, Path ... others) {
        return this.and(JkUtilsIterable.listOf2orMore(path1, path2, others));
    }

    public JkClasspath andPrepending(Path path1, Path path2, Path ... others) {
        return this.and(JkUtilsIterable.listOf2orMore(path1, path2, others));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path> it = this.entries.iterator();
        while (it.hasNext()) {
            builder.append(it.next().toAbsolutePath().toString());
            if (!it.hasNext()) continue;
            builder.append(File.pathSeparator);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkClasspath classpath = (JkClasspath)o;
        return this.entries.equals(classpath.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    private static List<Path> resolveWildCard(Iterable<Path> files) {
        LinkedHashSet<Path> result = new LinkedHashSet<Path>();
        for (Path file : files) {
            if (file.getFileName().toString().equals(WILD_CARD)) {
                Path parent = file.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    JkLog.trace("File " + parent + " does not exist : classpath entry " + file + " will be ignored.", new Object[0]);
                    continue;
                }
                result.addAll(((JkPathTree)JkPathTree.of(parent).andMatching(true, "*.jar")).getFiles());
                continue;
            }
            if (!Files.exists(file, new LinkOption[0])) {
                JkLog.trace("File " + file + " does not exist : classpath entry " + file + " will be ignored.", new Object[0]);
                continue;
            }
            if (Files.isRegularFile(file, new LinkOption[0])) {
                if (!JkUtilsString.endsWithAny(file.getFileName().toString().toLowerCase(), ".jar", ".zip")) {
                    throw new IllegalArgumentException("Classpath file element " + file.toAbsolutePath().toString() + " is invalid. It must be either a folder either a jar or zip file.");
                }
                result.add(file);
                continue;
            }
            result.add(file);
        }
        return new ArrayList<Path>(result);
    }

    private static List<Path> resolveWildCard(String candidatePath) {
        LinkedList<Path> result = new LinkedList<Path>();
        if (candidatePath.endsWith(WILD_CARD)) {
            String candidateFolder = JkUtilsString.substringBeforeFirst(candidatePath, WILD_CARD);
            Path parent = Paths.get(candidateFolder, new String[0]);
            if (!Files.exists(parent, new LinkOption[0])) {
                JkLog.trace("File " + parent + " does not exist : classpath entry " + candidatePath + " will be ignored.", new Object[0]);
            } else {
                result.addAll(((JkPathTree)JkPathTree.of(parent).andMatching(true, "**.jar")).getFiles());
            }
        } else {
            result.add(Paths.get(candidatePath, new String[0]));
        }
        return result;
    }

    private static String toFilePath(String className) {
        return className.replace('.', '/').concat(".class");
    }
}

