/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.j2e;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class JkJ2eWarArchiver {
    private Path classDir;
    private Path webappDir;
    private List<Path> libs;
    private Path extraStaticResourceDir;

    private JkJ2eWarArchiver() {
    }

    public static JkJ2eWarArchiver of() {
        return new JkJ2eWarArchiver();
    }

    public JkJ2eWarArchiver setClassDir(Path classDir) {
        this.classDir = classDir;
        return this;
    }

    public JkJ2eWarArchiver setWebappDir(Path webappDir) {
        this.webappDir = webappDir;
        return this;
    }

    public JkJ2eWarArchiver setLibs(List<Path> libs) {
        this.libs = libs;
        return this;
    }

    public JkJ2eWarArchiver setExtraStaticResourceDir(Path extraStaticResourceDir) {
        this.extraStaticResourceDir = extraStaticResourceDir;
        return this;
    }

    public void generateWarDir(Path destDir) {
        JkPathTree webappTree;
        JkPathTree jkPathTree = webappTree = this.webappDir != null ? JkPathTree.of(this.webappDir) : null;
        if (webappTree == null || !webappTree.exists() || !webappTree.containFiles()) {
            JkLog.warn(destDir + " is empty or does not exists.", new Object[0]);
        } else {
            webappTree.copyTo(destDir, new CopyOption[0]);
        }
        if (this.extraStaticResourceDir != null && Files.exists(this.extraStaticResourceDir, new LinkOption[0])) {
            JkPathTree.of(this.extraStaticResourceDir).copyTo(destDir, new CopyOption[0]);
        }
        JkPathTree.of(this.classDir).copyTo(destDir.resolve("WEB-INF/classes"), new CopyOption[0]);
        Path libDir = destDir.resolve("lib");
        JkPathTree.of(libDir).deleteContent();
        this.libs.forEach(path -> JkPathFile.of(path).copyToDir(libDir, new CopyOption[0]));
    }

    public void generateWarFile(Path destFile) {
        Path temp = JkUtilsPath.createTempDirectory("jeka-war", new FileAttribute[0]);
        this.generateWarDir(temp);
        JkPathTree.of(temp).zipTo(destFile);
        JkPathTree.of(temp).deleteRoot();
    }
}

