/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

public class JkZipTree
extends JkPathTree<JkZipTree>
implements Closeable {
    private JkZipTree(JkUtilsPath.JkZipRoot zipRoot, JkPathMatcher pathMatcher) {
        super(zipRoot, pathMatcher);
    }

    public static JkZipTree of(Path zipFile) {
        return new JkZipTree(JkUtilsPath.zipRoot(zipFile), JkPathMatcher.ACCEPT_ALL);
    }

    @Override
    protected JkZipTree newInstance(Supplier<Path> supplier, JkPathMatcher pathMatcher) {
        return new JkZipTree((JkUtilsPath.JkZipRoot)supplier, pathMatcher);
    }

    @Override
    protected JkZipTree withRoot(Path newRoot) {
        return this.newInstance((Supplier)this.zipRoot().withRootInsideZip(newRoot), this.getMatcher());
    }

    @Override
    public JkZipTree createIfNotExist() {
        JkUtilsPath.JkZipRoot zipRoot = this.zipRoot();
        if (!Files.exists(zipRoot.getZipFile(), new LinkOption[0])) {
            JkUtilsPath.createDirectories(zipRoot.get().getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(zipRoot.get(), new LinkOption[0])) {
            JkUtilsPath.createDirectories(zipRoot.get(), new FileAttribute[0]);
        }
        return this;
    }

    @Override
    public void close() {
        this.zipRoot().close();
    }

    private JkUtilsPath.JkZipRoot zipRoot() {
        return (JkUtilsPath.JkZipRoot)this.rootSupplier;
    }
}

