/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class JkResourceProcessor<T> {
    private final List<JkInterpolator> interpolators = new LinkedList<JkInterpolator>();
    private Charset interpolationCharset = Charset.forName("UTF-8");
    public final T __;

    private JkResourceProcessor(T parent) {
        this.__ = parent;
    }

    public JkResourceProcessor<T> apply(Consumer<JkResourceProcessor> consumer) {
        consumer.accept(this);
        return this;
    }

    public static JkResourceProcessor<Void> of() {
        return JkResourceProcessor.ofParent(null);
    }

    public static <T> JkResourceProcessor<T> ofParent(T parent) {
        return new JkResourceProcessor<T>(parent);
    }

    public JkResourceProcessor<T> addInterpolators(Iterable<JkInterpolator> interpolators) {
        JkUtilsIterable.addAllWithoutDuplicate(this.interpolators, interpolators);
        return this;
    }

    public JkResourceProcessor<T> addInterpolators(JkInterpolator ... interpolators) {
        return this.addInterpolators(Arrays.asList(interpolators));
    }

    public JkResourceProcessor<T> addInterpolator(PathMatcher pathMatcher, Map<String, String> keyValues) {
        return this.addInterpolators(JkInterpolator.of(pathMatcher, keyValues));
    }

    public JkResourceProcessor<T> addInterpolator(String acceptPattern, Map<String, String> keyValues) {
        return this.addInterpolator(JkPathMatcher.of(true, acceptPattern), keyValues);
    }

    public JkResourceProcessor<T> addInterpolator(String acceptPattern, String ... keyValues) {
        return this.addInterpolator(acceptPattern, JkUtilsIterable.mapOfAny(keyValues));
    }

    public Charset getInterpolationCharset() {
        return this.interpolationCharset;
    }

    public JkResourceProcessor<T> setInterpolationCharset(Charset interpolationCharset) {
        JkUtilsAssert.argument(interpolationCharset != null, "interpolation charset cannot be null.", new Object[0]);
        this.interpolationCharset = interpolationCharset;
        return this;
    }

    public void generate(JkPathTreeSet resourceTrees, Path outputDir) {
        Path relativeOutputDir = outputDir.isAbsolute() ? Paths.get("", new String[0]).toAbsolutePath().relativize(outputDir) : outputDir;
        JkLog.startTask("Copy resource files to %s", relativeOutputDir);
        for (JkPathTree resourceTree : resourceTrees.toList()) {
            AtomicInteger count = new AtomicInteger(0);
            if (!resourceTree.exists()) continue;
            resourceTree.stream(new FileVisitOption[0]).forEach(object -> {
                Path path = (Path)object;
                Path relativePath = resourceTree.getRoot().relativize(path);
                Path out = outputDir.resolve(relativePath);
                Map data = JkInterpolator.of(relativePath.toString(), this.interpolators);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    JkUtilsPath.createDirectories(out, new FileAttribute[0]);
                } else {
                    JkPathFile.of(path).copyReplacingTokens(out, data, this.interpolationCharset);
                    count.incrementAndGet();
                }
            });
            JkLog.info("%s processed from %s.", JkUtilsString.pluralize(count.get(), "file"), JkUtilsPath.relativizeFromWorkingDir(resourceTree.getRoot()));
        }
        JkLog.endTask();
    }

    private static class JkInterpolator {
        private final Map<String, String> keyValues;
        private final PathMatcher matcher;

        private JkInterpolator(PathMatcher matcher, Map<String, String> keyValues) {
            this.keyValues = keyValues;
            this.matcher = matcher;
        }

        public static JkInterpolator of(PathMatcher pathMatcher, Map<String, String> keyValues) {
            return new JkInterpolator(pathMatcher, keyValues);
        }

        public static JkInterpolator of(Map<String, String> keyValues) {
            return JkInterpolator.of(JkPathMatcher.of(), keyValues);
        }

        public static JkInterpolator of() {
            return JkInterpolator.of(JkPathMatcher.of(), Collections.emptyMap());
        }

        public JkInterpolator and(String key, String value, String ... others) {
            Map<String, String> map = JkUtilsIterable.mapOf(key, value, others);
            map.putAll(this.keyValues);
            return new JkInterpolator(this.matcher, map);
        }

        private static Map<String, String> of(String path, Iterable<JkInterpolator> interpolators) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (JkInterpolator interpolator : interpolators) {
                if (!interpolator.matcher.matches(Paths.get(path, new String[0]))) continue;
                result.putAll(interpolator.keyValues);
            }
            return result;
        }
    }
}

