/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.file.JkZipTree;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class JkPathTreeSet
implements Closeable {
    private final List<JkPathTree> pathTrees;

    private JkPathTreeSet(List<JkPathTree> dirs) {
        if (dirs == null) {
            throw new IllegalArgumentException("dirs can't be null.");
        }
        this.pathTrees = Collections.unmodifiableList(dirs);
    }

    public static JkPathTreeSet of(Iterable<JkPathTree> dirs) {
        return new JkPathTreeSet(JkUtilsIterable.listOf(dirs));
    }

    public static JkPathTreeSet ofEmpty() {
        return new JkPathTreeSet(Collections.emptyList());
    }

    public static JkPathTreeSet of(JkPathTree ... trees) {
        return new JkPathTreeSet(Arrays.asList(trees));
    }

    public static JkPathTreeSet ofRoots(Path ... folders) {
        ArrayList<JkPathTree> dirs = new ArrayList<JkPathTree>(folders.length);
        for (Path folder : folders) {
            dirs.add(JkPathTree.of(folder));
        }
        return new JkPathTreeSet(dirs);
    }

    public static JkPathTreeSet ofRoots(List<Path> paths) {
        return JkPathTreeSet.ofRoots(paths.toArray(new Path[0]));
    }

    public final JkPathTreeSet and(JkPathTree ... trees) {
        LinkedList<JkPathTree> list = new LinkedList<JkPathTree>(this.pathTrees);
        list.addAll(Arrays.asList(trees));
        return new JkPathTreeSet(list);
    }

    public final JkPathTreeSet andZips(Iterable<Path> zipFiles) {
        List<Path> paths = JkUtilsPath.disambiguate(zipFiles);
        LinkedList<JkPathTree> list = new LinkedList<JkPathTree>(this.pathTrees);
        paths.forEach(zipFile -> list.add(JkZipTree.of(zipFile)));
        return new JkPathTreeSet(list);
    }

    public final JkPathTreeSet andZip(Path ... zips) {
        return this.andZips(Arrays.asList(zips));
    }

    public final JkPathTreeSet and(Path ... folders) {
        ArrayList<JkPathTree> dirs = new ArrayList<JkPathTree>(folders.length);
        for (Path folder : folders) {
            dirs.add(JkPathTree.of(folder));
        }
        return this.and(dirs.toArray(new JkPathTree[folders.length]));
    }

    public final JkPathTreeSet and(JkPathTreeSet ... otherDirSets) {
        LinkedList<JkPathTree> list = new LinkedList<JkPathTree>(this.pathTrees);
        for (JkPathTreeSet otherDirSet : otherDirSets) {
            list.addAll(otherDirSet.pathTrees);
        }
        return new JkPathTreeSet(list);
    }

    public JkPathTreeSet andMatcher(PathMatcher matcher) {
        LinkedList<JkPathTree> list = new LinkedList<JkPathTree>();
        for (JkPathTree tree : this.pathTrees) {
            list.add((JkPathTree)tree.andMatcher(matcher));
        }
        return new JkPathTreeSet(list);
    }

    public JkPathTreeSet withMatcher(PathMatcher matcher) {
        LinkedList<JkPathTree> list = new LinkedList<JkPathTree>();
        for (JkPathTree tree : this.pathTrees) {
            list.add((JkPathTree)JkPathTree.of(tree.getRoot()).withMatcher(JkPathMatcher.of(matcher)));
        }
        return new JkPathTreeSet(list);
    }

    public List<Path> getFiles() {
        LinkedList<Path> result = new LinkedList<Path>();
        for (JkPathTree dirView : this.pathTrees) {
            if (!dirView.exists()) continue;
            result.addAll(dirView.getFiles());
        }
        return result;
    }

    public List<Path> getRelativeFiles() {
        LinkedList<Path> result = new LinkedList<Path>();
        for (JkPathTree dir : this.pathTrees) {
            if (!dir.exists()) continue;
            result.addAll(dir.getRelativeFiles());
        }
        return result;
    }

    public List<Path> getExistingFiles(String relativePath) {
        LinkedList<Path> result = new LinkedList<Path>();
        for (JkPathTree pathTree : this.pathTrees) {
            Path candidate = pathTree.get(relativePath);
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            result.add(candidate);
        }
        return result;
    }

    public JkPathTreeSet zipTo(Path dir) {
        this.pathTrees.forEach(tree -> tree.zipTo(dir));
        return this;
    }

    public JkPathTreeSet copyTo(Path dir, CopyOption ... copyOptions) {
        this.pathTrees.forEach(tree -> tree.copyTo(dir, copyOptions));
        return this;
    }

    public List<JkPathTree> toList() {
        return this.pathTrees;
    }

    public List<Path> getRootDirsOrZipFiles() {
        LinkedList<Path> result = new LinkedList<Path>();
        for (JkPathTree tree : this.pathTrees) {
            result.add(tree.getRoot());
        }
        return result;
    }

    public boolean hasNoExistingRoot() {
        for (JkPathTree tree : this.pathTrees) {
            if (!tree.exists()) continue;
            return false;
        }
        return true;
    }

    public JkPathTreeSet resolvedTo(Path newRoot) {
        LinkedList<JkPathTree> trees = new LinkedList<JkPathTree>();
        this.toList().forEach(tree -> trees.add((JkPathTree)tree.resolvedTo(newRoot)));
        return JkPathTreeSet.of(trees);
    }

    public int count(int max, boolean includeFolder) {
        int result = 0;
        for (JkPathTree dirView : this.pathTrees) {
            result += dirView.count(max - result, includeFolder);
        }
        return result;
    }

    public boolean containFiles() {
        return this.count(1, false) > 0;
    }

    public JkPathTreeSet mergeDuplicateRoots() {
        ArrayList<JkPathTree> result = new ArrayList<JkPathTree>();
        for (JkPathTree tree : this.pathTrees) {
            Path root = tree.getRoot();
            boolean found = false;
            for (int i = 0; i < result.size(); ++i) {
                JkPathTree resultTree = (JkPathTree)result.get(i);
                if (!root.equals(resultTree.getRoot())) continue;
                result.remove(i);
                found = true;
                JkPathMatcher pathMatcher = resultTree.getMatcher().or(tree.getMatcher());
                resultTree = resultTree.withMatcher(pathMatcher);
                result.add(i, resultTree);
                break;
            }
            if (found) continue;
            result.add(tree);
        }
        return JkPathTreeSet.of(result);
    }

    public String toString() {
        return this.pathTrees.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pathTrees == null ? 0 : this.pathTrees.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JkPathTreeSet other = (JkPathTreeSet)obj;
        if (this.pathTrees == null) {
            return other.pathTrees == null;
        }
        return this.pathTrees.equals(other.pathTrees);
    }

    @Override
    public void close() {
        this.pathTrees.stream().filter(JkZipTree.class::isInstance).map(JkZipTree.class::cast).forEach(JkZipTree::close);
    }
}

