/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.file.JkPathMatcher;
import dev.jeka.core.api.file.JkPathTreeSet;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JkPathTree<T extends JkPathTree> {
    protected final Supplier<Path> rootSupplier;
    private final JkPathMatcher matcher;

    protected JkPathTree(Supplier<Path> rootSupplier, JkPathMatcher matcher) {
        this.rootSupplier = rootSupplier;
        this.matcher = matcher;
    }

    public static JkPathTree of(Path rootDir) {
        return new JkPathTree(() -> rootDir, JkPathMatcher.ACCEPT_ALL);
    }

    public static JkPathTree of(String rootDir) {
        return JkPathTree.of(Paths.get(rootDir, new String[0]));
    }

    protected T newInstance(Supplier<Path> pathSupplier, JkPathMatcher pathMatcher) {
        return (T)new JkPathTree<T>(pathSupplier, pathMatcher);
    }

    protected T withRoot(Path newRoot) {
        return this.newInstance(() -> newRoot, this.matcher);
    }

    public Path getRoot() {
        return this.rootSupplier.get();
    }

    public JkPathMatcher getMatcher() {
        return this.matcher;
    }

    public boolean hasFilter() {
        return this.matcher != JkPathMatcher.ACCEPT_ALL;
    }

    private Predicate<Path> excludeRootFilter() {
        return path -> !path.equals(this.getRoot());
    }

    private Function<Path, Path> relativePathFunction() {
        return path -> this.getRoot().relativize((Path)path);
    }

    public boolean exists() {
        return Files.exists(this.getRoot(), new LinkOption[0]);
    }

    public T createIfNotExist() {
        if (!Files.exists(this.getRoot(), new LinkOption[0])) {
            JkUtilsPath.createDirectories(this.getRoot(), new FileAttribute[0]);
        }
        return (T)this;
    }

    public Stream stream(FileVisitOption ... options) {
        if (!this.exists()) {
            return new LinkedList().stream();
        }
        JkPathMatcher matcher = JkPathMatcher.of(this.matcher);
        Path root = this.getRoot().toString().equals("") ? Paths.get(".", new String[0]) : this.getRoot();
        return JkUtilsPath.walk(root, options).filter(path -> matcher.matches(root.relativize((Path)path)));
    }

    public List<Path> getRelativeFiles() {
        try (Stream stream = this.stream(new FileVisitOption[0]);){
            List<Path> list = stream.filter(JkPathMatcher.ofNoDirectory(new LinkOption[0]).toPredicate()).map(this.relativePathFunction()).collect(Collectors.toList());
            return list;
        }
    }

    public List<Path> getFiles() {
        try (Stream stream = this.stream(new FileVisitOption[0]);){
            List<Path> list = stream.filter(JkPathMatcher.ofNoDirectory(new LinkOption[0]).toPredicate()).collect(Collectors.toList());
            return list;
        }
    }

    public T goTo(String relativePath) {
        Path path = this.getRoot().resolve(relativePath).normalize();
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(this.getRoot() + "/" + relativePath + " is not a directory");
        }
        return this.withRoot(path);
    }

    public T resolvedTo(Path newRoot) {
        Path path = newRoot.resolve(this.getRoot()).normalize();
        return this.withRoot(path);
    }

    public Path get(String relativePath) {
        return this.getRoot().resolve(relativePath);
    }

    public T importDir(Path dirToCopy, CopyOption ... copyOptions) {
        return this.importTree(JkPathTree.of(dirToCopy), copyOptions);
    }

    public T importTree(JkPathTree tree, CopyOption ... copyOptions) {
        this.createIfNotExist();
        if (tree.exists()) {
            tree.stream(new FileVisitOption[0]).filter(this.excludeRootFilter()).forEach(object -> {
                Path path = (Path)object;
                Path target = this.getRoot().resolve(tree.getRoot().relativize(path).toString());
                if (Files.isDirectory(path, new LinkOption[0])) {
                    JkUtilsPath.createDirectories(target, new FileAttribute[0]);
                } else {
                    JkUtilsPath.copy(path, target, copyOptions);
                }
            });
        }
        return (T)this;
    }

    public T importFiles(Iterable<Path> files, StandardCopyOption ... copyOptions) {
        this.createIfNotExist();
        List<Path> paths = JkUtilsPath.disambiguate(files);
        for (Path file : paths) {
            JkUtilsPath.copy(file, this.getRoot().resolve(file.getFileName()), copyOptions);
        }
        return (T)this;
    }

    public T importFile(Path src, String targetName, StandardCopyOption ... copyOptions) {
        this.createIfNotExist();
        Path parentTarget = this.getRoot().resolve(targetName).getParent();
        if (parentTarget != null && !Files.exists(parentTarget, new LinkOption[0])) {
            JkUtilsPath.createDirectories(parentTarget, new FileAttribute[0]);
        }
        JkUtilsPath.copy(src, this.getRoot().resolve(targetName), copyOptions);
        return (T)this;
    }

    public T deleteContent() {
        if (!Files.exists(this.getRoot(), new LinkOption[0])) {
            return (T)this;
        }
        JkUtilsPath.walkFileTree(this.getRoot(), (FileVisitor<Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                return this.visitFile(file);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return this.visitDir(dir);
            }

            private FileVisitResult visitFile(Path path) {
                if (JkPathTree.this.matcher.matches(JkPathTree.this.getRoot().relativize(path))) {
                    JkUtilsPath.deleteFile(path);
                }
                return FileVisitResult.CONTINUE;
            }

            private FileVisitResult visitDir(Path path) {
                if (!JkUtilsPath.isSameFile(JkPathTree.this.getRoot(), path) && JkPathTree.this.matcher.matches(JkPathTree.this.getRoot().relativize(path)) && JkUtilsPath.listDirectChildren(path).isEmpty()) {
                    JkUtilsPath.deleteFile(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return (T)this;
    }

    public T deleteRoot() {
        ((JkPathTree)this.withMatcher(JkPathMatcher.ACCEPT_ALL)).deleteContent();
        JkUtilsPath.deleteFile(this.getRoot());
        return (T)this;
    }

    public T zipTo(Path destination) {
        if (destination.getParent() != null) {
            JkUtilsPath.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        try (Stream stream = this.stream(new FileVisitOption[0]);
             JkUtilsPath.JkZipRoot zipRoot = JkUtilsPath.zipRoot(destination);){
            stream.filter(this.excludeRootFilter()).forEach(path -> {
                Path zipEntry = zipRoot.get().resolve(this.getRoot().relativize((Path)path).toString());
                if (!Files.exists(zipEntry, new LinkOption[0]) || !Files.isDirectory(zipEntry, new LinkOption[0])) {
                    JkUtilsPath.createDirectories(zipEntry.getParent(), new FileAttribute[0]);
                    JkUtilsPath.copy(path, zipEntry, StandardCopyOption.REPLACE_EXISTING);
                }
            });
        }
        return (T)this;
    }

    public int copyTo(Path destinationDir, CopyOption ... copyOptions) {
        if (!Files.exists(destinationDir, new LinkOption[0])) {
            JkUtilsPath.createDirectories(destinationDir, new FileAttribute[0]);
        }
        return JkUtilsPath.copyDirContent(this.getRoot(), destinationDir, this.matcher, copyOptions);
    }

    public void copyFile(String sourcePath, Path destinationDir, CopyOption ... copyOptions) {
        if (!Files.exists(destinationDir, new LinkOption[0])) {
            JkUtilsPath.createDirectories(destinationDir, new FileAttribute[0]);
        }
        Path source = this.get(sourcePath);
        Path dest = destinationDir.getFileSystem().getPath(destinationDir.toString() + "/" + source.getFileName(), new String[0]);
        JkUtilsPath.copy(source, dest, copyOptions);
    }

    public T andMatcher(PathMatcher pathMatcher) {
        return this.withMatcher(this.matcher.and(pathMatcher));
    }

    public T withMatcher(JkPathMatcher pathMatcher) {
        return this.newInstance(this.rootSupplier, pathMatcher);
    }

    public T andMatching(boolean positive, String ... globPatterns) {
        return this.andMatching(positive, Arrays.asList(globPatterns));
    }

    public T andMatching(String ... globPatterns) {
        return this.andMatching(true, globPatterns);
    }

    public T andMatching(boolean positive, Iterable<String> globPatterns) {
        return this.andMatcher(JkPathMatcher.of(positive, this.getRoot().getFileSystem(), globPatterns));
    }

    public int count(int max, boolean includeDirectories) {
        if (!this.exists()) {
            return 0;
        }
        return JkUtilsPath.childrenCount(this.getRoot(), max, includeDirectories, this.matcher);
    }

    public boolean containFiles() {
        return this.count(1, false) > 0;
    }

    public JkPathTreeSet toSet() {
        return JkPathTreeSet.of(this);
    }

    public String toString() {
        return this.hasFilter() ? this.rootSupplier.get().toString() + ":" + this.matcher : this.rootSupplier.get().toString();
    }
}

