/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.file;

import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsReflect;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class JkPathSequence
implements Iterable<Path>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Path> entries;

    private JkPathSequence(Collection<Path> entries) {
        this.entries = Collections.unmodifiableList(JkUtilsIterable.listOf(entries));
    }

    public static JkPathSequence of(Iterable<Path> paths) {
        return new JkPathSequence(JkUtilsPath.disambiguate(paths));
    }

    public static JkPathSequence of() {
        return new JkPathSequence(Collections.emptyList());
    }

    public static JkPathSequence ofPathString(String pathString) {
        List<Path> paths = Arrays.stream(pathString.split(File.pathSeparator)).filter(item -> !JkUtilsString.isBlank(item)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        return JkPathSequence.of(paths);
    }

    public static JkPathSequence of(Path baseDir, String relativePathsAsString) {
        String[] paths = relativePathsAsString.split(File.pathSeparator);
        LinkedList<Path> result = new LinkedList<Path>();
        for (String path : paths) {
            Path file = Paths.get(path, new String[0]);
            if (!file.isAbsolute()) {
                file = baseDir.resolve(path);
            }
            result.add(file);
        }
        return JkPathSequence.of(result);
    }

    public static JkPathSequence of(Path path1, Path path2, Path ... others) {
        return JkPathSequence.of(JkUtilsIterable.listOf2orMore(path1, path2, others));
    }

    public JkPathSequence withoutDuplicates() {
        LinkedList<Path> files = new LinkedList<Path>();
        for (Path file : this.entries) {
            if (files.contains(file)) continue;
            files.add(file);
        }
        return new JkPathSequence(files);
    }

    public JkPathSequence normalized() {
        return JkPathSequence.of(this.entries.stream().map(path -> path.normalize()).collect(Collectors.toList()));
    }

    public List<Path> getEntries() {
        return this.entries;
    }

    public Path getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.entries.iterator();
    }

    public JkPathSequence andPrepend(Path path1, Path path2, Path ... entries) {
        return this.andPrepend(JkUtilsIterable.listOf2orMore(path1, path2, entries));
    }

    public JkPathSequence andPrepend(Iterable<Path> paths) {
        List<Path> result = JkUtilsPath.disambiguate(paths);
        result.addAll(this.entries);
        return new JkPathSequence(result);
    }

    public JkPathSequence and(Path path1, Path path2, Path ... others) {
        return this.and(JkUtilsIterable.listOf2orMore(path1, path2, others));
    }

    public JkPathSequence and(Iterable<Path> otherEntries) {
        List<Path> result = JkUtilsPath.disambiguate(otherEntries);
        result.addAll(0, this.entries);
        return new JkPathSequence(result);
    }

    public JkPathSequence resolvedTo(Path baseDir) {
        return JkPathSequence.of(this.entries.stream().map(path -> baseDir.resolve((Path)path)).collect(Collectors.toList()));
    }

    public JkPathSequence relativizeFromWorkingDir() {
        return JkPathSequence.of(this.entries.stream().map(JkUtilsPath::relativizeFromWorkingDir).collect(Collectors.toList()));
    }

    public String toPath() {
        return String.join((CharSequence)File.pathSeparator, this.entries.stream().map(Path::toString).collect(Collectors.toList()));
    }

    public Set<Path> toSet() {
        return new LinkedHashSet<Path>(this.entries);
    }

    public URL[] toUrls() {
        List<URL> urls = this.entries.stream().map(JkUtilsPath::toUrl).collect(Collectors.toList());
        return urls.toArray(new URL[0]);
    }

    public boolean hasNonExisting() {
        return this.entries.stream().anyMatch(path -> !Files.exists(path, new LinkOption[0]));
    }

    public String toString() {
        return this.toPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkPathSequence paths = (JkPathSequence)o;
        return this.entries.equals(paths.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        List<File> files = JkUtilsPath.toFiles(this.entries);
        oos.writeObject(files);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        List files = (List)ois.readObject();
        List<Path> paths = JkUtilsPath.toPaths(files);
        Field field = JkUtilsReflect.getField(JkPathSequence.class, "entries");
        JkUtilsReflect.setFieldValue(this, field, paths);
    }
}

