/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.resolution;

import dev.jeka.core.api.depmanagement.JkComputedDependency;
import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JkResolvedDependencyNode {
    private static final String INDENT = "    ";
    private final JkNodeInfo nodeInfo;
    private final List<JkResolvedDependencyNode> children;
    private final JkVersionProvider resolvedVersions;

    private JkResolvedDependencyNode(JkNodeInfo nodeInfo, List<JkResolvedDependencyNode> children) {
        this.nodeInfo = nodeInfo;
        this.children = children;
        this.resolvedVersions = JkResolvedDependencyNode.compute(nodeInfo, children);
    }

    static JkResolvedDependencyNode ofEmpty(JkNodeInfo nodeInfo) {
        return new JkResolvedDependencyNode(nodeInfo, new LinkedList<JkResolvedDependencyNode>());
    }

    public static JkResolvedDependencyNode ofModuleDep(JkModuleNodeInfo moduleNodeInfo, List<JkResolvedDependencyNode> children) {
        return new JkResolvedDependencyNode(moduleNodeInfo, Collections.unmodifiableList(children));
    }

    public static JkResolvedDependencyNode ofFileDep(JkFileDependency dependency, Set<String> configurations) {
        JkFileNodeInfo moduleInfo = JkFileNodeInfo.of(configurations, dependency);
        return new JkResolvedDependencyNode(moduleInfo, Collections.unmodifiableList(new LinkedList()));
    }

    JkResolvedDependencyNode mergeNonModules(List<? extends JkDependency> dependencies) {
        LinkedList<JkResolvedDependencyNode> result = new LinkedList<JkResolvedDependencyNode>();
        HashSet<JkFileDependency> addedFileDeps = new HashSet<JkFileDependency>();
        for (JkResolvedDependencyNode node : this.children) {
            if (!node.isModuleNode()) continue;
            JkResolvedDependencyNode.addFileDepsToTree(dependencies, result, addedFileDeps, node.moduleId());
            result.add(node);
        }
        JkResolvedDependencyNode.addFileDepsToTree(dependencies, result, addedFileDeps, null);
        return new JkResolvedDependencyNode(this.nodeInfo, result);
    }

    public List<Path> getResolvedFiles() {
        LinkedList<Path> list = new LinkedList<Path>();
        JkUtilsIterable.addAllWithoutDuplicate(list, this.nodeInfo.getFiles());
        for (JkResolvedDependencyNode child : this.children) {
            JkUtilsIterable.addAllWithoutDuplicate(list, child.getResolvedFiles());
        }
        return list;
    }

    public boolean isModuleNode() {
        return this.nodeInfo instanceof JkModuleNodeInfo;
    }

    public JkModuleNodeInfo getModuleInfo() {
        if (this.nodeInfo instanceof JkModuleNodeInfo) {
            return (JkModuleNodeInfo)this.nodeInfo;
        }
        throw new IllegalStateException("The current node is type of " + this.nodeInfo.getClass().getName() + " (for " + this.nodeInfo + "), so is not a module dependency as expected. Caller must check if type is correct before calling this method.");
    }

    public JkNodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public List<JkResolvedDependencyNode> getChildren() {
        return this.children;
    }

    public boolean contains(JkModuleId moduleId) {
        if (this.isModuleNode() && moduleId.equals(this.getModuleInfo().getModuleId()) && !this.getModuleInfo().isEvicted()) {
            return true;
        }
        for (JkResolvedDependencyNode child : this.children) {
            boolean contains = child.contains(moduleId);
            if (!contains) continue;
            return true;
        }
        return false;
    }

    public JkVersionProvider getResolvedVersions() {
        return this.resolvedVersions;
    }

    public Set<JkVersionedModule> getChildModules() {
        return this.resolvedModules(true);
    }

    private Set<JkVersionedModule> resolvedModules(boolean root) {
        HashSet<JkVersionedModule> result = new HashSet<JkVersionedModule>();
        if (!root && this.isModuleNode() && !this.getModuleInfo().isEvicted()) {
            result.add(this.getModuleInfo().moduleId.withVersion(this.getModuleInfo().resolvedVersion.getValue()));
        }
        for (JkResolvedDependencyNode child : this.children) {
            result.addAll(child.resolvedModules(false));
        }
        return result;
    }

    public List<JkResolvedDependencyNode> getChildren(JkModuleId moduleId) {
        LinkedList<JkResolvedDependencyNode> result = new LinkedList<JkResolvedDependencyNode>();
        for (JkResolvedDependencyNode child : this.getChildren()) {
            if (!child.getModuleInfo().getModuleId().equals(moduleId)) continue;
            result.add(child);
        }
        return result;
    }

    public JkResolvedDependencyNode getChild(JkModuleId moduleId) {
        for (JkResolvedDependencyNode node : this.children) {
            if (!node.moduleId().equals(moduleId)) continue;
            return node;
        }
        return null;
    }

    public JkResolvedDependencyNode withMerging(JkResolvedDependencyNode other) {
        LinkedList<JkResolvedDependencyNode> resultChildren = new LinkedList<JkResolvedDependencyNode>(this.children);
        for (JkResolvedDependencyNode otherNodeChild : other.children) {
            if (otherNodeChild.isModuleNode() && this.directChildrenContains(otherNodeChild.getModuleInfo().getModuleId())) continue;
            resultChildren.add(otherNodeChild);
        }
        return new JkResolvedDependencyNode(this.nodeInfo, resultChildren);
    }

    private static void addFileDepsToTree(List<? extends JkDependency> dependencies, List<JkResolvedDependencyNode> result, Set<JkFileDependency> addedFileDeps, JkModuleId moduleId) {
        for (JkDependency dependency : JkResolvedDependencyNode.depsUntilLast(dependencies, moduleId)) {
            JkFileDependency fileDep = (JkFileDependency)dependency;
            if (addedFileDeps.contains(fileDep)) continue;
            JkResolvedDependencyNode fileNode = JkResolvedDependencyNode.ofFileDep(fileDep, Collections.emptySet());
            addedFileDeps.add(fileDep);
            result.add(fileNode);
        }
    }

    public List<JkResolvedDependencyNode> toFlattenList() {
        LinkedList<JkResolvedDependencyNode> result = new LinkedList<JkResolvedDependencyNode>();
        for (JkResolvedDependencyNode child : this.getChildren()) {
            result.add(child);
            result.addAll(child.toFlattenList());
        }
        return result;
    }

    public JkResolvedDependencyNode getFirst(JkModuleId moduleId) {
        if (this.isModuleNode() && moduleId.equals(this.moduleId())) {
            return this;
        }
        for (JkResolvedDependencyNode child : this.toFlattenList()) {
            if (!child.isModuleNode() || !moduleId.equals(child.moduleId())) continue;
            return child;
        }
        return null;
    }

    private boolean directChildrenContains(JkModuleId moduleId) {
        for (JkResolvedDependencyNode dependencyNode : this.children) {
            if (!dependencyNode.isModuleNode() || !dependencyNode.moduleId().equals(moduleId)) continue;
            return true;
        }
        return false;
    }

    public List<String> toStrings() {
        if (this.isModuleNode()) {
            return this.toStrings(false, -1, new HashSet<JkModuleId>());
        }
        return Collections.singletonList(this.getModuleInfo().toString());
    }

    private List<String> toStrings(boolean showRoot, int indentLevel, Set<JkModuleId> extendedModules) {
        LinkedList<String> result = new LinkedList<String>();
        if (showRoot) {
            String label = this.nodeInfo.toString();
            result.add(JkUtilsString.repeat(INDENT, indentLevel) + label);
        }
        if (this.nodeInfo == null || this.isModuleNode() && !extendedModules.contains(this.moduleId())) {
            if (this.nodeInfo != null) {
                extendedModules.add(this.moduleId());
            }
            for (JkResolvedDependencyNode child : this.children) {
                result.addAll(child.toStrings(true, indentLevel + 1, extendedModules));
            }
        }
        return result;
    }

    public Element toDomElement(Document document, boolean root) {
        Element element;
        if (root) {
            element = document.createElement("rootDependency");
        } else {
            element = document.createElement("dependency");
            if (this.nodeInfo != null && this.nodeInfo instanceof JkModuleNodeInfo) {
                JkModuleNodeInfo moduleNodeInfo = (JkModuleNodeInfo)this.nodeInfo;
                element.setAttribute("moduleId", moduleNodeInfo.moduleId.toString());
                element.setAttribute("resolvedVersion", moduleNodeInfo.resolvedVersion.getValue());
                if (moduleNodeInfo.isEvicted()) {
                    element.setAttribute("evicted", "true");
                }
                element.setAttribute("declaredVersion", moduleNodeInfo.declaredVersion.getValue());
                element.setAttribute("configurations", String.join((CharSequence)",", moduleNodeInfo.declaredConfigurations));
            }
        }
        for (JkResolvedDependencyNode childNode : this.children) {
            Element childElement = childNode.toDomElement(document, false);
            element.appendChild(childElement);
        }
        return element;
    }

    public String toStringTree() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.toStrings()) {
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    private JkModuleId moduleId() {
        return this.getModuleInfo().getModuleId();
    }

    public String toString() {
        return this.getNodeInfo().toString();
    }

    private static List<JkDependency> depsUntilLast(List<? extends JkDependency> dependencies, JkModuleId to) {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>();
        LinkedList<JkDependency> partialResult = new LinkedList<JkDependency>();
        for (JkDependency jkDependency : dependencies) {
            if (jkDependency instanceof JkModuleDependency) {
                JkModuleDependency moduleDependency = (JkModuleDependency)jkDependency;
                if (!moduleDependency.getModuleId().equals(to)) continue;
                result.addAll(partialResult);
                partialResult.clear();
                continue;
            }
            partialResult.add(jkDependency);
        }
        if (to == null) {
            result.addAll(partialResult);
        }
        return result;
    }

    private static JkVersionProvider compute(JkNodeInfo nodeInfo, List<JkResolvedDependencyNode> children) {
        JkModuleNodeInfo moduleNodeInfo;
        JkVersionProvider result = JkVersionProvider.of();
        if (nodeInfo instanceof JkModuleNodeInfo && !(moduleNodeInfo = (JkModuleNodeInfo)nodeInfo).treeRoot && !moduleNodeInfo.isEvicted()) {
            result = result.and(moduleNodeInfo.moduleId, moduleNodeInfo.resolvedVersion);
        }
        for (JkResolvedDependencyNode child : children) {
            result = result.and(JkResolvedDependencyNode.compute(child.getNodeInfo(), child.getChildren()));
        }
        return result;
    }

    public static final class JkFileNodeInfo
    implements Serializable,
    JkNodeInfo {
        private static final long serialVersionUID = 1L;
        private final List<File> files;
        private final Set<String> configurations;
        private final JkComputedDependency computationOrigin;

        public static JkFileNodeInfo of(Set<String> configurations, JkFileDependency dependency) {
            if (dependency instanceof JkComputedDependency) {
                JkComputedDependency computedDependency = (JkComputedDependency)dependency;
                return new JkFileNodeInfo(computedDependency.getFiles(), configurations, computedDependency);
            }
            return new JkFileNodeInfo(dependency.getFiles(), configurations, null);
        }

        private JkFileNodeInfo(List<Path> files, Set<String> configurations, JkComputedDependency origin) {
            this.files = Collections.unmodifiableList(new LinkedList<File>(JkUtilsPath.toFiles(files)));
            this.configurations = Collections.unmodifiableSet(new HashSet<String>(configurations));
            this.computationOrigin = origin;
        }

        public boolean isComputed() {
            return this.computationOrigin != null;
        }

        public JkComputedDependency computationOrigin() {
            return this.computationOrigin;
        }

        @Override
        public List<Path> getFiles() {
            return JkUtilsPath.toPaths(this.files);
        }

        @Override
        public Set<String> getDeclaredConfigurations() {
            return this.configurations;
        }

        public String toString() {
            return this.files + (this.isComputed() ? " (computed)" : "");
        }
    }

    public static final class JkModuleNodeInfo
    implements Serializable,
    JkNodeInfo {
        private static final long serialVersionUID = 1L;
        private final JkModuleId moduleId;
        private final JkVersion declaredVersion;
        private final Set<String> declaredConfigurations;
        private final Set<String> rootConfigurations;
        private final JkVersion resolvedVersion;
        private final List<File> artifacts;
        private final boolean treeRoot;

        JkModuleNodeInfo(JkModuleId moduleId, JkVersion declaredVersion, Set<String> declaredConfigurations, Set<String> rootConfigurations, JkVersion resolvedVersion, List<Path> artifacts) {
            this(moduleId, declaredVersion, declaredConfigurations, rootConfigurations, resolvedVersion, artifacts, false);
        }

        JkModuleNodeInfo(JkModuleId moduleId, JkVersion declaredVersion, Set<String> declaredConfigurations, Set<String> rootConfigurations, JkVersion resolvedVersion, List<Path> artifacts, boolean treeRoot) {
            this.moduleId = moduleId;
            this.declaredVersion = declaredVersion;
            this.declaredConfigurations = declaredConfigurations;
            this.rootConfigurations = rootConfigurations;
            this.resolvedVersion = resolvedVersion;
            this.artifacts = Collections.unmodifiableList(new LinkedList<File>(JkUtilsPath.toFiles(artifacts)));
            this.treeRoot = treeRoot;
        }

        static JkModuleNodeInfo ofAnonymousRoot() {
            return new JkModuleNodeInfo(JkModuleId.of("anonymousGroup:anonymousName"), JkVersion.UNSPECIFIED, new HashSet<String>(), new HashSet<String>(), JkVersion.UNSPECIFIED, new LinkedList<Path>());
        }

        public static JkModuleNodeInfo ofRoot(JkVersionedModule versionedModule) {
            return new JkModuleNodeInfo(versionedModule.getModuleId(), versionedModule.getVersion(), new HashSet<String>(), new HashSet<String>(), versionedModule.getVersion(), new LinkedList<Path>(), true);
        }

        public static JkModuleNodeInfo of(JkModuleId moduleId, JkVersion declaredVersion, Set<String> declaredConfigurations, Set<String> rootConfigurations, JkVersion resolvedVersion, List<Path> artifacts) {
            return new JkModuleNodeInfo(moduleId, declaredVersion, declaredConfigurations, rootConfigurations, resolvedVersion, artifacts);
        }

        public JkModuleId getModuleId() {
            return this.moduleId;
        }

        public JkVersionedModule getResolvedVersionedModule() {
            return this.moduleId.withVersion(this.resolvedVersion.getValue());
        }

        public JkVersion getDeclaredVersion() {
            return this.declaredVersion;
        }

        @Override
        public Set<String> getDeclaredConfigurations() {
            return this.declaredConfigurations;
        }

        public Set<String> getRootConfigurations() {
            return this.rootConfigurations;
        }

        public JkVersion getResolvedVersion() {
            return this.resolvedVersion;
        }

        public String toString() {
            if (this.treeRoot) {
                return "Root";
            }
            String resolvedVersionName = this.isEvicted() ? "(evicted)" : this.resolvedVersion.getValue();
            String declaredVersionLabel = this.getDeclaredVersion().getValue().equals(resolvedVersionName) ? "" : " as " + this.getDeclaredVersion();
            String module = this.moduleId + ":" + this.resolvedVersion;
            if (!this.declaredConfigurations.equals(Collections.singleton("default"))) {
                module = module + " (declared " + declaredVersionLabel + this.declaredConfigurations + ")";
            }
            return module;
        }

        public boolean isEvicted() {
            return this.resolvedVersion == null;
        }

        @Override
        public List<Path> getFiles() {
            return JkUtilsPath.toPaths(this.artifacts);
        }
    }

    public static interface JkNodeInfo
    extends Serializable {
        public List<Path> getFiles();

        public Set<String> getDeclaredConfigurations();
    }
}

