/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.resolution;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.resolution.JkInternalDependencyResolver;
import dev.jeka.core.api.depmanagement.resolution.JkResolutionParameters;
import dev.jeka.core.api.depmanagement.resolution.JkResolveResult;
import dev.jeka.core.api.depmanagement.resolution.JkResolvedDependencyNode;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class JkDependencyResolver<T> {
    private final JkResolutionParameters<JkDependencyResolver<T>> defaultParameters;
    private JkVersionedModule moduleHolder;
    private JkRepoSet repos = JkRepoSet.of(new String[0]);
    private final Map<JkQualifiedDependencySet, JkResolveResult> cachedResults = new HashMap<JkQualifiedDependencySet, JkResolveResult>();
    private boolean useCache;
    public final T __;

    private JkDependencyResolver(T parent) {
        this.__ = parent;
        this.defaultParameters = JkResolutionParameters.ofParent(this);
    }

    public static JkDependencyResolver<Void> of() {
        return JkDependencyResolver.ofParent(null);
    }

    public static <T> JkDependencyResolver<T> ofParent(T parent) {
        return new JkDependencyResolver<T>(parent);
    }

    public JkRepoSet getRepos() {
        return this.repos;
    }

    public JkDependencyResolver<T> setRepos(JkRepoSet repos) {
        JkUtilsAssert.argument(repos != null, "repos cannot be null", new Object[0]);
        this.repos = repos;
        this.cachedResults.clear();
        return this;
    }

    public JkDependencyResolver<T> addRepos(JkRepoSet repos) {
        return this.setRepos(this.repos.and(repos));
    }

    public JkDependencyResolver<T> addRepos(JkRepo ... repos) {
        return this.addRepos(JkRepoSet.of(Arrays.asList(repos)));
    }

    public JkDependencyResolver<T> setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public boolean isUseCache(boolean useCache) {
        return this.useCache;
    }

    public JkDependencyResolver<T> cleanCache() {
        this.cachedResults.clear();
        return this;
    }

    public JkResolutionParameters<JkDependencyResolver<T>> getDefaultParams() {
        return this.defaultParameters;
    }

    public JkDependencyResolver<T> setModuleHolder(JkVersionedModule versionedModule) {
        this.moduleHolder = versionedModule;
        return this;
    }

    public JkResolveResult resolve(JkModuleDependency moduleDependency) {
        return this.resolve(moduleDependency, this.defaultParameters);
    }

    public JkResolveResult resolve(String dependencyDescription) {
        return this.resolve(JkModuleDependency.of(dependencyDescription));
    }

    public JkResolveResult resolve(JkModuleDependency moduleDependency, JkResolutionParameters params) {
        return this.resolve(JkDependencySet.of(moduleDependency), params);
    }

    public JkResolveResult resolve(JkDependencySet dependencies) {
        return this.resolve(dependencies, this.defaultParameters);
    }

    public JkResolveResult resolve(JkDependencySet dependencies, JkResolutionParameters params) {
        return this.resolve(JkQualifiedDependencySet.of(dependencies.normalised(JkVersionedModule.ConflictStrategy.FAIL).mergeLocalProjectExportedDependencies()), params);
    }

    public JkResolveResult resolve(JkQualifiedDependencySet qualifiedDependencies, JkResolutionParameters params) {
        JkResolveResult.JkErrorReport report;
        JkResolveResult resolveResult;
        boolean hasModule;
        JkResolveResult result;
        if (qualifiedDependencies.getEntries().isEmpty()) {
            return JkResolveResult.ofRoot(this.moduleHolder);
        }
        if (this.useCache && (result = this.cachedResults.get(qualifiedDependencies)) != null) {
            return result;
        }
        List<JkDependency> allDependencies = qualifiedDependencies.getDependencies();
        JkQualifiedDependencySet moduleQualifiedDependencies = qualifiedDependencies.withModuleDependenciesOnly().withResolvedBoms(this.repos).assertNoUnspecifiedVersion().toResolvedModuleVersions();
        boolean bl = hasModule = !moduleQualifiedDependencies.getDependencies().isEmpty();
        if (this.repos.getRepos().isEmpty() && hasModule) {
            JkLog.warn("You are trying to resolve dependencies on zero repository. Won't be possible to resolve modules.", new Object[0]);
        }
        JkInternalDependencyResolver internalDepResolver = JkInternalDependencyResolver.of(this.repos);
        String message = qualifiedDependencies.getEntries().size() == 1 ? "Resolve " + qualifiedDependencies.getDependencies().get(0).toString() : "Resolve " + qualifiedDependencies.getEntries().size() + " declared dependencies";
        JkLog.startTask(message, new Object[0]);
        if (hasModule) {
            JkUtilsAssert.state(!this.repos.getRepos().isEmpty(), "Cannot resolve module dependency cause no repos has defined on resolver " + this, new Object[0]);
            resolveResult = internalDepResolver.resolve(this.moduleHolder, moduleQualifiedDependencies, params);
        } else {
            resolveResult = JkResolveResult.ofRoot(this.moduleHolder);
        }
        JkResolvedDependencyNode mergedNode = resolveResult.getDependencyTree().mergeNonModules(allDependencies);
        resolveResult = JkResolveResult.of(mergedNode, resolveResult.getErrorReport());
        int moduleCount = resolveResult.getInvolvedModules().size();
        int fileCount = resolveResult.getFiles().getEntries().size();
        JkLog.info(JkUtilsString.pluralize(moduleCount, "module") + " -> " + JkUtilsString.pluralize(fileCount, "file"), new Object[0]);
        if (JkLog.isVerbose()) {
            resolveResult.getFiles().forEach(path -> JkLog.info(path.toString(), new Object[0]));
        }
        if ((report = resolveResult.getErrorReport()).hasErrors()) {
            if (params.isFailOnDependencyResolutionError()) {
                String msg = report.toString() + " \nRepositories = " + this.repos;
                throw new IllegalStateException(msg);
            }
            JkLog.warn(report.toString(), new Object[0]);
        }
        JkLog.endTask();
        if (this.useCache) {
            this.cachedResults.put(qualifiedDependencies, resolveResult);
        }
        return resolveResult;
    }

    public List<String> searchGroups() {
        return JkInternalDependencyResolver.of(this.repos).searchGroups();
    }

    public List<String> searchModules(String groupId) {
        return JkInternalDependencyResolver.of(this.repos).searchModules(groupId);
    }

    public List<String> searchVersions(JkModuleId moduleId) {
        return JkInternalDependencyResolver.of(this.repos).searchVersions(moduleId).stream().sorted(JkVersion.VERSION_COMPARATOR).collect(Collectors.toList());
    }

    public String toString() {
        if (this.repos == null) {
            return "No repo resolver";
        }
        return this.repos.toString();
    }
}

