/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkDependencySetMerge;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactLocator;
import dev.jeka.core.api.depmanagement.publication.JkInternalPublisher;
import dev.jeka.core.api.depmanagement.publication.JkPomMetadata;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class JkMavenPublication<T> {
    public final T __;
    private final JkPomMetadata<JkMavenPublication<T>> pomMetadata = JkPomMetadata.ofParent(this);
    private Function<JkDependencySet, JkDependencySet> dependencies = UnaryOperator.identity();
    private Supplier<JkModuleId> moduleIdSupplier = () -> null;
    private Supplier<JkVersion> versionSupplier = () -> JkVersion.UNSPECIFIED;
    private Supplier<JkArtifactLocator> artifactLocatorSupplier;
    private JkRepoSet publishRepos = JkRepoSet.ofLocal();
    private Supplier<JkRepoSet> bomResolverRepoSupplier = () -> JkRepoSet.of(new String[0]);
    private UnaryOperator<Path> defaultSigner;

    private JkMavenPublication(T parent) {
        this.__ = parent;
    }

    public static <T> JkMavenPublication<T> of(T parent) {
        return new JkMavenPublication<T>(parent);
    }

    public static <T> JkMavenPublication<Void> of() {
        return new JkMavenPublication<Object>(null);
    }

    public JkPomMetadata<JkMavenPublication<T>> getPomMetadata() {
        return this.pomMetadata;
    }

    public JkMavenPublication<T> configureDependencies(Function<JkDependencySet, JkDependencySet> modifier) {
        this.dependencies = this.dependencies.andThen(modifier);
        return this;
    }

    public JkDependencySet getDependencies() {
        return this.dependencies.apply(JkDependencySet.of());
    }

    public JkMavenPublication<T> setModuleId(String moduleId) {
        this.moduleIdSupplier = () -> JkModuleId.of(moduleId);
        return this;
    }

    public JkMavenPublication<T> setModuleId(Supplier<String> moduleIdSupplier) {
        this.moduleIdSupplier = () -> JkModuleId.of((String)moduleIdSupplier.get());
        return this;
    }

    public JkMavenPublication<T> setVersion(String version) {
        this.versionSupplier = () -> JkVersion.of(version);
        return this;
    }

    public JkMavenPublication<T> setVersion(Supplier<String> versionSupplier) {
        this.versionSupplier = () -> JkVersion.of((String)versionSupplier.get());
        return this;
    }

    public JkMavenPublication<T> setBomResolutionRepos(Supplier<JkRepoSet> repoSupplier) {
        this.bomResolverRepoSupplier = repoSupplier;
        return this;
    }

    public JkModuleId getModuleId() {
        return this.moduleIdSupplier.get();
    }

    public JkVersion getVersion() {
        return this.versionSupplier.get();
    }

    public UnaryOperator<Path> getDefaultSigner() {
        return this.defaultSigner;
    }

    public JkMavenPublication<T> setDefaultSigner(UnaryOperator<Path> defaultSigner) {
        this.defaultSigner = defaultSigner;
        return this;
    }

    public JkArtifactLocator getArtifactLocator() {
        return this.artifactLocatorSupplier.get();
    }

    public JkMavenPublication<T> setArtifactLocatorSupplier(Supplier<JkArtifactLocator> artifactLocatorSupplier) {
        this.artifactLocatorSupplier = artifactLocatorSupplier;
        return this;
    }

    public JkMavenPublication<T> setArtifactLocator(JkArtifactLocator artifactLocatorArg) {
        this.artifactLocatorSupplier = () -> artifactLocatorArg;
        return this;
    }

    public JkRepoSet getPublishRepos() {
        return this.publishRepos;
    }

    public JkMavenPublication<T> setPublishRepos(JkRepoSet repoSet) {
        this.publishRepos = repoSet;
        return this;
    }

    public JkMavenPublication<T> addRepos(JkRepo ... repoArgs) {
        Arrays.stream(repoArgs).forEach(repo -> {
            this.publishRepos = this.publishRepos.and((JkRepo)repo);
        });
        return this;
    }

    public JkMavenPublication<T> publish() {
        this.publish(this.publishRepos.withDefaultSigner(this.defaultSigner));
        return this;
    }

    public JkMavenPublication<T> publishLocal() {
        this.publish(JkRepoSet.ofLocal());
        return this;
    }

    private JkMavenPublication publish(JkRepoSet repos) {
        JkRepoSet bomRepos = this.bomResolverRepoSupplier.get().and(repos);
        JkDependencySet dependencySet = this.getDependencies().withResolvedBoms(bomRepos).assertNoUnspecifiedVersion().toResolvedModuleVersions();
        JkUtilsAssert.state(this.artifactLocatorSupplier != null, "artifact locator cannot be null.", new Object[0]);
        JkUtilsAssert.state(this.moduleIdSupplier.get() != null, "moduleId cannot be null.", new Object[0]);
        JkUtilsAssert.state(this.versionSupplier.get() != null, "version cannot be null.", new Object[0]);
        List<Path> missingFiles = this.getArtifactLocator().getMissingFiles();
        JkUtilsAssert.argument(missingFiles.isEmpty(), "One or several files to publish do not exist : " + missingFiles, new Object[0]);
        JkInternalPublisher internalPublisher = JkInternalPublisher.of(repos, null);
        JkVersionedModule versionedModule = this.getModuleId().withVersion(this.versionSupplier.get());
        internalPublisher.publishMaven(versionedModule, this.getArtifactLocator(), this.pomMetadata, dependencySet);
        return this;
    }

    public String toString() {
        return "JkMavenPublication{artifactFileLocator=" + this.artifactLocatorSupplier + ", extraInfo=" + this.pomMetadata + '}';
    }

    public static JkDependencySet computeMavenPublishDependencies(JkDependencySet compileDeps, JkDependencySet runtimeDeps, JkVersionedModule.ConflictStrategy strategy) {
        JkDependencySetMerge merge = runtimeDeps.merge(compileDeps);
        JkDependencySet mergeResult = merge.getResult().normalised(strategy);
        LinkedList<JkModuleDependency> result = new LinkedList<JkModuleDependency>();
        for (JkModuleDependency moduleDependency : mergeResult.getModuleDependencies()) {
            JkTransitivity transitivity = JkTransitivity.COMPILE;
            if (merge.getAbsentDependenciesFromRight().contains(moduleDependency)) {
                transitivity = JkTransitivity.RUNTIME;
            }
            result.add(moduleDependency.withTransitivity(transitivity));
        }
        return JkDependencySet.of(result).withVersionProvider(mergeResult.getVersionProvider());
    }
}

