/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.publication;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkDependencySetMerge;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkProjectDependencies;
import dev.jeka.core.api.depmanagement.JkQualifiedDependency;
import dev.jeka.core.api.depmanagement.JkQualifiedDependencySet;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactLocator;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactProducer;
import dev.jeka.core.api.depmanagement.publication.JkInternalPublisher;
import dev.jeka.core.api.file.JkPathFile;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class JkIvyPublication<T> {
    public final T __;
    private Supplier<JkModuleId> moduleIdSupplier = () -> null;
    private Supplier<JkVersion> versionSupplier = () -> JkVersion.UNSPECIFIED;
    private JkRepoSet repos = JkRepoSet.of(new String[0]);
    private UnaryOperator<Path> defaultSigner;
    private Function<JkQualifiedDependencySet, JkQualifiedDependencySet> dependencies = UnaryOperator.identity();
    private Supplier<? extends JkArtifactLocator> artifactLocatorSupplier;
    private JkPublishedArtifact mainArtifact;
    private final Set<JkPublishedArtifact> extraArtifacts = new HashSet<JkPublishedArtifact>();

    private JkIvyPublication(T parent) {
        this.__ = parent;
    }

    public static <T> JkIvyPublication<T> of(T parent) {
        return new JkIvyPublication<T>(parent);
    }

    public static JkIvyPublication<Void> of() {
        return new JkIvyPublication<Object>(null);
    }

    public JkIvyPublication<T> setModuleId(String moduleId) {
        this.moduleIdSupplier = () -> JkModuleId.of(moduleId);
        return this;
    }

    public JkIvyPublication<T> setModuleId(Supplier<String> moduleIdSupplier) {
        this.moduleIdSupplier = () -> JkModuleId.of((String)moduleIdSupplier.get());
        return this;
    }

    public JkIvyPublication<T> setVersion(Supplier<String> versionSupplier) {
        this.versionSupplier = () -> JkVersion.of((String)versionSupplier.get());
        return this;
    }

    public JkIvyPublication<T> setVersion(String version) {
        return this.setVersion(() -> version);
    }

    public JkModuleId getModuleId() {
        return this.moduleIdSupplier.get();
    }

    public JkVersion getVersion() {
        return this.versionSupplier.get();
    }

    public JkRepoSet getRepos() {
        return this.repos;
    }

    public JkIvyPublication<T> setRepos(JkRepoSet repos) {
        this.repos = repos;
        return this;
    }

    public JkIvyPublication<T> addRepos(JkRepo ... repoArgs) {
        Arrays.stream(repoArgs).forEach(repo -> {
            this.repos = this.repos.and((JkRepo)repo);
        });
        return this;
    }

    public JkIvyPublication<T> setDefaultSigner(UnaryOperator<Path> defaultSigner) {
        this.defaultSigner = defaultSigner;
        return this;
    }

    public JkIvyPublication<T> configureDependencies(UnaryOperator<JkQualifiedDependencySet> modifier) {
        JkUtilsAssert.argument(modifier != null, "Dependency modifier cannot be null.", new Object[0]);
        this.dependencies = this.dependencies.andThen(modifier);
        return this;
    }

    public JkIvyPublication<T> setDependencies(JkQualifiedDependencySet configuredDependencies) {
        return this.configureDependencies(deps -> configuredDependencies);
    }

    public JkIvyPublication<T> setDependencies(JkProjectDependencies projectDependencies, JkVersionedModule.ConflictStrategy conflictStrategy) {
        return this.setDependencies(JkQualifiedDependencySet.computeIvyPublishDependencies(projectDependencies, conflictStrategy));
    }

    public JkIvyPublication<T> setDependencies(JkProjectDependencies projectDependencies) {
        return this.setDependencies(projectDependencies, JkVersionedModule.ConflictStrategy.FAIL);
    }

    public JkQualifiedDependencySet getDependencies() {
        return this.dependencies.apply(JkQualifiedDependencySet.of());
    }

    public JkIvyPublication<T> clear() {
        this.artifactLocatorSupplier = null;
        this.mainArtifact = null;
        this.extraArtifacts.clear();
        return this;
    }

    public JkIvyPublication<T> addArtifacts(Supplier<JkArtifactLocator> artifactLocator) {
        this.artifactLocatorSupplier = artifactLocator;
        return this;
    }

    public JkIvyPublication<T> addArtifacts(JkArtifactProducer artifactProducer) {
        return this.addArtifacts(() -> artifactProducer);
    }

    private static List<JkPublishedArtifact> toPublishedArtifacts(JkArtifactLocator artifactLocator) {
        LinkedList<JkPublishedArtifact> result = new LinkedList<JkPublishedArtifact>();
        result.add(JkIvyPublication.toPublishedArtifact(null, artifactLocator.getMainArtifactPath(), null, "compile"));
        for (JkArtifactId artifactId : artifactLocator.getArtifactIds()) {
            if (artifactId.isMainArtifact()) continue;
            Path file = artifactLocator.getArtifactPath(artifactId);
            result.add(JkIvyPublication.toPublishedArtifact(null, file, artifactId.getName(), JkIvyPublication.configurationFor(artifactId.getName())));
        }
        return result;
    }

    public JkIvyPublication<T> setMainArtifact(Path file, String ... configurationNames) {
        return this.setMainArtifactWithType(file, null, configurationNames);
    }

    public JkIvyPublication<T> setMainArtifactWithType(Path file, String type, String ... configurationNames) {
        this.mainArtifact = JkIvyPublication.toPublishedArtifact(null, file, type, configurationNames);
        return this;
    }

    public JkIvyPublication<T> addArtifact(String artifactName, Path artifactFile, String type, String ... configurationNames) {
        this.extraArtifacts.add(new JkPublishedArtifact(artifactName, artifactFile, type, JkPathFile.of(artifactFile).getExtension(), Arrays.stream(configurationNames).collect(Collectors.toSet())));
        return this;
    }

    public JkIvyPublication<T> addOptionalArtifact(Path file, String ... configurationNames) {
        if (Files.exists(file, new LinkOption[0])) {
            return this.setMainArtifact(file, configurationNames);
        }
        return this;
    }

    public JkIvyPublication<T> addOptionalArtifactWithType(Path file, String type, String ... configurationNames) {
        if (Files.exists(file, new LinkOption[0])) {
            return this.setMainArtifactWithType(file, type, configurationNames);
        }
        return this;
    }

    public List<JkPublishedArtifact> getAllArtifacts() {
        LinkedList<JkPublishedArtifact> result = new LinkedList<JkPublishedArtifact>();
        if (this.artifactLocatorSupplier != null) {
            result.addAll(JkIvyPublication.toPublishedArtifacts(this.artifactLocatorSupplier.get()));
        }
        if (this.mainArtifact != null) {
            result.add(this.mainArtifact);
        }
        result.addAll(this.extraArtifacts);
        return result;
    }

    public void publish() {
        this.publish(this.repos);
    }

    public void publishLocal() {
        this.publish(JkRepo.ofLocalIvy().toSet());
    }

    private void publish(JkRepoSet repos) {
        JkUtilsAssert.state(this.moduleIdSupplier.get() != null, "moduleId cannot be null.", new Object[0]);
        JkUtilsAssert.state(this.versionSupplier.get() != null, "version cannot be null.", new Object[0]);
        JkInternalPublisher internalPublisher = JkInternalPublisher.of(repos.withDefaultSigner(this.defaultSigner), null);
        internalPublisher.publishIvy(this.getModuleId().withVersion(this.versionSupplier.get()), this.getAllArtifacts(), this.getDependencies());
    }

    private static JkPublishedArtifact toPublishedArtifact(String artifactName, Path artifactFile, String type, String ... configurationNames) {
        return new JkPublishedArtifact(artifactName, artifactFile, type, null, JkUtilsIterable.setOf(configurationNames).stream().collect(Collectors.toSet()));
    }

    private static String configurationFor(String classifier) {
        if ("sources".equals(classifier)) {
            return "sources";
        }
        if ("test".equals(classifier)) {
            return "test";
        }
        if ("test-sources".equals(classifier)) {
            return "test-sources";
        }
        if ("javadoc".equals(classifier)) {
            return "javadoc";
        }
        return classifier;
    }

    public static JkQualifiedDependencySet getPublishDependencies(JkDependencySet compileDependencies, JkDependencySet runtimeDependencies, JkVersionedModule.ConflictStrategy strategy) {
        JkDependencySetMerge merge = compileDependencies.merge(runtimeDependencies);
        LinkedList<JkQualifiedDependency> result = new LinkedList<JkQualifiedDependency>();
        for (JkModuleDependency moduleDependency : merge.getResult().normalised(strategy).assertNoUnspecifiedVersion().getVersionedModuleDependencies()) {
            String configuration = "compile->compile(*),master(*)";
            if (!merge.getAbsentDependenciesFromRight().contains(moduleDependency)) {
                configuration = merge.getAbsentDependenciesFromLeft().contains(moduleDependency) ? "runtime->runtime(*),master(*)" : configuration + ";runtime -> runtime(*),master(*)";
            }
            result.add(JkQualifiedDependency.of(configuration, moduleDependency));
        }
        return JkQualifiedDependencySet.of(result);
    }

    public static class JkPublishedArtifact {
        public final Path file;
        public final String type;
        public final Set<String> configurationNames;
        public final String name;
        public final String extension;

        private JkPublishedArtifact(String name, Path path, String type, String extension, Set<String> configurationNames) {
            this.file = path;
            this.extension = extension;
            this.type = type;
            this.configurationNames = configurationNames;
            this.name = name;
        }
    }
}

