/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.artifact;

import dev.jeka.core.api.depmanagement.artifact.JkArtifactId;
import dev.jeka.core.api.depmanagement.artifact.JkArtifactLocator;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;

public interface JkArtifactProducer
extends JkArtifactLocator {
    public void makeArtifact(JkArtifactId var1);

    default public void makeArtifacts(Iterable<JkArtifactId> artifactFileIds) {
        for (JkArtifactId artifactFileId : artifactFileIds) {
            this.makeArtifact(artifactFileId);
        }
    }

    default public void makeArtifacts(JkArtifactId ... artifactFileIds) {
        this.makeArtifacts(Arrays.asList(artifactFileIds));
    }

    default public void makeAllArtifacts() {
        this.makeArtifacts(this.getArtifactIds());
    }

    default public void makeMainArtifact() {
        this.makeArtifact(this.getMainArtifactId());
    }

    default public void makeMissingArtifacts(JkArtifactId ... artifactFileIds) {
        this.makeMissingArtifacts(Arrays.asList(artifactFileIds));
    }

    default public void makeMissingArtifacts(Iterable<JkArtifactId> artifactFileIds) {
        for (JkArtifactId artifactFileId : artifactFileIds) {
            Path path = this.getArtifactPath(artifactFileId);
            if (!Files.exists(path, new LinkOption[0])) {
                this.makeArtifact(artifactFileId);
                continue;
            }
            JkLog.info("Make artifact file " + JkUtilsPath.relativizeFromWorkingDir(path) + " ... Skip : already exist.", new Object[0]);
        }
    }

    default public void makeAllMissingArtifacts() {
        this.makeArtifacts(this.getArtifactIds());
    }

    @FunctionalInterface
    public static interface JkSupplier {
        public JkArtifactProducer getArtifactProducer();
    }
}

