/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement.artifact;

import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;

public final class JkArtifactId {
    public static final String MAIN_ARTIFACT_NAME = "";
    private final String name;
    private final String extension;

    private JkArtifactId(String name, String extension) {
        this.name = name.toLowerCase();
        this.extension = extension == null || extension.trim().length() == 0 ? null : extension.trim().toLowerCase();
    }

    public static JkArtifactId of(String name, String extension) {
        JkUtilsAssert.argument(name != null, "Artifact name cannot be null", new Object[0]);
        JkUtilsAssert.argument(extension != null, "Artifact extension cannot be null (but blank is ok).", new Object[0]);
        JkUtilsAssert.argument(MAIN_ARTIFACT_NAME.equals(name) || !JkUtilsString.isBlank(name), "Artifact name cannot be a blank string.", new Object[0]);
        return new JkArtifactId(name, extension);
    }

    public static JkArtifactId ofMainArtifact(String extension) {
        return JkArtifactId.of(MAIN_ARTIFACT_NAME, extension);
    }

    public boolean isMainArtifact() {
        return MAIN_ARTIFACT_NAME.equals(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toFileName(String namePart) {
        String classifier = this.isMainArtifact() ? MAIN_ARTIFACT_NAME : "-" + this.getName();
        String ext = JkUtilsString.isBlank(this.extension) ? MAIN_ARTIFACT_NAME : "." + this.getExtension();
        return namePart + classifier + ext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkArtifactId that = (JkArtifactId)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.extension != null ? this.extension.equals(that.extension) : that.extension == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        return result;
    }

    public String toString() {
        String classif = this.name == null ? "[main-artifact]" : "-" + this.name;
        return MAIN_ARTIFACT_NAME + classif + '.' + this.extension;
    }
}

