/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.ComparableVersion;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class JkVersion
implements Comparable<JkVersion> {
    public static final JkVersion UNSPECIFIED = new JkVersion("UNSPECIFIED-SNAPSHOT");
    public static final Comparator<String> VERSION_COMPARATOR = ComparableVersion.versionComparator();
    private final String value;

    public static JkVersion of(String name) {
        if (name == null) {
            return UNSPECIFIED;
        }
        return new JkVersion(name);
    }

    private JkVersion(String value) {
        JkUtilsAssert.argument(value != null, "value can't be null", new Object[0]);
        JkUtilsAssert.argument(!JkUtilsString.isBlank(value), "value can't ne blank", new Object[0]);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSnapshot() {
        return this.value.toLowerCase().endsWith("-snapshot");
    }

    public JkVersion toSnapshot() {
        if (this.isSnapshot()) {
            return this;
        }
        return JkVersion.of(this.value + "-SNAPSHOT");
    }

    @Override
    public int compareTo(JkVersion other) {
        if (this.isUnspecified()) {
            if (other.isUnspecified()) {
                return 0;
            }
            return -1;
        }
        if (other.isUnspecified()) {
            return 1;
        }
        return VERSION_COMPARATOR.compare(this.value, other.value);
    }

    public boolean isGreaterThan(JkVersion other) {
        return this.compareTo(other) > 0;
    }

    public List<String> toItems() {
        return Arrays.asList(this.value.split("\\."));
    }

    public boolean isDigitsOnly() {
        return !this.toItems().stream().anyMatch(item -> !JkUtilsString.isDigits(item));
    }

    public boolean isDynamic() {
        if (this.value.endsWith("-SNAPSHOT")) {
            return true;
        }
        return this.isDynamicAndResolvable();
    }

    public boolean isUnspecified() {
        return this.equals(UNSPECIFIED);
    }

    public boolean isDynamicAndResolvable() {
        if ("+".equals(this.value)) {
            return true;
        }
        if (JkUtilsString.endsWithAny(this.value, ".+", ")", "]", "[")) {
            return true;
        }
        if (this.value.startsWith("latest.")) {
            return true;
        }
        return JkUtilsString.startsWithAny(this.value, "[", "]", "(") && JkUtilsString.endsWithAny(this.value, ")", "]", "[");
    }

    public String getBlock(int index) {
        String[] items = this.value.split("\\.");
        if (index >= items.length) {
            throw new IllegalArgumentException("Version " + this.value + " does not contains " + (index + 1) + " blocks separated with '.'.");
        }
        return items[index];
    }

    public boolean hasBlockAt(int index) {
        String[] items = this.value.split("\\.");
        return index < items.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JkVersion other = (JkVersion)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.value;
    }
}

