/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.utils.JkUtilsIterable;
import java.util.List;

public class JkTransitivity {
    private final String value;
    public static final JkTransitivity NONE = new JkTransitivity("NONE");
    public static final JkTransitivity COMPILE = new JkTransitivity("COMPILE");
    public static final JkTransitivity RUNTIME = new JkTransitivity("RUNTIME");
    private static final List<JkTransitivity> ORDER = JkUtilsIterable.listOf(NONE, COMPILE, RUNTIME);

    private JkTransitivity(String value) {
        this.value = value;
    }

    public static JkTransitivity ofDeepest(JkTransitivity left, JkTransitivity right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return ORDER.indexOf(left) > ORDER.indexOf(right) ? left : right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkTransitivity that = (JkTransitivity)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

