/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class JkRepoFromProperties {
    public static final String MAVEN_CENTRAL_ALIAS = "mavenCentral";
    public static final String JEKA_GITHUB_ALIAS = "jekaGithub";

    public static JkRepoSet getPublishRepository() {
        return JkRepoFromProperties.getRepos("jeka.repos.publish");
    }

    public static JkRepoSet getDownloadRepos() {
        JkRepoSet repoSet = JkRepoFromProperties.getRepos("jeka.repos.download");
        if (repoSet.getRepos().isEmpty()) {
            repoSet = repoSet.and(JkRepo.ofMavenCentral());
        }
        return repoSet;
    }

    public static JkRepo getRepoByName(String name) {
        JkRepo result;
        if (MAVEN_CENTRAL_ALIAS.equals(name)) {
            return JkRepo.ofMavenCentral();
        }
        String property = "jeka.repos." + name;
        String url = JkProperties.get(property);
        if (JEKA_GITHUB_ALIAS.equals(name)) {
            result = JkRepo.ofGitHub("jeka-dev", "jeka");
        } else {
            if (JkUtilsString.isBlank(url)) {
                return null;
            }
            result = JkRepo.of(url);
        }
        JkRepo.JkRepoCredentials credentials = JkRepoFromProperties.geCredentials(property);
        result.mergeCredential(credentials);
        return result;
    }

    private static JkRepoSet getRepos(String propertyName) {
        String nameOrUrls = JkProperties.get(propertyName);
        if (JkUtilsString.isBlank(nameOrUrls)) {
            return JkRepoSet.of(new String[0]);
        }
        List<JkRepo> repos = Arrays.stream(nameOrUrls.split(",")).map(String::trim).map(nameOrUrl -> JkRepoFromProperties.getRepo(propertyName, nameOrUrl)).collect(Collectors.toList());
        return JkRepoSet.of(repos);
    }

    private static JkRepo getRepo(String propertyName, String nameOrUrl) {
        if (JkRepoFromProperties.isUrl(nameOrUrl)) {
            return JkRepo.of(nameOrUrl).setCredentials(JkRepoFromProperties.geCredentials(propertyName));
        }
        return JkRepoFromProperties.getRepoByName(nameOrUrl);
    }

    private static JkRepo.JkRepoCredentials geCredentials(String prefix) {
        String userName = JkProperties.get(prefix + ".username");
        String password = JkProperties.get(prefix + ".password");
        String realm = JkProperties.get(prefix + ".realm");
        return JkRepo.JkRepoCredentials.of(userName, password, realm);
    }

    private static List<String> downloadUrlOrNames() {
        return JkRepoFromProperties.urlOrNames(JkProperties.get("jeka.repos.download"));
    }

    private static List<String> urlOrNames(String value) {
        return Arrays.stream(value.trim().split(",")).map(String::trim).collect(Collectors.toList());
    }

    private static boolean isUrl(String nameOrUrl) {
        return JkUtilsString.startsWithAny(nameOrUrl, "http:", "https:", "file:");
    }
}

