/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkDependencySetMerge;
import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkProjectDependencies;
import dev.jeka.core.api.depmanagement.JkQualifiedDependency;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JkQualifiedDependencySet {
    public static final String COMPILE_SCOPE = "compile";
    public static final String RUNTIME_SCOPE = "runtime";
    public static final String PROVIDED_SCOPE = "provided";
    public static final String TEST_SCOPE = "test";
    public static final String MASTER_TARGET_CONF = "archives(master)";
    public static final String COMPILE_TARGET_CONF = "compile(default)";
    public static final String RUNTIME_TARGET_CONF = "runtime(default)";
    public static final String TEST_TARGET_CONF = "test(default)";
    private static final Map<JkTransitivity, String> TRANSITIVITY_TARGET_CONF_MAP = new HashMap<JkTransitivity, String>();
    private final List<JkQualifiedDependency> entries;
    private final Set<JkDependencyExclusion> globalExclusions;
    private final JkVersionProvider versionProvider;

    private JkQualifiedDependencySet(List<JkQualifiedDependency> qualifiedDependencies, Set<JkDependencyExclusion> globalExclusions, JkVersionProvider versionProvider) {
        this.entries = Collections.unmodifiableList(qualifiedDependencies);
        this.globalExclusions = Collections.unmodifiableSet(globalExclusions);
        this.versionProvider = versionProvider;
    }

    public static JkQualifiedDependencySet of() {
        return new JkQualifiedDependencySet(Collections.emptyList(), Collections.emptySet(), JkVersionProvider.of());
    }

    public static JkQualifiedDependencySet ofDependencies(List<JkDependency> dependencies) {
        return JkQualifiedDependencySet.of(dependencies.stream().map(dep -> JkQualifiedDependency.of(null, dep)).collect(Collectors.toList()));
    }

    public static JkQualifiedDependencySet of(List<JkQualifiedDependency> qualifiedDependencies) {
        return new JkQualifiedDependencySet(qualifiedDependencies, Collections.emptySet(), JkVersionProvider.of());
    }

    public static JkQualifiedDependencySet of(JkDependencySet dependencySet) {
        return JkQualifiedDependencySet.ofDependencies(dependencySet.getEntries()).withGlobalExclusions(dependencySet.getGlobalExclusions()).withVersionProvider(dependencySet.getVersionProvider());
    }

    public List<JkQualifiedDependency> getEntries() {
        return this.entries;
    }

    public List<JkDependency> getDependencies() {
        return this.entries.stream().map(JkQualifiedDependency::getDependency).collect(Collectors.toList());
    }

    public List<JkModuleDependency> getModuleDependencies() {
        return this.entries.stream().map(JkQualifiedDependency::getDependency).filter(JkModuleDependency.class::isInstance).map(JkModuleDependency.class::cast).collect(Collectors.toList());
    }

    public Set<JkDependencyExclusion> getGlobalExclusions() {
        return this.globalExclusions;
    }

    public JkVersionProvider getVersionProvider() {
        return this.versionProvider;
    }

    public List<JkQualifiedDependency> findByModule(String moduleId) {
        return this.entries.stream().filter(qDep -> qDep.getDependency() instanceof JkModuleDependency).filter(qDep -> qDep.getModuleDependency().getModuleId().toString().equals(moduleId)).collect(Collectors.toList());
    }

    public JkQualifiedDependencySet remove(JkDependency dependency) {
        List<JkQualifiedDependency> dependencies = this.entries.stream().filter(qDep -> !qDep.equals(dependency)).collect(Collectors.toList());
        return new JkQualifiedDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public JkQualifiedDependencySet and(JkQualifiedDependency qualifiedDependency) {
        LinkedList<JkQualifiedDependency> result = new LinkedList<JkQualifiedDependency>(this.entries);
        result.add(qualifiedDependency);
        return new JkQualifiedDependencySet(result, this.globalExclusions, this.versionProvider);
    }

    public JkQualifiedDependencySet and(String qualifier, JkDependency dependency) {
        return this.and(JkQualifiedDependency.of(qualifier, dependency));
    }

    public JkQualifiedDependencySet and(String qualifier, String moduleDependencyDescriptor) {
        return this.and(qualifier, JkModuleDependency.of(moduleDependencyDescriptor));
    }

    public JkQualifiedDependencySet remove(String dep) {
        return this.remove(JkModuleDependency.of(dep));
    }

    public JkQualifiedDependencySet replaceQualifier(JkDependency dependency, String qualifier) {
        List<JkQualifiedDependency> dependencies = this.entries.stream().map(qDep -> qDep.getDependency().equals(dependency) ? qDep.withQualifier(qualifier) : qDep).collect(Collectors.toList());
        return new JkQualifiedDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public JkQualifiedDependencySet replaceQualifier(String dependency, String qualifier) {
        return this.replaceQualifier(JkModuleDependency.of(dependency), qualifier);
    }

    public JkQualifiedDependencySet withQualifiersOnly(String ... qualifiers) {
        List<JkQualifiedDependency> dependencies = this.entries.stream().filter(dep -> Arrays.asList(qualifiers).contains(dep.getQualifier())).collect(Collectors.toList());
        return new JkQualifiedDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public JkQualifiedDependencySet withModuleDependenciesOnly() {
        List<JkQualifiedDependency> dependencies = this.entries.stream().filter(qDep -> qDep.getDependency() instanceof JkModuleDependency).collect(Collectors.toList());
        return new JkQualifiedDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public JkQualifiedDependencySet withGlobalExclusions(Set<JkDependencyExclusion> exclusions) {
        HashSet<JkDependencyExclusion> newExclusions = new HashSet<JkDependencyExclusion>(this.globalExclusions);
        newExclusions.addAll(exclusions);
        return new JkQualifiedDependencySet(this.entries, Collections.unmodifiableSet(newExclusions), this.versionProvider);
    }

    public JkQualifiedDependencySet withVersionProvider(JkVersionProvider versionProvider) {
        return new JkQualifiedDependencySet(this.entries, this.globalExclusions, this.versionProvider.and(versionProvider));
    }

    public JkQualifiedDependencySet withResolvedBoms(JkRepoSet repos) {
        JkVersionProvider resolvedVersionProvider = this.versionProvider.withResolvedBoms(repos);
        return new JkQualifiedDependencySet(this.entries, this.globalExclusions, resolvedVersionProvider);
    }

    public static JkQualifiedDependencySet computeIdeDependencies(JkProjectDependencies projectDependencies, JkVersionedModule.ConflictStrategy strategy) {
        JkDependencySetMerge prodMerge = projectDependencies.getCompileDeps().merge(projectDependencies.getRuntimeDeps());
        JkDependencySetMerge testMerge = prodMerge.getResult().merge(projectDependencies.getTestDeps());
        LinkedList<JkQualifiedDependency> result = new LinkedList<JkQualifiedDependency>();
        List<JkDependency> dependencies = testMerge.getResult().normalised(strategy).getEntries();
        for (JkDependency dependency : dependencies) {
            String scope = prodMerge.getResult().getEntries().contains(dependency) ? (prodMerge.getAbsentDependenciesFromRight().contains(dependency) ? PROVIDED_SCOPE : (prodMerge.getAbsentDependenciesFromLeft().contains(dependency) ? RUNTIME_SCOPE : COMPILE_SCOPE)) : TEST_SCOPE;
            JkDependency versionedDependency = testMerge.getResult().getVersionProvider().version(dependency);
            result.add(JkQualifiedDependency.of(scope, versionedDependency));
        }
        return new JkQualifiedDependencySet(result, testMerge.getResult().getGlobalExclusions(), testMerge.getResult().getVersionProvider());
    }

    public static JkQualifiedDependencySet computeIdeDependencies(JkProjectDependencies projectDependencies) {
        return JkQualifiedDependencySet.computeIdeDependencies(projectDependencies, JkVersionedModule.ConflictStrategy.FAIL);
    }

    public static JkQualifiedDependencySet computeIvyPublishDependencies(JkProjectDependencies projectDependencies, JkVersionedModule.ConflictStrategy strategy) {
        JkDependencySetMerge mergeWithProd = projectDependencies.getCompileDeps().merge(projectDependencies.getRuntimeDeps());
        JkDependencySetMerge mergeWithTest = mergeWithProd.getResult().merge(projectDependencies.getTestDeps());
        LinkedList<JkQualifiedDependency> result = new LinkedList<JkQualifiedDependency>();
        for (JkModuleDependency dependency : mergeWithTest.getResult().normalised(strategy).assertNoUnspecifiedVersion().getVersionedModuleDependencies()) {
            String configurationTarget;
            String configurationSource;
            if (mergeWithProd.getResult().getMatching(dependency) != null) {
                if (mergeWithProd.getAbsentDependenciesFromRight().contains(dependency)) {
                    configurationSource = COMPILE_SCOPE;
                    configurationTarget = "archives(master), compile(default)";
                } else if (mergeWithProd.getAbsentDependenciesFromLeft().contains(dependency)) {
                    configurationSource = RUNTIME_SCOPE;
                    configurationTarget = "archives(master), runtime(default)";
                } else {
                    configurationSource = "compile,runtime";
                    configurationTarget = "archives(master), compile(default), runtime(default)";
                }
            } else {
                configurationSource = TEST_SCOPE;
                configurationTarget = "archives(master), compile(default), runtime(default), test(default)";
            }
            if (dependency.getTransitivity() != null) {
                configurationTarget = JkQualifiedDependencySet.getIvyTargetConfigurations(dependency.getTransitivity());
            }
            String configuration = configurationSource + " -> " + configurationTarget;
            result.add(JkQualifiedDependency.of(configuration, dependency));
        }
        return new JkQualifiedDependencySet(result, mergeWithTest.getResult().getGlobalExclusions(), mergeWithTest.getResult().getVersionProvider());
    }

    public static String getIvyTargetConfigurations(JkTransitivity transitivity) {
        return TRANSITIVITY_TARGET_CONF_MAP.get(transitivity);
    }

    public List<JkDependency> getDependenciesHavingQualifier(String ... qualifiers) {
        List<String> list = Arrays.asList(qualifiers);
        return this.entries.stream().filter(qDep -> list.contains(qDep.getQualifier())).map(JkQualifiedDependency::getDependency).collect(Collectors.toList());
    }

    public JkQualifiedDependencySet assertNoUnspecifiedVersion() {
        List unspecifiedVersionModules = this.getModuleDependencies().stream().filter(dep -> this.versionProvider.getVersionOfOrUnspecified(dep.getModuleId()).isUnspecified()).filter(dep -> dep.getVersion().isUnspecified()).collect(Collectors.toList());
        JkUtilsAssert.state(unspecifiedVersionModules.isEmpty(), "Following module does not specify version : " + unspecifiedVersionModules, new Object[0]);
        return this;
    }

    public JkQualifiedDependencySet toResolvedModuleVersions() {
        List<JkQualifiedDependency> dependencies = this.entries.stream().map(qDep -> {
            if (qDep.getDependency() instanceof JkModuleDependency) {
                JkModuleDependency moduleDependency = (JkModuleDependency)qDep.getDependency();
                JkVersion providedVersion = this.versionProvider.getVersionOfOrUnspecified(moduleDependency.getModuleId());
                if (moduleDependency.getVersion().isUnspecified() && !providedVersion.isUnspecified()) {
                    return JkQualifiedDependency.of(qDep.getQualifier(), moduleDependency.withVersion(providedVersion));
                }
            }
            return qDep;
        }).collect(Collectors.toList());
        return new JkQualifiedDependencySet(dependencies, this.globalExclusions, this.versionProvider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkQualifiedDependencySet that = (JkQualifiedDependencySet)o;
        if (!this.entries.equals(that.entries)) {
            return false;
        }
        if (!this.globalExclusions.equals(that.globalExclusions)) {
            return false;
        }
        return this.versionProvider.equals(that.versionProvider);
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + this.globalExclusions.hashCode();
        result = 31 * result + this.versionProvider.hashCode();
        return result;
    }

    static {
        TRANSITIVITY_TARGET_CONF_MAP.put(JkTransitivity.NONE, MASTER_TARGET_CONF);
        TRANSITIVITY_TARGET_CONF_MAP.put(JkTransitivity.COMPILE, "archives(master), compile(default)");
        TRANSITIVITY_TARGET_CONF_MAP.put(JkTransitivity.RUNTIME, "archives(master), compile(default), runtime(default)");
    }
}

