/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsString;
import java.util.Comparator;

public final class JkModuleId {
    private final String group;
    private final String name;
    public static final Comparator<JkModuleId> GROUP_NAME_COMPARATOR = new GroupAndNameComparator();

    public static JkModuleId of(String group, String name) {
        JkUtilsAssert.argument(!JkUtilsString.isBlank(group), "Module group can't be empty", new Object[0]);
        JkUtilsAssert.argument(!JkUtilsString.isBlank(name), "Module name can't be empty", new Object[0]);
        return new JkModuleId(group, name);
    }

    public static JkModuleId of(String groupAndName) {
        if (groupAndName.contains(":")) {
            String group = JkUtilsString.substringBeforeLast(groupAndName, ":").trim();
            String name = JkUtilsString.substringAfterLast(groupAndName, ":").trim();
            return JkModuleId.of(group, name);
        }
        if (groupAndName.contains(".")) {
            String group = JkUtilsString.substringBeforeLast(groupAndName, ".").trim();
            String name = JkUtilsString.substringAfterLast(groupAndName, ".").trim();
            return JkModuleId.of(group, name);
        }
        return JkModuleId.of(groupAndName, groupAndName);
    }

    private JkModuleId(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getDotedName() {
        if (this.group.equals(this.name)) {
            return this.name;
        }
        return this.group + "." + this.name;
    }

    public String getGroupAndName() {
        return this.group + ":" + this.name;
    }

    public JkVersionedModule withVersion(String version) {
        return this.withVersion(JkVersion.of(version));
    }

    public JkVersionedModule withVersion(JkVersion version) {
        return JkVersionedModule.of(this, version);
    }

    public JkModuleDependency version(String version) {
        return JkModuleDependency.of(this, version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JkModuleId other = (JkModuleId)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.group + ":" + this.name;
    }

    private static class GroupAndNameComparator
    implements Comparator<JkModuleId> {
        private GroupAndNameComparator() {
        }

        @Override
        public int compare(JkModuleId o1, JkModuleId o2) {
            if (o1.group.equals(o2.group)) {
                return o1.name.compareTo(o2.name);
            }
            return o1.group.compareTo(o2.group);
        }
    }
}

