/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkModuleDependency;
import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsAssert;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class JkModuleFileProxy {
    private final JkRepoSet repoSet;
    private final JkModuleDependency moduleDependency;

    private JkModuleFileProxy(JkRepoSet repoSet, JkModuleDependency moduleDependency) {
        this.repoSet = repoSet;
        this.moduleDependency = moduleDependency;
    }

    public static JkModuleFileProxy of(JkRepoSet repoSet, JkModuleDependency moduleDependency) {
        return new JkModuleFileProxy(repoSet, moduleDependency);
    }

    public static JkModuleFileProxy of(JkRepoSet repoSet, String dependencyDescription) {
        return JkModuleFileProxy.of(repoSet, JkModuleDependency.of(dependencyDescription));
    }

    public static JkModuleFileProxy ofStandardRepos(String dependencyDescription) {
        return JkModuleFileProxy.of(JkRepoFromProperties.getDownloadRepos().and(JkRepo.ofMavenCentral()), dependencyDescription);
    }

    public Path get() {
        Path result = this.moduleDependency.cachePath();
        if (!Files.exists(result, new LinkOption[0])) {
            JkLog.trace("File %s not found in cache.", result);
            Path downloadPath = this.repoSet.get(this.moduleDependency);
            JkUtilsAssert.state(downloadPath != null, "Dependency %s not resolved", this.moduleDependency);
            JkUtilsAssert.state(result.equals(downloadPath), "File %s computed for caching %s is different than download file %s. Check the cache path pattern is correct in cachePath() implementation.", result, this.moduleDependency, downloadPath);
            return result;
        }
        return result;
    }
}

