/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.depmanagement.JkModuleId;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.depmanagement.JkVersionedModule;
import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.utils.JkUtilsAssert;
import dev.jeka.core.api.utils.JkUtilsIterable;
import dev.jeka.core.api.utils.JkUtilsString;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class JkModuleDependency
implements JkFileDependency.JkTransitivityDependency {
    private final JkModuleId moduleId;
    private final JkVersion version;
    private final JkTransitivity transitivity;
    private final List<JkDependencyExclusion> exclusions;
    private final Set<JkArtifactSpecification> artifactSpecifications;
    private final Path ideProjectDir;
    public static final Comparator<JkModuleDependency> GROUP_NAME_COMPARATOR = new NameComparator();

    private JkModuleDependency(JkModuleId moduleId, JkVersion version, JkTransitivity transitivity, List<JkDependencyExclusion> exclusions, Set<JkArtifactSpecification> artifactSpecifications, Path ideProjectDir) {
        JkUtilsAssert.argument(moduleId != null, "module cannot be null.", new Object[0]);
        JkUtilsAssert.argument(version != null, moduleId + " version cannot be null.", new Object[0]);
        JkUtilsAssert.argument(artifactSpecifications != null, moduleId + " artifactSpecifications cannot be null.", new Object[0]);
        JkUtilsAssert.argument(exclusions != null, moduleId + " module dependency can't be instantiated with null excludes, use empty list instead", new Object[0]);
        this.moduleId = moduleId;
        this.version = version;
        this.transitivity = transitivity;
        this.exclusions = exclusions;
        this.artifactSpecifications = artifactSpecifications;
        this.ideProjectDir = ideProjectDir;
    }

    public static JkModuleDependency of(JkModuleId moduleId) {
        return JkModuleDependency.of(moduleId, JkVersion.UNSPECIFIED);
    }

    public static JkModuleDependency of(JkModuleId moduleId, JkVersion version) {
        return new JkModuleDependency(moduleId, version, null, Collections.emptyList(), Collections.emptySet(), null);
    }

    public static JkModuleDependency of(JkVersionedModule versionedModule) {
        return JkModuleDependency.of(versionedModule.getModuleId(), versionedModule.getVersion());
    }

    public static JkModuleDependency of(JkModuleId moduleId, String versionRange) {
        return JkModuleDependency.of(moduleId.withVersion(versionRange));
    }

    public static JkModuleDependency of(String group, String name, String version) {
        return JkModuleDependency.of(JkModuleId.of(group, name), JkVersion.of(version));
    }

    public static JkModuleDependency of(String description) {
        String[] strings = description.split(":");
        String errorMessage = "Dependency specification '" + description + "' is not correct. Should be one of group:name\n, group:name:version, 'group:name:classifier:version, 'group:name:classifier:type:version'.\n'?' can be used in place of 'version' if this one is unspecified.";
        JkUtilsAssert.argument(JkModuleDependency.isModuleDependencyDescription(description), errorMessage, new Object[0]);
        JkModuleId moduleId = JkModuleId.of(strings[0], strings[1]);
        if (strings.length == 2) {
            return JkModuleDependency.of(moduleId, JkVersion.UNSPECIFIED);
        }
        if (strings.length == 3) {
            return JkModuleDependency.of(moduleId, JkVersion.of(strings[2]));
        }
        if (strings.length == 4) {
            return JkModuleDependency.of(moduleId, JkVersion.of(strings[3])).withClassifiers(strings[2]);
        }
        return JkModuleDependency.of(moduleId, JkVersion.of(strings[4])).withClassifiersAndType(strings[2], strings[3]);
    }

    public static boolean isModuleDependencyDescription(String candidate) {
        String[] strings = candidate.split(":");
        return strings.length >= 2 && strings.length <= 5;
    }

    @Override
    public JkTransitivity getTransitivity() {
        return this.transitivity;
    }

    public JkModuleId getModuleId() {
        return this.moduleId;
    }

    public JkVersion getVersion() {
        return this.version;
    }

    public JkModuleDependency withTransitivity(JkTransitivity transitivity) {
        return new JkModuleDependency(this.moduleId, this.version, transitivity, this.exclusions, this.artifactSpecifications, this.ideProjectDir);
    }

    public boolean hasUnspecifiedVersion() {
        return this.version.isUnspecified();
    }

    public JkModuleDependency withVersion(JkVersion version) {
        if (version == null) {
            return this;
        }
        return new JkModuleDependency(this.moduleId, version, this.transitivity, this.exclusions, this.artifactSpecifications, this.ideProjectDir);
    }

    public JkModuleDependency withVersion(String version) {
        if (version == null) {
            return this;
        }
        return this.withVersion(JkVersion.of(version));
    }

    public JkModuleDependency withClassifiers(String classifier) {
        return this.withClassifiersAndType(classifier, null);
    }

    public JkModuleDependency withClassifiersAndType(String classifiers, String type) {
        LinkedHashSet<JkArtifactSpecification> artifactSpecifications = new LinkedHashSet<JkArtifactSpecification>();
        for (String classifier : (classifiers + " ").split(",")) {
            artifactSpecifications.add(new JkArtifactSpecification(classifier.trim(), type));
        }
        return new JkModuleDependency(this.moduleId, this.version, this.transitivity, this.exclusions, Collections.unmodifiableSet(artifactSpecifications), this.ideProjectDir);
    }

    public JkModuleDependency andClassifier(String classifier) {
        return this.andClassifierAndType(classifier, null);
    }

    public JkModuleDependency andClassifierAndType(String classifier, String type) {
        JkArtifactSpecification artifactSpecification = new JkArtifactSpecification(classifier, type);
        LinkedHashSet<JkArtifactSpecification> set = new LinkedHashSet<JkArtifactSpecification>(this.artifactSpecifications);
        if (set.isEmpty()) {
            set.add(JkArtifactSpecification.MAIN);
        }
        set.add(artifactSpecification);
        return new JkModuleDependency(this.moduleId, this.version, this.transitivity, this.exclusions, Collections.unmodifiableSet(set), this.ideProjectDir);
    }

    public Set<JkArtifactSpecification> getArtifactSpecifications() {
        return this.artifactSpecifications;
    }

    public JkModuleDependency andExclusion(JkDependencyExclusion ... depExcludes) {
        return this.andExclusion(Arrays.asList(depExcludes));
    }

    public JkModuleDependency andExclusion(String groupAndName) {
        return this.andExclusion(JkDependencyExclusion.of(groupAndName));
    }

    public JkModuleDependency andExclusion(Iterable<JkDependencyExclusion> depExcludes) {
        LinkedList<JkDependencyExclusion> list = new LinkedList<JkDependencyExclusion>(this.exclusions);
        list.addAll(JkUtilsIterable.listOf(depExcludes));
        return new JkModuleDependency(this.moduleId, this.version, this.transitivity, Collections.unmodifiableList(list), this.artifactSpecifications, this.ideProjectDir);
    }

    public List<JkDependencyExclusion> getExclusions() {
        return this.exclusions;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.moduleId.toString());
        if (!this.version.isUnspecified()) {
            result.append(":" + this.version);
        }
        this.artifactSpecifications.forEach(spec -> result.append("(classifier=" + ((JkArtifactSpecification)spec).classifier + ", type=" + ((JkArtifactSpecification)spec).type + ")"));
        if (this.transitivity != null) {
            result.append(" transitivity:" + this.transitivity);
        }
        return result.toString();
    }

    @Override
    public Path getIdeProjectDir() {
        return this.ideProjectDir;
    }

    @Override
    public JkModuleDependency withIdeProjectDir(Path path) {
        return new JkModuleDependency(this.moduleId, this.version, this.transitivity, this.exclusions, this.artifactSpecifications, path);
    }

    public JkVersionedModule toVersionedModule() {
        return JkVersionedModule.of(this.moduleId, this.version);
    }

    private static boolean equalsOrOneIsNull(Object first, Object second) {
        if (first == null || second == null) {
            return true;
        }
        return first.equals(second);
    }

    private static boolean equalsOrOneIsUnspecified(JkVersion first, JkVersion second) {
        if (first == null || second == null) {
            return true;
        }
        if (first.isUnspecified() || second.isUnspecified()) {
            return true;
        }
        return first.equals(second);
    }

    @Override
    public boolean matches(JkDependency other) {
        if (other instanceof JkModuleDependency) {
            JkModuleDependency moduleDependency = (JkModuleDependency)other;
            return this.moduleId.equals(moduleDependency.moduleId);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JkModuleDependency that = (JkModuleDependency)o;
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (this.transitivity != null ? !this.transitivity.equals(that.transitivity) : that.transitivity != null) {
            return false;
        }
        if (!this.exclusions.equals(that.exclusions)) {
            return false;
        }
        if (!this.artifactSpecifications.equals(that.artifactSpecifications)) {
            return false;
        }
        return this.ideProjectDir != null ? this.ideProjectDir.equals(that.ideProjectDir) : that.ideProjectDir == null;
    }

    public int hashCode() {
        int result = this.moduleId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.transitivity != null ? this.transitivity.hashCode() : 0);
        result = 31 * result + this.exclusions.hashCode();
        result = 31 * result + this.artifactSpecifications.hashCode();
        result = 31 * result + (this.ideProjectDir != null ? this.ideProjectDir.hashCode() : 0);
        return result;
    }

    public Path cachePath() {
        String moduleName = this.getModuleId().getName();
        Set<JkArtifactSpecification> artifactSpecifications = this.getArtifactSpecifications();
        JkArtifactSpecification artSpec = !this.getArtifactSpecifications().isEmpty() ? this.getArtifactSpecifications().iterator().next() : JkArtifactSpecification.of("", "jar");
        String type = JkUtilsString.isBlank(artSpec.getType()) ? "jar" : artSpec.getType();
        String fileName = this.cacheFileName();
        Path path = JkLocator.getJekaRepositoryCache().resolve(this.getModuleId().getGroup()).resolve(moduleName).resolve(type + "s").resolve(fileName);
        return path;
    }

    public String cacheFileName() {
        String moduleName = this.getModuleId().getName();
        Set<JkArtifactSpecification> artifactSpecifications = this.getArtifactSpecifications();
        JkArtifactSpecification artSpec = !this.getArtifactSpecifications().isEmpty() ? this.getArtifactSpecifications().iterator().next() : JkArtifactSpecification.of("", "jar");
        String type = JkUtilsString.isBlank(artSpec.getType()) ? "jar" : artSpec.getType();
        String classifierElement = JkUtilsString.isBlank(artSpec.getClassifier()) ? "" : "-" + artSpec.getClassifier();
        return moduleName + "-" + this.getVersion() + classifierElement + "." + type;
    }

    public static class JkArtifactSpecification {
        public static final JkArtifactSpecification MAIN = new JkArtifactSpecification(null, null);
        private final String classifier;
        private final String type;

        private JkArtifactSpecification(String classifier, String type) {
            this.classifier = classifier;
            this.type = type;
        }

        public static JkArtifactSpecification of(String classifier, String type) {
            return new JkArtifactSpecification(classifier, type);
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JkArtifactSpecification that = (JkArtifactSpecification)o;
            if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
                return false;
            }
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        public int hashCode() {
            int result = this.classifier != null ? this.classifier.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    private static class NameComparator
    implements Comparator<JkModuleDependency> {
        private NameComparator() {
        }

        @Override
        public int compare(JkModuleDependency o1, JkModuleDependency o2) {
            return JkModuleId.GROUP_NAME_COMPARATOR.compare(o1.getModuleId(), o2.getModuleId());
        }
    }
}

