/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkComputedDependency;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkFileDependency;
import dev.jeka.core.api.depmanagement.JkTransitivity;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class JkLocalProjectDependency
extends JkComputedDependency
implements JkFileDependency.JkTransitivityDependency {
    private JkDependencySet exportedDependencies;
    private JkTransitivity transitivity;

    private JkLocalProjectDependency(Runnable producer, Path file, Path ideProjectDir, JkDependencySet exportedDependencies, JkTransitivity transitivity) {
        super(producer, ideProjectDir, Collections.singleton(file));
        List relocatedDependencies = exportedDependencies.getEntries().stream().map(dep -> dep.withIdeProjectDir(ideProjectDir)).collect(Collectors.toList());
        this.exportedDependencies = JkDependencySet.of(relocatedDependencies).withGlobalExclusion(exportedDependencies.getGlobalExclusions()).withVersionProvider(exportedDependencies.getVersionProvider());
        this.transitivity = transitivity;
    }

    public static JkLocalProjectDependency of(Runnable producer, Path file, Path basedir, JkDependencySet dependencies) {
        return new JkLocalProjectDependency(producer, file, basedir, dependencies, null);
    }

    public JkDependencySet getExportedDependencies() {
        if (this.transitivity == null || this.transitivity == JkTransitivity.RUNTIME) {
            return this.exportedDependencies;
        }
        if (this.transitivity == JkTransitivity.COMPILE) {
            List filteredDependencies = this.exportedDependencies.getEntries().stream().filter(JkFileDependency.JkTransitivityDependency.class::isInstance).map(JkFileDependency.JkTransitivityDependency.class::cast).filter(dep -> JkTransitivity.COMPILE.equals(dep.getTransitivity())).collect(Collectors.toList());
            return JkDependencySet.of(filteredDependencies).withVersionProvider(this.exportedDependencies.getVersionProvider()).withGlobalExclusion(this.exportedDependencies.getGlobalExclusions());
        }
        return JkDependencySet.of();
    }

    @Override
    public JkTransitivity getTransitivity() {
        return this.transitivity;
    }

    @Override
    public JkLocalProjectDependency withIdeProjectDir(Path path) {
        return new JkLocalProjectDependency(this.runnable, (Path)this.files.iterator().next(), path, this.exportedDependencies, this.transitivity);
    }

    public JkLocalProjectDependency withTransitivity(JkTransitivity transitivity) {
        return new JkLocalProjectDependency(this.runnable, (Path)this.files.iterator().next(), this.getIdeProjectDir(), this.exportedDependencies, transitivity);
    }

    public JkLocalProjectDependency withoutExportedDependencies() {
        return new JkLocalProjectDependency(this.runnable, (Path)this.files.iterator().next(), this.getIdeProjectDir(), JkDependencySet.of(), this.transitivity);
    }

    @Override
    public String toString() {
        return "Project : " + this.getIdeProjectDir();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JkLocalProjectDependency that = (JkLocalProjectDependency)o;
        if (!this.exportedDependencies.equals(that.exportedDependencies)) {
            return false;
        }
        return this.transitivity != null ? this.transitivity.equals(that.transitivity) : that.transitivity == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exportedDependencies.hashCode();
        result = 31 * result + (this.transitivity != null ? this.transitivity.hashCode() : 0);
        return result;
    }
}

