/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.api.depmanagement;

import dev.jeka.core.api.depmanagement.JkDependency;
import dev.jeka.core.api.depmanagement.JkDependencyExclusion;
import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.depmanagement.JkVersionProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class JkDependencySetMerge {
    private final List<JkDependency> absentDependenciesFromLeft;
    private final List<JkDependency> absentDependenciesFromRight;
    private final JkDependencySet result;

    private JkDependencySetMerge(List<JkDependency> absentDependenciesFromLeft, List<JkDependency> absentDependenciesFromRight, JkDependencySet result) {
        this.absentDependenciesFromLeft = absentDependenciesFromLeft;
        this.absentDependenciesFromRight = absentDependenciesFromRight;
        this.result = result;
    }

    public List<JkDependency> getAbsentDependenciesFromLeft() {
        return this.absentDependenciesFromLeft;
    }

    public List<JkDependency> getAbsentDependenciesFromRight() {
        return this.absentDependenciesFromRight;
    }

    public JkDependencySet getResult() {
        return this.result;
    }

    public static JkDependencySetMerge of(JkDependencySet left, JkDependencySet right) {
        LinkedList<JkDependency> result = new LinkedList<JkDependency>();
        LinkedList<JkDependency> absentFromLeft = new LinkedList<JkDependency>();
        LinkedList<JkDependency> absentFromRight = new LinkedList<JkDependency>();
        for (JkDependency leftDep : left.getEntries()) {
            JkDependency matchingRightDep = right.getMatching(leftDep);
            if (matchingRightDep == null) {
                absentFromRight.add(leftDep);
            }
            result.add(leftDep);
        }
        for (JkDependency rightDep : right.getEntries()) {
            JkDependency matchingLeftDep = left.getMatching(rightDep);
            if (matchingLeftDep != null) continue;
            absentFromLeft.add(rightDep);
            result.add(rightDep);
        }
        JkVersionProvider mergedVersionProvider = left.getVersionProvider().and(right.getVersionProvider());
        HashSet<JkDependencyExclusion> mergedExcludes = new HashSet<JkDependencyExclusion>(left.getGlobalExclusions());
        mergedExcludes.addAll(right.getGlobalExclusions());
        JkDependencySet mergedDependencySet = JkDependencySet.of(result).withGlobalExclusion(mergedExcludes).withVersionProvider(mergedVersionProvider);
        return new JkDependencySetMerge(absentFromLeft, absentFromRight, mergedDependencySet);
    }
}

